/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils;
import org.openstreetmap.josm.plugins.ohe.parser.OpeningTimeCompilerConstants;
import org.openstreetmap.josm.plugins.ohe.parser.OpeningTimeCompilerTokenManager;
import org.openstreetmap.josm.plugins.ohe.parser.ParseException;
import org.openstreetmap.josm.plugins.ohe.parser.SimpleCharStream;
import org.openstreetmap.josm.plugins.ohe.parser.SyntaxException;
import org.openstreetmap.josm.plugins.ohe.parser.Token;

public class OpeningTimeCompiler
implements OpeningTimeCompilerConstants {
    public static final String[] WEEKDAYS = new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};
    public OpeningTimeCompilerTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[9];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    public OpeningTimeCompiler(String time) {
        this(new ByteArrayInputStream(time.getBytes()), "utf-8");
    }

    public final ArrayList<OpeningTimeUtils.DateTime> startCompile() throws ParseException, ParseException, SyntaxException {
        Vector<Token> usedTokens = new Vector<Token>();
        ArrayList<Object> time = new ArrayList();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 4: {
                time = this.timespanlist(usedTokens);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(0);
        if (time.size() == 0) {
            ArrayList<OpeningTimeUtils.DaySpan> daySpans = new ArrayList<OpeningTimeUtils.DaySpan>();
            daySpans.add(new OpeningTimeUtils.DaySpan(0, 6));
            ArrayList<OpeningTimeUtils.DaytimeSpan> timeSpans = new ArrayList<OpeningTimeUtils.DaytimeSpan>();
            timeSpans.add(new OpeningTimeUtils.DaytimeSpan(0, 1440));
            time.add(new OpeningTimeUtils.DateTime(daySpans, timeSpans));
        }
        return time;
    }

    public final ArrayList<OpeningTimeUtils.DateTime> timespanlist(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        ArrayList<OpeningTimeUtils.DateTime> list = new ArrayList<OpeningTimeUtils.DateTime>();
        OpeningTimeUtils.DateTime first = null;
        ArrayList<OpeningTimeUtils.DateTime> second = null;
        first = this.timespan(usedTokens);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                second = this.timespanlist(usedTokens);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        list.add(first);
        if (second != null) {
            list.addAll(second);
        }
        return list;
    }

    public final OpeningTimeUtils.DateTime timespan(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        ArrayList<OpeningTimeUtils.DaySpan> dayspanlist = new ArrayList<OpeningTimeUtils.DaySpan>();
        dayspanlist.add(new OpeningTimeUtils.DaySpan(0, 6));
        ArrayList<OpeningTimeUtils.DaytimeSpan> daytimespanlist = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: {
                dayspanlist = this.dayspanlist(usedTokens);
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        daytimespanlist = this.daytimespanlist(usedTokens);
        return new OpeningTimeUtils.DateTime(dayspanlist, daytimespanlist);
    }

    public final ArrayList<OpeningTimeUtils.DaytimeSpan> daytimespanlist(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        ArrayList<OpeningTimeUtils.DaytimeSpan> list = new ArrayList<OpeningTimeUtils.DaytimeSpan>();
        ArrayList<Object> second = new ArrayList();
        OpeningTimeUtils.DaytimeSpan first = this.daytimespan(usedTokens);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                second = this.daytimespanlist(usedTokens);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        list.add(first);
        if (second != null) {
            list.addAll(second);
        }
        return list;
    }

    public final OpeningTimeUtils.DaytimeSpan daytimespan(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        int start;
        int end = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: {
                start = this.off(usedTokens);
                break;
            }
            case 1: {
                start = this.daytime(usedTokens);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        end = this.openend(usedTokens);
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        end = this.daytime(usedTokens);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (end < 0) {
            end = start;
        } else if (end < start) {
            throw new SyntaxException(null, usedTokens.lastElement().beginColumn - 1, usedTokens.lastElement().endColumn + 1);
        }
        return new OpeningTimeUtils.DaytimeSpan(start, end);
    }

    public final int daytime(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        Token th1 = this.jj_consume_token(1);
        Token th0 = this.jj_consume_token(1);
        this.jj_consume_token(10);
        Token tm1 = this.jj_consume_token(1);
        Token tm0 = this.jj_consume_token(1);
        usedTokens.add(th1);
        usedTokens.add(th0);
        usedTokens.add(tm1);
        usedTokens.add(tm0);
        int hour = Integer.parseInt(th1.image) * 10 + Integer.parseInt(th0.image);
        int minute = Integer.parseInt(tm1.image) * 10 + Integer.parseInt(tm0.image);
        if (hour > 24) {
            throw new SyntaxException(null, th1.beginColumn - 1, th0.endColumn + 1);
        }
        if (minute >= 60 || hour == 24 && minute != 0) {
            throw new SyntaxException(null, tm1.beginColumn - 1, tm0.endColumn + 1);
        }
        return hour * 60 + minute;
    }

    public final int openend(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        Token plus = this.jj_consume_token(3);
        usedTokens.add(plus);
        return 1441;
    }

    public final int off(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        Token off = this.jj_consume_token(4);
        usedTokens.add(off);
        return -1;
    }

    public final ArrayList<OpeningTimeUtils.DaySpan> dayspanlist(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        ArrayList<OpeningTimeUtils.DaySpan> list = new ArrayList<OpeningTimeUtils.DaySpan>();
        ArrayList<OpeningTimeUtils.DaySpan> second = null;
        OpeningTimeUtils.DaySpan first = this.dayspan(usedTokens);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                second = this.dayspanlist(usedTokens);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        if (second == null) {
            list.add(first);
        } else if (first.endDay + 1 == second.get((int)0).startDay) {
            list.addAll(second);
            list.set(0, new OpeningTimeUtils.DaySpan(first.startDay, second.get((int)0).endDay));
        } else {
            list.add(first);
            list.addAll(second);
        }
        return list;
    }

    public final OpeningTimeUtils.DaySpan dayspan(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        int end = -1;
        int start = this.day(usedTokens);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                end = this.day(usedTokens);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        if (end < 0) {
            end = start;
        } else if (end < start) {
            throw new SyntaxException(null, usedTokens.lastElement().beginColumn - 1, usedTokens.lastElement().endColumn + 1);
        }
        return new OpeningTimeUtils.DaySpan(start, end);
    }

    public final int day(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
        Token t = this.jj_consume_token(2);
        usedTokens.add(t);
        for (int i = 0; i < WEEKDAYS.length; ++i) {
            if (!WEEKDAYS[i].equals(t.image)) continue;
            return i;
        }
        throw new SyntaxException(null, t.beginColumn - 1, t.endColumn + 1);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{54, 64, 4, 256, 512, 8, 18, 256, 512};
    }

    public OpeningTimeCompiler(InputStream stream) {
        this(stream, null);
    }

    public OpeningTimeCompiler(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new OpeningTimeCompilerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public OpeningTimeCompiler(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new OpeningTimeCompilerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new OpeningTimeCompilerTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public OpeningTimeCompiler(OpeningTimeCompilerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(OpeningTimeCompilerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 9; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[11];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 9; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 11; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        OpeningTimeCompiler.jj_la1_init_0();
    }
}

