/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.plugins.buildings_tools.AdvancedSettingsDialog;
import org.openstreetmap.josm.plugins.buildings_tools.MyDialog;
import org.openstreetmap.josm.plugins.buildings_tools.ToolSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BuildingSizeDialog
extends MyDialog {
    private final JFormattedTextField twidth = new JFormattedTextField(NumberFormat.getInstance());
    private final JFormattedTextField tlenstep = new JFormattedTextField(NumberFormat.getInstance());
    private final JCheckBox caddr = new JCheckBox(I18n.tr((String)"Use Address dialog", (Object[])new Object[0]));
    private final JCheckBox cAutoSelect = new JCheckBox(I18n.tr((String)"Auto-select building", (Object[])new Object[0]));
    private final JCheckBox cAutoSelectReplaceSelection = new JCheckBox(I18n.tr((String)"Auto-select replaces existing selection", (Object[])new Object[0]));
    private final JCheckBox cAddrNode = new JCheckBox(I18n.tr((String)"Use address nodes under buildings", (Object[])new Object[0]));
    private final JRadioButton circleRadio = new JRadioButton(I18n.tr((String)"Circle", (Object[])new Object[0]));
    private final JRadioButton rectangleRadio = new JRadioButton(I18n.tr((String)"Rectangle", (Object[])new Object[0]));

    public BuildingSizeDialog() {
        super(I18n.tr((String)"Set buildings size and shape", (Object[])new Object[0]));
        ButtonGroup shapeGroup = new ButtonGroup();
        shapeGroup.add(this.circleRadio);
        shapeGroup.add(this.rectangleRadio);
        this.circleRadio.setSelected(ToolSettings.Shape.CIRCLE == ToolSettings.getShape());
        this.rectangleRadio.setSelected(ToolSettings.Shape.RECTANGLE == ToolSettings.getShape());
        this.panel.add((Component)this.rectangleRadio, GBC.eol().fill(2));
        this.panel.add((Component)this.circleRadio, GBC.eol().fill(2));
        this.addLabelled(I18n.tr((String)"Buildings width/diameter:", (Object[])new Object[0]), this.twidth);
        this.addLabelled(I18n.tr((String)"Length step:", (Object[])new Object[0]), this.tlenstep);
        this.panel.add((Component)this.caddr, GBC.eol().fill(2));
        this.panel.add((Component)this.cAutoSelect, GBC.eol().fill(2));
        this.panel.add((Component)this.cAutoSelectReplaceSelection, GBC.eol().fill(2));
        this.panel.add((Component)this.cAddrNode, GBC.eol().fill(2));
        this.twidth.setValue(ToolSettings.getWidth());
        this.tlenstep.setValue(ToolSettings.getLenStep());
        this.caddr.setSelected(ToolSettings.isUsingAddr());
        this.cAutoSelect.setSelected(ToolSettings.isAutoSelect());
        this.cAutoSelectReplaceSelection.setSelected(ToolSettings.isAutoSelectReplaceSelection());
        this.cAddrNode.setSelected(ToolSettings.PROP_USE_ADDR_NODE.get());
        JButton bAdv = new JButton(I18n.tr((String)"Advanced...", (Object[])new Object[0]));
        bAdv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AdvancedSettingsDialog dlg = new AdvancedSettingsDialog();
                if (dlg.getValue() == 1) {
                    dlg.saveSettings();
                }
            }
        });
        this.panel.add((Component)bAdv, GBC.eol().insets(0, 5, 0, 0).anchor(13));
        this.setupDialog();
        this.showDialog();
    }

    public final double width() {
        try {
            return NumberFormat.getInstance().parse(this.twidth.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public double lenstep() {
        try {
            return NumberFormat.getInstance().parse(this.tlenstep.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public final boolean useAddr() {
        return this.caddr.isSelected();
    }

    public final void saveSettings() {
        if (this.circleRadio.isSelected()) {
            ToolSettings.saveShape(ToolSettings.Shape.CIRCLE);
        } else if (this.rectangleRadio.isSelected()) {
            ToolSettings.saveShape(ToolSettings.Shape.RECTANGLE);
        }
        ToolSettings.setSizes(this.width(), this.lenstep());
        ToolSettings.setAddrDialog(this.useAddr());
        ToolSettings.setAutoSelect(this.cAutoSelect.isSelected());
        ToolSettings.setAutoSelectReplaceSelection(this.cAutoSelectReplaceSelection.isSelected());
        ToolSettings.PROP_USE_ADDR_NODE.put(Boolean.valueOf(this.cAddrNode.isSelected()));
    }
}

