/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.jcs3.access.CacheAccess;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.plugins.imageio.Artifact;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class NexusDownloader {
    private static final CacheAccess<String, ResponseHeader> CACHED_RESPONSES_HEAD = JCSCacheManager.getCache((String)"imageio.maven.head", (int)100, (int)0, null);
    private static final CacheAccess<String, String> CACHED_RESPONSES_GET = JCSCacheManager.getCache((String)"imageio.maven.get", (int)100, (int)0, null);
    private static Path cacheDirectory;

    private NexusDownloader() {
    }

    static void setDownloadDirectory(File cacheDirectory) {
        if (NexusDownloader.cacheDirectory != null) {
            throw new IllegalStateException("setDownloadDirectory can only be called once!");
        }
        NexusDownloader.cacheDirectory = cacheDirectory.getAbsoluteFile().toPath();
    }

    static Set<String> download(Artifact artifact) {
        try {
            if (artifact.version() == null) {
                artifact = NexusDownloader.getLatest(artifact);
            }
            return new TreeSet<Artifact>(NexusDownloader.getDependencies(artifact)).stream().map(NexusDownloader::realDownload).collect(Collectors.toCollection(TreeSet::new));
        }
        catch (IOException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
    }

    private static String realDownload(Artifact artifact) {
        Path output;
        try {
            boolean alreadyDownloaded;
            if (artifact.version() == null) {
                artifact = NexusDownloader.getLatest(artifact);
            }
            String baseName = artifact.group() + "." + artifact.artifact();
            output = cacheDirectory.resolve(artifact.getLocalName());
            URL jarUrl = URI.create(artifact.jar()).toURL();
            ResponseHeader head = (ResponseHeader)CACHED_RESPONSES_HEAD.get((Object)artifact.jar(), () -> {
                HttpClient client = HttpClient.create((URL)jarUrl, (String)"HEAD");
                try {
                    HttpClient.Response response = client.connect();
                    ResponseHeader responseHeader = new ResponseHeader(response.getHeaderField("ETag"), response.getContentLength(), response.getLastModified());
                    return responseHeader;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    client.disconnect();
                }
            });
            boolean bl = alreadyDownloaded = Files.exists(output, new LinkOption[0]) && head.size() == Files.size(output) && Files.getLastModifiedTime(output, new LinkOption[0]).toMillis() == head.lastModified() && NexusDownloader.checkETag(output, head.etag());
            if (!alreadyDownloaded) {
                HttpClient client = HttpClient.create((URL)jarUrl);
                HttpClient.Response response = client.connect();
                try (OutputStream writer = Files.newOutputStream(output, new OpenOption[0]);){
                    InputStream is = response.getContent();
                    is.transferTo(writer);
                    Files.setLastModifiedTime(output, FileTime.fromMillis(response.getLastModified()));
                }
                client.disconnect();
            }
            try (Stream<Path> files = Files.walk(cacheDirectory, new FileVisitOption[0]);){
                files.filter(path -> path.startsWith(baseName) && !path.equals(output)).filter(Files::isWritable).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        catch (IOException exception) {
            throw new JosmRuntimeException((Throwable)exception);
        }
        return output.toString();
    }

    private static boolean checkETag(Path path, String etag) {
        String expected;
        MessageDigest md;
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        if (etag.startsWith("{SHA1{")) {
            try {
                md = MessageDigest.getInstance("SHA-1");
                expected = etag.substring("{SHA1{".length(), etag.length() - 2);
            }
            catch (NoSuchAlgorithmException e) {
                throw new JosmRuntimeException((Throwable)e);
            }
        } else {
            return true;
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
             DigestInputStream dis = new DigestInputStream(is, md);){
            byte[] tByte = new byte[4096];
            while (dis.readNBytes(tByte, 0, tByte.length) > 0) {
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
            return false;
        }
        return expected.equals(Utils.toHexString((byte[])md.digest()));
    }

    private static Set<Artifact> getDependencies(Artifact artifact) throws IOException {
        TreeSet<Artifact> treeSet;
        URL url = URI.create(artifact.pom()).toURL();
        String text = (String)CACHED_RESPONSES_GET.get((Object)artifact.pom(), () -> {
            HttpClient client = HttpClient.create((URL)url);
            try {
                String string = client.connect().fetchContent();
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                client.disconnect();
            }
        });
        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        try {
            MavenDependenciesHandler handler = new MavenDependenciesHandler();
            XmlUtils.newSafeSAXParser().parse((InputStream)is, (DefaultHandler)handler);
            TreeSet<Artifact> dependencies = new TreeSet<Artifact>(handler.dependencies);
            dependencies.add(artifact);
            for (Artifact dependency : handler.dependencies) {
                if (dependency.version() == null) {
                    dependency = NexusDownloader.getLatest(dependency);
                }
                dependencies.addAll(NexusDownloader.getDependencies(dependency));
            }
            treeSet = dependencies;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new JosmRuntimeException((Throwable)e);
            }
        }
        is.close();
        return treeSet;
    }

    private static Artifact getLatest(Artifact artifact) throws IOException {
        Artifact artifact2;
        URL url = URI.create(artifact.versions()).toURL();
        String text = (String)CACHED_RESPONSES_GET.get((Object)artifact.versions(), () -> {
            HttpClient client = HttpClient.create((URL)url);
            try {
                String string = client.connect().fetchContent();
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                client.disconnect();
            }
        });
        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        try {
            MavenMetadataHandler handler = new MavenMetadataHandler();
            XmlUtils.newSafeSAXParser().parse((InputStream)is, (DefaultHandler)handler);
            String version = Utils.firstNotEmptyString((String)handler.release, (String[])new String[]{handler.latest, handler.versions.stream().filter(v -> !v.contains("rc") && !v.contains("b")).findFirst().orElse(artifact.version())});
            artifact2 = new Artifact(artifact.group(), artifact.artifact(), version);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new JosmRuntimeException((Throwable)e);
            }
        }
        is.close();
        return artifact2;
    }

    static {
        CACHED_RESPONSES_GET.getDefaultElementAttributes().setMaxLife(TimeUnit.SECONDS.toMillis(Config.getPref().getLong("mirror.maxtime", TimeUnit.DAYS.toSeconds(7L))));
    }

    private record ResponseHeader(String etag, long size, long lastModified) {
    }

    private static class MavenDependenciesHandler
    extends DefaultHandler {
        private final List<Artifact> dependencies = new ArrayList<Artifact>();
        private final StringBuilder characters = new StringBuilder();
        private Artifact parent;
        private String groupId;
        private String artifactId;
        private String version;
        private String type;
        private String scope;

        private MavenDependenciesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.characters.setLength(0);
            if ("dependency".equals(qName) || "parent".equals(qName)) {
                this.groupId = null;
                this.artifactId = null;
                this.version = null;
                this.type = null;
                this.scope = null;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("parent".equals(qName) && this.groupId != null && this.artifactId != null) {
                this.parent = new Artifact(this.groupId, this.artifactId, this.version);
            } else if ("dependency".equals(qName) && this.groupId != null && this.artifactId != null) {
                if (!("test-jar".equals(this.type) || "test".equals(this.scope) || "provided".equals(this.scope))) {
                    this.dependencies.add(new Artifact(this.groupId, this.artifactId, this.version));
                }
            } else if ("groupId".equals(qName)) {
                this.groupId = this.characters.toString();
                if ("${project.groupId}".equals(this.groupId)) {
                    this.groupId = this.parent.group();
                }
            } else if ("artifactId".equals(qName)) {
                this.artifactId = this.characters.toString();
            } else if ("version".equals(qName)) {
                this.version = this.characters.toString();
            } else if ("type".equals(qName)) {
                this.type = this.characters.toString();
            } else if ("scope".equals(qName)) {
                this.scope = this.characters.toString();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            this.characters.append(ch, start, length);
        }
    }

    private static class MavenMetadataHandler
    extends DefaultHandler {
        private final StringBuilder characters = new StringBuilder();
        private final List<String> versions = new ArrayList<String>();
        private String latest;
        private String release;

        private MavenMetadataHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.characters.setLength(0);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("latest".equals(qName)) {
                this.latest = this.characters.toString();
            } else if ("release".equals(qName)) {
                this.release = this.characters.toString();
            } else if ("version".equals(qName)) {
                this.versions.add(this.characters.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            this.characters.append(ch, start, length);
        }
    }
}

