/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.npm;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuth20Parameters;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.plugins.npm.NPMType;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class NPMCredentialsAgent
extends AbstractCredentialsAgent {
    private KeyringProvider provider;
    private final NPMType type;
    private final Map<Authenticator.RequestorType, PasswordAuthentication> credentialsCache = new EnumMap<Authenticator.RequestorType, PasswordAuthentication>(Authenticator.RequestorType.class);

    public NPMCredentialsAgent(NPMType type) {
        this.type = type;
    }

    private KeyringProvider getProvider() {
        if (this.provider == null) {
            this.provider = this.type.getProvider();
        }
        return this.provider;
    }

    protected String getServerDescriptor() {
        String pref = Preferences.main().getPreferenceFile().getAbsolutePath();
        String url = Config.getPref().get("osm-server.url", null);
        if (url == null) {
            url = Config.getUrls().getDefaultOsmApiUrl();
        }
        CRC32 id = new CRC32();
        id.update((pref + "/" + url).getBytes(StandardCharsets.UTF_8));
        String hash = Integer.toHexString((int)id.getValue());
        return "JOSM.native-password-manager-plugin.api." + hash;
    }

    protected String getProxyDescriptor() {
        String pref = Preferences.main().getPreferenceFile().getAbsolutePath();
        String host = Config.getPref().get("proxy.http.host", "");
        String port = Config.getPref().get("proxy.http.port", "");
        CRC32 id = new CRC32();
        id.update((pref + "/" + host + "/" + port).getBytes(StandardCharsets.UTF_8));
        String hash = Integer.toHexString((int)id.getValue());
        return "JOSM.native-password-manager-plugin.proxy." + hash;
    }

    protected String getOAuthDescriptor() {
        String pref = Preferences.main().getPreferenceFile().getAbsolutePath();
        CRC32 id = new CRC32();
        id.update(pref.getBytes(StandardCharsets.UTF_8));
        String hash = Integer.toHexString((int)id.getValue());
        return "JOSM.native-password-manager-plugin.oauth." + hash;
    }

    public PasswordAuthentication lookup(Authenticator.RequestorType rt, String host) {
        PasswordAuthentication auth;
        PasswordAuthentication cache = this.credentialsCache.get((Object)rt);
        if (cache != null) {
            return cache;
        }
        switch (rt) {
            case SERVER: {
                char[] password;
                String user;
                if (OsmApi.getOsmApi().getHost().equals(host)) {
                    user = NPMCredentialsAgent.stringNotNull(this.getProvider().read(this.getServerDescriptor() + ".username"));
                    password = this.getProvider().read(this.getServerDescriptor() + ".password");
                } else {
                    user = NPMCredentialsAgent.stringNotNull(this.getProvider().read(host + ".username"));
                    password = this.getProvider().read(host + ".password");
                }
                auth = new PasswordAuthentication(user, password == null ? new char[]{} : password);
                break;
            }
            case PROXY: {
                String user = NPMCredentialsAgent.stringNotNull(this.getProvider().read(this.getProxyDescriptor() + ".username"));
                char[] password = this.getProvider().read(this.getProxyDescriptor() + ".password");
                auth = new PasswordAuthentication(user, password == null ? new char[]{} : password);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.credentialsCache.put(rt, auth);
        return auth;
    }

    public void store(Authenticator.RequestorType rt, String host, PasswordAuthentication credentials) {
        String passwordDescription;
        String usernameDescription;
        String prefix;
        char[] password;
        char[] username;
        if (credentials == null) {
            username = null;
            password = null;
        } else {
            username = credentials.getUserName() == null ? null : credentials.getUserName().toCharArray();
            password = credentials.getPassword();
        }
        if (username != null && username.length == 0) {
            username = null;
        }
        switch (rt) {
            case SERVER: {
                if (OsmApi.getOsmApi().getHost().equals(host)) {
                    prefix = this.getServerDescriptor();
                    usernameDescription = I18n.tr((String)"JOSM/OSM API/Username", (Object[])new Object[0]);
                    passwordDescription = I18n.tr((String)"JOSM/OSM API/Password", (Object[])new Object[0]);
                    break;
                }
                prefix = host;
                usernameDescription = I18n.tr((String)"{0}/Username", (Object[])new Object[]{host});
                passwordDescription = I18n.tr((String)"{0}/Password", (Object[])new Object[]{host});
                break;
            }
            case PROXY: {
                prefix = this.getProxyDescriptor();
                usernameDescription = I18n.tr((String)"JOSM/Proxy/Username", (Object[])new Object[0]);
                passwordDescription = I18n.tr((String)"JOSM/Proxy/Password", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (username == null) {
            this.getProvider().delete(prefix + ".username");
            this.getProvider().delete(prefix + ".password");
            this.credentialsCache.remove((Object)rt);
        } else {
            this.getProvider().save(prefix + ".username", username, usernameDescription);
            if (password == null) {
                this.getProvider().delete(prefix + ".password");
            } else {
                this.getProvider().save(prefix + ".password", password, passwordDescription);
            }
            this.credentialsCache.put(rt, new PasswordAuthentication(NPMCredentialsAgent.stringNotNull(username), password != null ? password : new char[]{}));
        }
    }

    public IOAuthToken lookupOAuthAccessToken(String host) throws CredentialsAgentException {
        String prolog = this.getOAuthDescriptor();
        OAuthVersion[] versions = OAuthVersion.values();
        for (int i = versions.length - 1; i >= 0; --i) {
            OAuthVersion version = versions[i];
            char[] tokenObject = this.getProvider().read(prolog + ".object." + String.valueOf(version) + "." + host);
            char[] parametersObject = this.getProvider().read(prolog + ".parameters." + String.valueOf(version) + "." + host);
            if (version != OAuthVersion.OAuth20 || tokenObject == null || tokenObject.length <= 0 || parametersObject == null || parametersObject.length <= 0) continue;
            OAuth20Parameters oAuth20Parameters = new OAuth20Parameters(NPMCredentialsAgent.stringNotNull(parametersObject));
            try {
                return new OAuth20Token((IOAuthParameters)oAuth20Parameters, NPMCredentialsAgent.stringNotNull(tokenObject));
            }
            catch (OAuth20Exception e) {
                throw new CredentialsAgentException((Throwable)e);
            }
        }
        return null;
    }

    public void storeOAuthAccessToken(String host, IOAuthToken accessToken) {
        String prolog = this.getOAuthDescriptor();
        if (accessToken == null) {
            for (OAuthVersion version : OAuthVersion.values()) {
                this.getProvider().delete(prolog + ".object." + String.valueOf(version) + "." + host);
                this.getProvider().delete(prolog + ".parameters." + String.valueOf(version) + "." + host);
            }
        } else {
            OAuthVersion oauthType = accessToken.getOAuthType();
            this.getProvider().save(prolog + ".object." + String.valueOf(oauthType) + "." + host, accessToken.toPreferencesString().toCharArray(), I18n.tr((String)"JOSM/OAuth/{0}/Token", (Object[])new Object[]{URI.create(host).getHost()}));
            this.getProvider().save(prolog + ".parameters." + String.valueOf(oauthType) + "." + host, accessToken.getParameters().toPreferencesString().toCharArray(), I18n.tr((String)"JOSM/OAuth/{0}/Parameters", (Object[])new Object[]{URI.create(host).getHost()}));
        }
    }

    private static String stringNotNull(char[] charData) {
        if (charData == null) {
            return "";
        }
        return String.valueOf(charData);
    }

    public Component getPreferencesDecorationPanel() {
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt;border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        StringBuilder text = new StringBuilder();
        text.append("<html><body><p class=\"warning-body\"><strong>").append(I18n.tr((String)"Native Password Manager Plugin", (Object[])new Object[0])).append("</strong><br>").append(I18n.tr((String)"The username and password is protected by {0}.", (Object[])new Object[]{this.type.getName()}));
        ArrayList<String> sensitive = new ArrayList<String>();
        if (Config.getPref().get("osm-server.username", null) != null) {
            sensitive.add(I18n.tr((String)"username", (Object[])new Object[0]));
        }
        if (Config.getPref().get("osm-server.password", null) != null) {
            sensitive.add(I18n.tr((String)"password", (Object[])new Object[0]));
        }
        if (Config.getPref().get("proxy.user", null) != null) {
            sensitive.add(I18n.tr((String)"proxy username", (Object[])new Object[0]));
        }
        if (Config.getPref().get("proxy.pass", null) != null) {
            sensitive.add(I18n.tr((String)"proxy password", (Object[])new Object[0]));
        }
        if (Config.getPref().get("oauth.access-token.key", null) != null) {
            sensitive.add(I18n.tr((String)"oauth key", (Object[])new Object[0]));
        }
        if (Config.getPref().get("oauth.access-token.secret", null) != null) {
            sensitive.add(I18n.tr((String)"oauth secret", (Object[])new Object[0]));
        }
        List otherKeys = Config.getPref().getSensitive().stream().sorted().collect(Collectors.toList());
        otherKeys.removeAll(Arrays.asList("osm-server.username", "osm-server.password", "proxy.user", "proxy.pass", "oauth.access-token.key", "oauth.access-token.secret"));
        sensitive.addAll(otherKeys);
        if (!sensitive.isEmpty()) {
            text.append(I18n.tr((String)"<br><strong>Warning:</strong> There may be sensitive data left in your preference file. ({0})", (Object[])new Object[]{String.join((CharSequence)", ", sensitive)}));
        }
        pnlMessage.setText(text.toString());
        return pnlMessage;
    }

    public String getSaveUsernameAndPasswordCheckboxText() {
        return I18n.tr((String)"Save user and password ({0})", (Object[])new Object[]{this.type.getName()});
    }
}

