/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.io;

import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.SAXException;

public class ValidatingImageryReader
extends ImageryReader
implements XmlBoundsConstants {
    public ValidatingImageryReader(String source) throws SAXException, IOException {
        this(source, true);
    }

    public ValidatingImageryReader(String source, boolean validateFirst) throws SAXException, IOException {
        super(source);
        if (validateFirst) {
            ValidatingImageryReader.validate(source);
        }
    }

    public static void validate(String source) throws SAXException, IOException {
        try (CachedFile xmlSchema = new CachedFile("resource://data/maps.xsd");){
            XmlUtils.newXmlSchemaFactory().newSchema(new StreamSource(xmlSchema.getInputStream())).newValidator().validate(new StreamSource(source));
        }
    }
}

