/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoH265HrdFlags;
import org.lwjgl.vulkan.video.StdVideoH265SubLayerHrdParameters;

public class StdVideoH265HrdParameters
extends Struct<StdVideoH265HrdParameters>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int TICK_DIVISOR_MINUS2;
    public static final int DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1;
    public static final int DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1;
    public static final int BIT_RATE_SCALE;
    public static final int CPB_SIZE_SCALE;
    public static final int CPB_SIZE_DU_SCALE;
    public static final int INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1;
    public static final int AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1;
    public static final int DPB_OUTPUT_DELAY_LENGTH_MINUS1;
    public static final int CPB_CNT_MINUS1;
    public static final int ELEMENTAL_DURATION_IN_TC_MINUS1;
    public static final int RESERVED;
    public static final int PSUBLAYERHRDPARAMETERSNAL;
    public static final int PSUBLAYERHRDPARAMETERSVCL;

    protected StdVideoH265HrdParameters(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoH265HrdParameters create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH265HrdParameters(address, container);
    }

    public StdVideoH265HrdParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoH265HrdParameters.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoH265HrdFlags flags() {
        return StdVideoH265HrdParameters.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte tick_divisor_minus2() {
        return StdVideoH265HrdParameters.ntick_divisor_minus2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte du_cpb_removal_delay_increment_length_minus1() {
        return StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte dpb_output_delay_du_length_minus1() {
        return StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_rate_scale() {
        return StdVideoH265HrdParameters.nbit_rate_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_size_scale() {
        return StdVideoH265HrdParameters.ncpb_size_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_size_du_scale() {
        return StdVideoH265HrdParameters.ncpb_size_du_scale(this.address());
    }

    @NativeType(value="uint8_t")
    public byte initial_cpb_removal_delay_length_minus1() {
        return StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte au_cpb_removal_delay_length_minus1() {
        return StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte dpb_output_delay_length_minus1() {
        return StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
    public ByteBuffer cpb_cnt_minus1() {
        return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte cpb_cnt_minus1(int index) {
        return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index);
    }

    @NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
    public ShortBuffer elemental_duration_in_tc_minus1() {
        return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address());
    }

    @NativeType(value="uint16_t")
    public short elemental_duration_in_tc_minus1(int index) {
        return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index);
    }

    @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
    public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersNal() {
        return StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address());
    }

    @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
    public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersVcl() {
        return StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address());
    }

    public StdVideoH265HrdParameters flags(StdVideoH265HrdFlags value) {
        StdVideoH265HrdParameters.nflags(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters flags(Consumer<StdVideoH265HrdFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoH265HrdParameters tick_divisor_minus2(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ntick_divisor_minus2(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters du_cpb_removal_delay_increment_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters dpb_output_delay_du_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters bit_rate_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.nbit_rate_scale(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_size_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ncpb_size_scale(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_size_du_scale(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ncpb_size_du_scale(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters initial_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters au_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters dpb_output_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_cnt_minus1(@NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ByteBuffer value) {
        StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters cpb_cnt_minus1(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH265HrdParameters elemental_duration_in_tc_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ShortBuffer value) {
        StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters elemental_duration_in_tc_minus1(int index, @NativeType(value="uint16_t") short value) {
        StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH265HrdParameters pSubLayerHrdParametersNal(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
        StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters pSubLayerHrdParametersVcl(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
        StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address(), value);
        return this;
    }

    public StdVideoH265HrdParameters set(StdVideoH265HrdFlags flags, byte tick_divisor_minus2, byte du_cpb_removal_delay_increment_length_minus1, byte dpb_output_delay_du_length_minus1, byte bit_rate_scale, byte cpb_size_scale, byte cpb_size_du_scale, byte initial_cpb_removal_delay_length_minus1, byte au_cpb_removal_delay_length_minus1, byte dpb_output_delay_length_minus1, ByteBuffer cpb_cnt_minus1, ShortBuffer elemental_duration_in_tc_minus1, StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersNal, StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersVcl) {
        this.flags(flags);
        this.tick_divisor_minus2(tick_divisor_minus2);
        this.du_cpb_removal_delay_increment_length_minus1(du_cpb_removal_delay_increment_length_minus1);
        this.dpb_output_delay_du_length_minus1(dpb_output_delay_du_length_minus1);
        this.bit_rate_scale(bit_rate_scale);
        this.cpb_size_scale(cpb_size_scale);
        this.cpb_size_du_scale(cpb_size_du_scale);
        this.initial_cpb_removal_delay_length_minus1(initial_cpb_removal_delay_length_minus1);
        this.au_cpb_removal_delay_length_minus1(au_cpb_removal_delay_length_minus1);
        this.dpb_output_delay_length_minus1(dpb_output_delay_length_minus1);
        this.cpb_cnt_minus1(cpb_cnt_minus1);
        this.elemental_duration_in_tc_minus1(elemental_duration_in_tc_minus1);
        this.pSubLayerHrdParametersNal(pSubLayerHrdParametersNal);
        this.pSubLayerHrdParametersVcl(pSubLayerHrdParametersVcl);
        return this;
    }

    public StdVideoH265HrdParameters set(StdVideoH265HrdParameters src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoH265HrdParameters malloc() {
        return new StdVideoH265HrdParameters(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoH265HrdParameters calloc() {
        return new StdVideoH265HrdParameters(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoH265HrdParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoH265HrdParameters(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoH265HrdParameters create(long address) {
        return new StdVideoH265HrdParameters(address, null);
    }

    @Nullable
    public static StdVideoH265HrdParameters createSafe(long address) {
        return address == 0L ? null : new StdVideoH265HrdParameters(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoH265HrdParameters.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH265HrdParameters.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH265HrdParameters malloc(MemoryStack stack) {
        return new StdVideoH265HrdParameters(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH265HrdParameters calloc(MemoryStack stack) {
        return new StdVideoH265HrdParameters(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoH265HrdFlags nflags(long struct) {
        return StdVideoH265HrdFlags.create(struct + (long)FLAGS);
    }

    public static byte ntick_divisor_minus2(long struct) {
        return UNSAFE.getByte(null, struct + (long)TICK_DIVISOR_MINUS2);
    }

    public static byte ndu_cpb_removal_delay_increment_length_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1);
    }

    public static byte ndpb_output_delay_du_length_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1);
    }

    public static byte nbit_rate_scale(long struct) {
        return UNSAFE.getByte(null, struct + (long)BIT_RATE_SCALE);
    }

    public static byte ncpb_size_scale(long struct) {
        return UNSAFE.getByte(null, struct + (long)CPB_SIZE_SCALE);
    }

    public static byte ncpb_size_du_scale(long struct) {
        return UNSAFE.getByte(null, struct + (long)CPB_SIZE_DU_SCALE);
    }

    public static byte ninitial_cpb_removal_delay_length_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1);
    }

    public static byte nau_cpb_removal_delay_length_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1);
    }

    public static byte ndpb_output_delay_length_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)DPB_OUTPUT_DELAY_LENGTH_MINUS1);
    }

    public static ByteBuffer ncpb_cnt_minus1(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)CPB_CNT_MINUS1, 7);
    }

    public static byte ncpb_cnt_minus1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CPB_CNT_MINUS1 + Checks.check(index, 7) * 1L);
    }

    public static ShortBuffer nelemental_duration_in_tc_minus1(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1, 7);
    }

    public static short nelemental_duration_in_tc_minus1(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1 + Checks.check(index, 7) * 2L);
    }

    public static ShortBuffer nreserved(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)RESERVED, 3);
    }

    public static short nreserved(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)RESERVED + Checks.check(index, 3) * 2L);
    }

    public static StdVideoH265SubLayerHrdParameters npSubLayerHrdParametersNal(long struct) {
        return StdVideoH265SubLayerHrdParameters.create(MemoryUtil.memGetAddress(struct + (long)PSUBLAYERHRDPARAMETERSNAL));
    }

    public static StdVideoH265SubLayerHrdParameters npSubLayerHrdParametersVcl(long struct) {
        return StdVideoH265SubLayerHrdParameters.create(MemoryUtil.memGetAddress(struct + (long)PSUBLAYERHRDPARAMETERSVCL));
    }

    public static void nflags(long struct, StdVideoH265HrdFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoH265HrdFlags.SIZEOF);
    }

    public static void ntick_divisor_minus2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)TICK_DIVISOR_MINUS2, value);
    }

    public static void ndu_cpb_removal_delay_increment_length_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1, value);
    }

    public static void ndpb_output_delay_du_length_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1, value);
    }

    public static void nbit_rate_scale(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)BIT_RATE_SCALE, value);
    }

    public static void ncpb_size_scale(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CPB_SIZE_SCALE, value);
    }

    public static void ncpb_size_du_scale(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CPB_SIZE_DU_SCALE, value);
    }

    public static void ninitial_cpb_removal_delay_length_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1, value);
    }

    public static void nau_cpb_removal_delay_length_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1, value);
    }

    public static void ndpb_output_delay_length_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DPB_OUTPUT_DELAY_LENGTH_MINUS1, value);
    }

    public static void ncpb_cnt_minus1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)CPB_CNT_MINUS1, value.remaining() * 1);
    }

    public static void ncpb_cnt_minus1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)CPB_CNT_MINUS1 + Checks.check(index, 7) * 1L, value);
    }

    public static void nelemental_duration_in_tc_minus1(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1, value.remaining() * 2);
    }

    public static void nelemental_duration_in_tc_minus1(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)ELEMENTAL_DURATION_IN_TC_MINUS1 + Checks.check(index, 7) * 2L, value);
    }

    public static void nreserved(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 2);
    }

    public static void nreserved(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)RESERVED + Checks.check(index, 3) * 2L, value);
    }

    public static void npSubLayerHrdParametersNal(long struct, StdVideoH265SubLayerHrdParameters value) {
        MemoryUtil.memPutAddress(struct + (long)PSUBLAYERHRDPARAMETERSNAL, value.address());
    }

    public static void npSubLayerHrdParametersVcl(long struct, StdVideoH265SubLayerHrdParameters value) {
        MemoryUtil.memPutAddress(struct + (long)PSUBLAYERHRDPARAMETERSVCL, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSUBLAYERHRDPARAMETERSNAL));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSUBLAYERHRDPARAMETERSVCL));
    }

    static {
        Struct.Layout layout = StdVideoH265HrdParameters.__struct(StdVideoH265HrdParameters.__member(StdVideoH265HrdFlags.SIZEOF, StdVideoH265HrdFlags.ALIGNOF), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__member(1), StdVideoH265HrdParameters.__array(1, 7), StdVideoH265HrdParameters.__array(2, 7), StdVideoH265HrdParameters.__array(2, 3), StdVideoH265HrdParameters.__member(POINTER_SIZE), StdVideoH265HrdParameters.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        TICK_DIVISOR_MINUS2 = layout.offsetof(1);
        DU_CPB_REMOVAL_DELAY_INCREMENT_LENGTH_MINUS1 = layout.offsetof(2);
        DPB_OUTPUT_DELAY_DU_LENGTH_MINUS1 = layout.offsetof(3);
        BIT_RATE_SCALE = layout.offsetof(4);
        CPB_SIZE_SCALE = layout.offsetof(5);
        CPB_SIZE_DU_SCALE = layout.offsetof(6);
        INITIAL_CPB_REMOVAL_DELAY_LENGTH_MINUS1 = layout.offsetof(7);
        AU_CPB_REMOVAL_DELAY_LENGTH_MINUS1 = layout.offsetof(8);
        DPB_OUTPUT_DELAY_LENGTH_MINUS1 = layout.offsetof(9);
        CPB_CNT_MINUS1 = layout.offsetof(10);
        ELEMENTAL_DURATION_IN_TC_MINUS1 = layout.offsetof(11);
        RESERVED = layout.offsetof(12);
        PSUBLAYERHRDPARAMETERSNAL = layout.offsetof(13);
        PSUBLAYERHRDPARAMETERSVCL = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH265HrdParameters, Buffer>
    implements NativeResource {
        private static final StdVideoH265HrdParameters ELEMENT_FACTORY = StdVideoH265HrdParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoH265HrdParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoH265HrdFlags flags() {
            return StdVideoH265HrdParameters.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte tick_divisor_minus2() {
            return StdVideoH265HrdParameters.ntick_divisor_minus2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte du_cpb_removal_delay_increment_length_minus1() {
            return StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte dpb_output_delay_du_length_minus1() {
            return StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_rate_scale() {
            return StdVideoH265HrdParameters.nbit_rate_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_size_scale() {
            return StdVideoH265HrdParameters.ncpb_size_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_size_du_scale() {
            return StdVideoH265HrdParameters.ncpb_size_du_scale(this.address());
        }

        @NativeType(value="uint8_t")
        public byte initial_cpb_removal_delay_length_minus1() {
            return StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte au_cpb_removal_delay_length_minus1() {
            return StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte dpb_output_delay_length_minus1() {
            return StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
        public ByteBuffer cpb_cnt_minus1() {
            return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte cpb_cnt_minus1(int index) {
            return StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index);
        }

        @NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]")
        public ShortBuffer elemental_duration_in_tc_minus1() {
            return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address());
        }

        @NativeType(value="uint16_t")
        public short elemental_duration_in_tc_minus1(int index) {
            return StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index);
        }

        @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
        public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersNal() {
            return StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address());
        }

        @NativeType(value="StdVideoH265SubLayerHrdParameters const *")
        public StdVideoH265SubLayerHrdParameters pSubLayerHrdParametersVcl() {
            return StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address());
        }

        public Buffer flags(StdVideoH265HrdFlags value) {
            StdVideoH265HrdParameters.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoH265HrdFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer tick_divisor_minus2(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ntick_divisor_minus2(this.address(), value);
            return this;
        }

        public Buffer du_cpb_removal_delay_increment_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ndu_cpb_removal_delay_increment_length_minus1(this.address(), value);
            return this;
        }

        public Buffer dpb_output_delay_du_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ndpb_output_delay_du_length_minus1(this.address(), value);
            return this;
        }

        public Buffer bit_rate_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.nbit_rate_scale(this.address(), value);
            return this;
        }

        public Buffer cpb_size_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ncpb_size_scale(this.address(), value);
            return this;
        }

        public Buffer cpb_size_du_scale(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ncpb_size_du_scale(this.address(), value);
            return this;
        }

        public Buffer initial_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ninitial_cpb_removal_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer au_cpb_removal_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.nau_cpb_removal_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer dpb_output_delay_length_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ndpb_output_delay_length_minus1(this.address(), value);
            return this;
        }

        public Buffer cpb_cnt_minus1(@NativeType(value="uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ByteBuffer value) {
            StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), value);
            return this;
        }

        public Buffer cpb_cnt_minus1(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265HrdParameters.ncpb_cnt_minus1(this.address(), index, value);
            return this;
        }

        public Buffer elemental_duration_in_tc_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]") ShortBuffer value) {
            StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), value);
            return this;
        }

        public Buffer elemental_duration_in_tc_minus1(int index, @NativeType(value="uint16_t") short value) {
            StdVideoH265HrdParameters.nelemental_duration_in_tc_minus1(this.address(), index, value);
            return this;
        }

        public Buffer pSubLayerHrdParametersNal(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
            StdVideoH265HrdParameters.npSubLayerHrdParametersNal(this.address(), value);
            return this;
        }

        public Buffer pSubLayerHrdParametersVcl(@NativeType(value="StdVideoH265SubLayerHrdParameters const *") StdVideoH265SubLayerHrdParameters value) {
            StdVideoH265HrdParameters.npSubLayerHrdParametersVcl(this.address(), value);
            return this;
        }
    }
}

