/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoH264ScalingLists;
import org.lwjgl.vulkan.video.StdVideoH264SequenceParameterSetVui;
import org.lwjgl.vulkan.video.StdVideoH264SpsFlags;

public class StdVideoH264SequenceParameterSet
extends Struct<StdVideoH264SequenceParameterSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PROFILE_IDC;
    public static final int LEVEL_IDC;
    public static final int CHROMA_FORMAT_IDC;
    public static final int SEQ_PARAMETER_SET_ID;
    public static final int BIT_DEPTH_LUMA_MINUS8;
    public static final int BIT_DEPTH_CHROMA_MINUS8;
    public static final int LOG2_MAX_FRAME_NUM_MINUS4;
    public static final int PIC_ORDER_CNT_TYPE;
    public static final int OFFSET_FOR_NON_REF_PIC;
    public static final int OFFSET_FOR_TOP_TO_BOTTOM_FIELD;
    public static final int LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4;
    public static final int NUM_REF_FRAMES_IN_PIC_ORDER_CNT_CYCLE;
    public static final int MAX_NUM_REF_FRAMES;
    public static final int RESERVED1;
    public static final int PIC_WIDTH_IN_MBS_MINUS1;
    public static final int PIC_HEIGHT_IN_MAP_UNITS_MINUS1;
    public static final int FRAME_CROP_LEFT_OFFSET;
    public static final int FRAME_CROP_RIGHT_OFFSET;
    public static final int FRAME_CROP_TOP_OFFSET;
    public static final int FRAME_CROP_BOTTOM_OFFSET;
    public static final int RESERVED2;
    public static final int POFFSETFORREFFRAME;
    public static final int PSCALINGLISTS;
    public static final int PSEQUENCEPARAMETERSETVUI;

    protected StdVideoH264SequenceParameterSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoH264SequenceParameterSet create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH264SequenceParameterSet(address, container);
    }

    public StdVideoH264SequenceParameterSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoH264SequenceParameterSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoH264SpsFlags flags() {
        return StdVideoH264SequenceParameterSet.nflags(this.address());
    }

    @NativeType(value="StdVideoH264ProfileIdc")
    public int profile_idc() {
        return StdVideoH264SequenceParameterSet.nprofile_idc(this.address());
    }

    @NativeType(value="StdVideoH264LevelIdc")
    public int level_idc() {
        return StdVideoH264SequenceParameterSet.nlevel_idc(this.address());
    }

    @NativeType(value="StdVideoH264ChromaFormatIdc")
    public int chroma_format_idc() {
        return StdVideoH264SequenceParameterSet.nchroma_format_idc(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_parameter_set_id() {
        return StdVideoH264SequenceParameterSet.nseq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_depth_luma_minus8() {
        return StdVideoH264SequenceParameterSet.nbit_depth_luma_minus8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bit_depth_chroma_minus8() {
        return StdVideoH264SequenceParameterSet.nbit_depth_chroma_minus8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_max_frame_num_minus4() {
        return StdVideoH264SequenceParameterSet.nlog2_max_frame_num_minus4(this.address());
    }

    @NativeType(value="StdVideoH264PocType")
    public int pic_order_cnt_type() {
        return StdVideoH264SequenceParameterSet.npic_order_cnt_type(this.address());
    }

    @NativeType(value="int32_t")
    public int offset_for_non_ref_pic() {
        return StdVideoH264SequenceParameterSet.noffset_for_non_ref_pic(this.address());
    }

    @NativeType(value="int32_t")
    public int offset_for_top_to_bottom_field() {
        return StdVideoH264SequenceParameterSet.noffset_for_top_to_bottom_field(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_max_pic_order_cnt_lsb_minus4() {
        return StdVideoH264SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_frames_in_pic_order_cnt_cycle() {
        return StdVideoH264SequenceParameterSet.nnum_ref_frames_in_pic_order_cnt_cycle(this.address());
    }

    @NativeType(value="uint8_t")
    public byte max_num_ref_frames() {
        return StdVideoH264SequenceParameterSet.nmax_num_ref_frames(this.address());
    }

    @NativeType(value="uint32_t")
    public int pic_width_in_mbs_minus1() {
        return StdVideoH264SequenceParameterSet.npic_width_in_mbs_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int pic_height_in_map_units_minus1() {
        return StdVideoH264SequenceParameterSet.npic_height_in_map_units_minus1(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_crop_left_offset() {
        return StdVideoH264SequenceParameterSet.nframe_crop_left_offset(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_crop_right_offset() {
        return StdVideoH264SequenceParameterSet.nframe_crop_right_offset(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_crop_top_offset() {
        return StdVideoH264SequenceParameterSet.nframe_crop_top_offset(this.address());
    }

    @NativeType(value="uint32_t")
    public int frame_crop_bottom_offset() {
        return StdVideoH264SequenceParameterSet.nframe_crop_bottom_offset(this.address());
    }

    @Nullable
    @NativeType(value="int32_t const *")
    public IntBuffer pOffsetForRefFrame() {
        return StdVideoH264SequenceParameterSet.npOffsetForRefFrame(this.address());
    }

    @NativeType(value="StdVideoH264ScalingLists const *")
    public StdVideoH264ScalingLists pScalingLists() {
        return StdVideoH264SequenceParameterSet.npScalingLists(this.address());
    }

    @NativeType(value="StdVideoH264SequenceParameterSetVui const *")
    public StdVideoH264SequenceParameterSetVui pSequenceParameterSetVui() {
        return StdVideoH264SequenceParameterSet.npSequenceParameterSetVui(this.address());
    }

    public StdVideoH264SequenceParameterSet flags(StdVideoH264SpsFlags value) {
        StdVideoH264SequenceParameterSet.nflags(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet flags(Consumer<StdVideoH264SpsFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoH264SequenceParameterSet profile_idc(@NativeType(value="StdVideoH264ProfileIdc") int value) {
        StdVideoH264SequenceParameterSet.nprofile_idc(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet level_idc(@NativeType(value="StdVideoH264LevelIdc") int value) {
        StdVideoH264SequenceParameterSet.nlevel_idc(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet chroma_format_idc(@NativeType(value="StdVideoH264ChromaFormatIdc") int value) {
        StdVideoH264SequenceParameterSet.nchroma_format_idc(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nseq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet bit_depth_luma_minus8(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nbit_depth_luma_minus8(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet bit_depth_chroma_minus8(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nbit_depth_chroma_minus8(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet log2_max_frame_num_minus4(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nlog2_max_frame_num_minus4(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet pic_order_cnt_type(@NativeType(value="StdVideoH264PocType") int value) {
        StdVideoH264SequenceParameterSet.npic_order_cnt_type(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet offset_for_non_ref_pic(@NativeType(value="int32_t") int value) {
        StdVideoH264SequenceParameterSet.noffset_for_non_ref_pic(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet offset_for_top_to_bottom_field(@NativeType(value="int32_t") int value) {
        StdVideoH264SequenceParameterSet.noffset_for_top_to_bottom_field(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet log2_max_pic_order_cnt_lsb_minus4(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet num_ref_frames_in_pic_order_cnt_cycle(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nnum_ref_frames_in_pic_order_cnt_cycle(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet max_num_ref_frames(@NativeType(value="uint8_t") byte value) {
        StdVideoH264SequenceParameterSet.nmax_num_ref_frames(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet pic_width_in_mbs_minus1(@NativeType(value="uint32_t") int value) {
        StdVideoH264SequenceParameterSet.npic_width_in_mbs_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet pic_height_in_map_units_minus1(@NativeType(value="uint32_t") int value) {
        StdVideoH264SequenceParameterSet.npic_height_in_map_units_minus1(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet frame_crop_left_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH264SequenceParameterSet.nframe_crop_left_offset(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet frame_crop_right_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH264SequenceParameterSet.nframe_crop_right_offset(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet frame_crop_top_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH264SequenceParameterSet.nframe_crop_top_offset(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet frame_crop_bottom_offset(@NativeType(value="uint32_t") int value) {
        StdVideoH264SequenceParameterSet.nframe_crop_bottom_offset(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet pOffsetForRefFrame(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
        StdVideoH264SequenceParameterSet.npOffsetForRefFrame(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet pScalingLists(@NativeType(value="StdVideoH264ScalingLists const *") StdVideoH264ScalingLists value) {
        StdVideoH264SequenceParameterSet.npScalingLists(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet pSequenceParameterSetVui(@NativeType(value="StdVideoH264SequenceParameterSetVui const *") StdVideoH264SequenceParameterSetVui value) {
        StdVideoH264SequenceParameterSet.npSequenceParameterSetVui(this.address(), value);
        return this;
    }

    public StdVideoH264SequenceParameterSet set(StdVideoH264SpsFlags flags, int profile_idc, int level_idc, int chroma_format_idc, byte seq_parameter_set_id, byte bit_depth_luma_minus8, byte bit_depth_chroma_minus8, byte log2_max_frame_num_minus4, int pic_order_cnt_type, int offset_for_non_ref_pic, int offset_for_top_to_bottom_field, byte log2_max_pic_order_cnt_lsb_minus4, byte num_ref_frames_in_pic_order_cnt_cycle, byte max_num_ref_frames, int pic_width_in_mbs_minus1, int pic_height_in_map_units_minus1, int frame_crop_left_offset, int frame_crop_right_offset, int frame_crop_top_offset, int frame_crop_bottom_offset, @Nullable IntBuffer pOffsetForRefFrame, StdVideoH264ScalingLists pScalingLists, StdVideoH264SequenceParameterSetVui pSequenceParameterSetVui) {
        this.flags(flags);
        this.profile_idc(profile_idc);
        this.level_idc(level_idc);
        this.chroma_format_idc(chroma_format_idc);
        this.seq_parameter_set_id(seq_parameter_set_id);
        this.bit_depth_luma_minus8(bit_depth_luma_minus8);
        this.bit_depth_chroma_minus8(bit_depth_chroma_minus8);
        this.log2_max_frame_num_minus4(log2_max_frame_num_minus4);
        this.pic_order_cnt_type(pic_order_cnt_type);
        this.offset_for_non_ref_pic(offset_for_non_ref_pic);
        this.offset_for_top_to_bottom_field(offset_for_top_to_bottom_field);
        this.log2_max_pic_order_cnt_lsb_minus4(log2_max_pic_order_cnt_lsb_minus4);
        this.num_ref_frames_in_pic_order_cnt_cycle(num_ref_frames_in_pic_order_cnt_cycle);
        this.max_num_ref_frames(max_num_ref_frames);
        this.pic_width_in_mbs_minus1(pic_width_in_mbs_minus1);
        this.pic_height_in_map_units_minus1(pic_height_in_map_units_minus1);
        this.frame_crop_left_offset(frame_crop_left_offset);
        this.frame_crop_right_offset(frame_crop_right_offset);
        this.frame_crop_top_offset(frame_crop_top_offset);
        this.frame_crop_bottom_offset(frame_crop_bottom_offset);
        this.pOffsetForRefFrame(pOffsetForRefFrame);
        this.pScalingLists(pScalingLists);
        this.pSequenceParameterSetVui(pSequenceParameterSetVui);
        return this;
    }

    public StdVideoH264SequenceParameterSet set(StdVideoH264SequenceParameterSet src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoH264SequenceParameterSet malloc() {
        return new StdVideoH264SequenceParameterSet(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoH264SequenceParameterSet calloc() {
        return new StdVideoH264SequenceParameterSet(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoH264SequenceParameterSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoH264SequenceParameterSet(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoH264SequenceParameterSet create(long address) {
        return new StdVideoH264SequenceParameterSet(address, null);
    }

    @Nullable
    public static StdVideoH264SequenceParameterSet createSafe(long address) {
        return address == 0L ? null : new StdVideoH264SequenceParameterSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoH264SequenceParameterSet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH264SequenceParameterSet.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH264SequenceParameterSet malloc(MemoryStack stack) {
        return new StdVideoH264SequenceParameterSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH264SequenceParameterSet calloc(MemoryStack stack) {
        return new StdVideoH264SequenceParameterSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoH264SpsFlags nflags(long struct) {
        return StdVideoH264SpsFlags.create(struct + (long)FLAGS);
    }

    public static int nprofile_idc(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROFILE_IDC);
    }

    public static int nlevel_idc(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVEL_IDC);
    }

    public static int nchroma_format_idc(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHROMA_FORMAT_IDC);
    }

    public static byte nseq_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SEQ_PARAMETER_SET_ID);
    }

    public static byte nbit_depth_luma_minus8(long struct) {
        return UNSAFE.getByte(null, struct + (long)BIT_DEPTH_LUMA_MINUS8);
    }

    public static byte nbit_depth_chroma_minus8(long struct) {
        return UNSAFE.getByte(null, struct + (long)BIT_DEPTH_CHROMA_MINUS8);
    }

    public static byte nlog2_max_frame_num_minus4(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOG2_MAX_FRAME_NUM_MINUS4);
    }

    public static int npic_order_cnt_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIC_ORDER_CNT_TYPE);
    }

    public static int noffset_for_non_ref_pic(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET_FOR_NON_REF_PIC);
    }

    public static int noffset_for_top_to_bottom_field(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET_FOR_TOP_TO_BOTTOM_FIELD);
    }

    public static byte nlog2_max_pic_order_cnt_lsb_minus4(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4);
    }

    public static byte nnum_ref_frames_in_pic_order_cnt_cycle(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_FRAMES_IN_PIC_ORDER_CNT_CYCLE);
    }

    public static byte nmax_num_ref_frames(long struct) {
        return UNSAFE.getByte(null, struct + (long)MAX_NUM_REF_FRAMES);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static int npic_width_in_mbs_minus1(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIC_WIDTH_IN_MBS_MINUS1);
    }

    public static int npic_height_in_map_units_minus1(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIC_HEIGHT_IN_MAP_UNITS_MINUS1);
    }

    public static int nframe_crop_left_offset(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_CROP_LEFT_OFFSET);
    }

    public static int nframe_crop_right_offset(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_CROP_RIGHT_OFFSET);
    }

    public static int nframe_crop_top_offset(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_CROP_TOP_OFFSET);
    }

    public static int nframe_crop_bottom_offset(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_CROP_BOTTOM_OFFSET);
    }

    public static int nreserved2(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESERVED2);
    }

    @Nullable
    public static IntBuffer npOffsetForRefFrame(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)POFFSETFORREFFRAME), Byte.toUnsignedInt(StdVideoH264SequenceParameterSet.nnum_ref_frames_in_pic_order_cnt_cycle(struct)));
    }

    public static StdVideoH264ScalingLists npScalingLists(long struct) {
        return StdVideoH264ScalingLists.create(MemoryUtil.memGetAddress(struct + (long)PSCALINGLISTS));
    }

    public static StdVideoH264SequenceParameterSetVui npSequenceParameterSetVui(long struct) {
        return StdVideoH264SequenceParameterSetVui.create(MemoryUtil.memGetAddress(struct + (long)PSEQUENCEPARAMETERSETVUI));
    }

    public static void nflags(long struct, StdVideoH264SpsFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoH264SpsFlags.SIZEOF);
    }

    public static void nprofile_idc(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROFILE_IDC, value);
    }

    public static void nlevel_idc(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVEL_IDC, value);
    }

    public static void nchroma_format_idc(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHROMA_FORMAT_IDC, value);
    }

    public static void nseq_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SEQ_PARAMETER_SET_ID, value);
    }

    public static void nbit_depth_luma_minus8(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)BIT_DEPTH_LUMA_MINUS8, value);
    }

    public static void nbit_depth_chroma_minus8(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)BIT_DEPTH_CHROMA_MINUS8, value);
    }

    public static void nlog2_max_frame_num_minus4(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LOG2_MAX_FRAME_NUM_MINUS4, value);
    }

    public static void npic_order_cnt_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIC_ORDER_CNT_TYPE, value);
    }

    public static void noffset_for_non_ref_pic(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET_FOR_NON_REF_PIC, value);
    }

    public static void noffset_for_top_to_bottom_field(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET_FOR_TOP_TO_BOTTOM_FIELD, value);
    }

    public static void nlog2_max_pic_order_cnt_lsb_minus4(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4, value);
    }

    public static void nnum_ref_frames_in_pic_order_cnt_cycle(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_FRAMES_IN_PIC_ORDER_CNT_CYCLE, value);
    }

    public static void nmax_num_ref_frames(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MAX_NUM_REF_FRAMES, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void npic_width_in_mbs_minus1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIC_WIDTH_IN_MBS_MINUS1, value);
    }

    public static void npic_height_in_map_units_minus1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIC_HEIGHT_IN_MAP_UNITS_MINUS1, value);
    }

    public static void nframe_crop_left_offset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_CROP_LEFT_OFFSET, value);
    }

    public static void nframe_crop_right_offset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_CROP_RIGHT_OFFSET, value);
    }

    public static void nframe_crop_top_offset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_CROP_TOP_OFFSET, value);
    }

    public static void nframe_crop_bottom_offset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_CROP_BOTTOM_OFFSET, value);
    }

    public static void nreserved2(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED2, value);
    }

    public static void npOffsetForRefFrame(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)POFFSETFORREFFRAME, MemoryUtil.memAddressSafe(value));
        StdVideoH264SequenceParameterSet.nnum_ref_frames_in_pic_order_cnt_cycle(struct, value == null ? (byte)0 : (byte)value.remaining());
    }

    public static void npScalingLists(long struct, StdVideoH264ScalingLists value) {
        MemoryUtil.memPutAddress(struct + (long)PSCALINGLISTS, value.address());
    }

    public static void npSequenceParameterSetVui(long struct, StdVideoH264SequenceParameterSetVui value) {
        MemoryUtil.memPutAddress(struct + (long)PSEQUENCEPARAMETERSETVUI, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSCALINGLISTS));
        long pSequenceParameterSetVui = MemoryUtil.memGetAddress(struct + (long)PSEQUENCEPARAMETERSETVUI);
        Checks.check(pSequenceParameterSetVui);
        StdVideoH264SequenceParameterSetVui.validate(pSequenceParameterSetVui);
    }

    static {
        Struct.Layout layout = StdVideoH264SequenceParameterSet.__struct(StdVideoH264SequenceParameterSet.__member(StdVideoH264SpsFlags.SIZEOF, StdVideoH264SpsFlags.ALIGNOF), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(1), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(4), StdVideoH264SequenceParameterSet.__member(POINTER_SIZE), StdVideoH264SequenceParameterSet.__member(POINTER_SIZE), StdVideoH264SequenceParameterSet.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PROFILE_IDC = layout.offsetof(1);
        LEVEL_IDC = layout.offsetof(2);
        CHROMA_FORMAT_IDC = layout.offsetof(3);
        SEQ_PARAMETER_SET_ID = layout.offsetof(4);
        BIT_DEPTH_LUMA_MINUS8 = layout.offsetof(5);
        BIT_DEPTH_CHROMA_MINUS8 = layout.offsetof(6);
        LOG2_MAX_FRAME_NUM_MINUS4 = layout.offsetof(7);
        PIC_ORDER_CNT_TYPE = layout.offsetof(8);
        OFFSET_FOR_NON_REF_PIC = layout.offsetof(9);
        OFFSET_FOR_TOP_TO_BOTTOM_FIELD = layout.offsetof(10);
        LOG2_MAX_PIC_ORDER_CNT_LSB_MINUS4 = layout.offsetof(11);
        NUM_REF_FRAMES_IN_PIC_ORDER_CNT_CYCLE = layout.offsetof(12);
        MAX_NUM_REF_FRAMES = layout.offsetof(13);
        RESERVED1 = layout.offsetof(14);
        PIC_WIDTH_IN_MBS_MINUS1 = layout.offsetof(15);
        PIC_HEIGHT_IN_MAP_UNITS_MINUS1 = layout.offsetof(16);
        FRAME_CROP_LEFT_OFFSET = layout.offsetof(17);
        FRAME_CROP_RIGHT_OFFSET = layout.offsetof(18);
        FRAME_CROP_TOP_OFFSET = layout.offsetof(19);
        FRAME_CROP_BOTTOM_OFFSET = layout.offsetof(20);
        RESERVED2 = layout.offsetof(21);
        POFFSETFORREFFRAME = layout.offsetof(22);
        PSCALINGLISTS = layout.offsetof(23);
        PSEQUENCEPARAMETERSETVUI = layout.offsetof(24);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH264SequenceParameterSet, Buffer>
    implements NativeResource {
        private static final StdVideoH264SequenceParameterSet ELEMENT_FACTORY = StdVideoH264SequenceParameterSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoH264SequenceParameterSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoH264SpsFlags flags() {
            return StdVideoH264SequenceParameterSet.nflags(this.address());
        }

        @NativeType(value="StdVideoH264ProfileIdc")
        public int profile_idc() {
            return StdVideoH264SequenceParameterSet.nprofile_idc(this.address());
        }

        @NativeType(value="StdVideoH264LevelIdc")
        public int level_idc() {
            return StdVideoH264SequenceParameterSet.nlevel_idc(this.address());
        }

        @NativeType(value="StdVideoH264ChromaFormatIdc")
        public int chroma_format_idc() {
            return StdVideoH264SequenceParameterSet.nchroma_format_idc(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_parameter_set_id() {
            return StdVideoH264SequenceParameterSet.nseq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_depth_luma_minus8() {
            return StdVideoH264SequenceParameterSet.nbit_depth_luma_minus8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bit_depth_chroma_minus8() {
            return StdVideoH264SequenceParameterSet.nbit_depth_chroma_minus8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_max_frame_num_minus4() {
            return StdVideoH264SequenceParameterSet.nlog2_max_frame_num_minus4(this.address());
        }

        @NativeType(value="StdVideoH264PocType")
        public int pic_order_cnt_type() {
            return StdVideoH264SequenceParameterSet.npic_order_cnt_type(this.address());
        }

        @NativeType(value="int32_t")
        public int offset_for_non_ref_pic() {
            return StdVideoH264SequenceParameterSet.noffset_for_non_ref_pic(this.address());
        }

        @NativeType(value="int32_t")
        public int offset_for_top_to_bottom_field() {
            return StdVideoH264SequenceParameterSet.noffset_for_top_to_bottom_field(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_max_pic_order_cnt_lsb_minus4() {
            return StdVideoH264SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_frames_in_pic_order_cnt_cycle() {
            return StdVideoH264SequenceParameterSet.nnum_ref_frames_in_pic_order_cnt_cycle(this.address());
        }

        @NativeType(value="uint8_t")
        public byte max_num_ref_frames() {
            return StdVideoH264SequenceParameterSet.nmax_num_ref_frames(this.address());
        }

        @NativeType(value="uint32_t")
        public int pic_width_in_mbs_minus1() {
            return StdVideoH264SequenceParameterSet.npic_width_in_mbs_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int pic_height_in_map_units_minus1() {
            return StdVideoH264SequenceParameterSet.npic_height_in_map_units_minus1(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_crop_left_offset() {
            return StdVideoH264SequenceParameterSet.nframe_crop_left_offset(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_crop_right_offset() {
            return StdVideoH264SequenceParameterSet.nframe_crop_right_offset(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_crop_top_offset() {
            return StdVideoH264SequenceParameterSet.nframe_crop_top_offset(this.address());
        }

        @NativeType(value="uint32_t")
        public int frame_crop_bottom_offset() {
            return StdVideoH264SequenceParameterSet.nframe_crop_bottom_offset(this.address());
        }

        @Nullable
        @NativeType(value="int32_t const *")
        public IntBuffer pOffsetForRefFrame() {
            return StdVideoH264SequenceParameterSet.npOffsetForRefFrame(this.address());
        }

        @NativeType(value="StdVideoH264ScalingLists const *")
        public StdVideoH264ScalingLists pScalingLists() {
            return StdVideoH264SequenceParameterSet.npScalingLists(this.address());
        }

        @NativeType(value="StdVideoH264SequenceParameterSetVui const *")
        public StdVideoH264SequenceParameterSetVui pSequenceParameterSetVui() {
            return StdVideoH264SequenceParameterSet.npSequenceParameterSetVui(this.address());
        }

        public Buffer flags(StdVideoH264SpsFlags value) {
            StdVideoH264SequenceParameterSet.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoH264SpsFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer profile_idc(@NativeType(value="StdVideoH264ProfileIdc") int value) {
            StdVideoH264SequenceParameterSet.nprofile_idc(this.address(), value);
            return this;
        }

        public Buffer level_idc(@NativeType(value="StdVideoH264LevelIdc") int value) {
            StdVideoH264SequenceParameterSet.nlevel_idc(this.address(), value);
            return this;
        }

        public Buffer chroma_format_idc(@NativeType(value="StdVideoH264ChromaFormatIdc") int value) {
            StdVideoH264SequenceParameterSet.nchroma_format_idc(this.address(), value);
            return this;
        }

        public Buffer seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nseq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer bit_depth_luma_minus8(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nbit_depth_luma_minus8(this.address(), value);
            return this;
        }

        public Buffer bit_depth_chroma_minus8(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nbit_depth_chroma_minus8(this.address(), value);
            return this;
        }

        public Buffer log2_max_frame_num_minus4(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nlog2_max_frame_num_minus4(this.address(), value);
            return this;
        }

        public Buffer pic_order_cnt_type(@NativeType(value="StdVideoH264PocType") int value) {
            StdVideoH264SequenceParameterSet.npic_order_cnt_type(this.address(), value);
            return this;
        }

        public Buffer offset_for_non_ref_pic(@NativeType(value="int32_t") int value) {
            StdVideoH264SequenceParameterSet.noffset_for_non_ref_pic(this.address(), value);
            return this;
        }

        public Buffer offset_for_top_to_bottom_field(@NativeType(value="int32_t") int value) {
            StdVideoH264SequenceParameterSet.noffset_for_top_to_bottom_field(this.address(), value);
            return this;
        }

        public Buffer log2_max_pic_order_cnt_lsb_minus4(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nlog2_max_pic_order_cnt_lsb_minus4(this.address(), value);
            return this;
        }

        public Buffer num_ref_frames_in_pic_order_cnt_cycle(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nnum_ref_frames_in_pic_order_cnt_cycle(this.address(), value);
            return this;
        }

        public Buffer max_num_ref_frames(@NativeType(value="uint8_t") byte value) {
            StdVideoH264SequenceParameterSet.nmax_num_ref_frames(this.address(), value);
            return this;
        }

        public Buffer pic_width_in_mbs_minus1(@NativeType(value="uint32_t") int value) {
            StdVideoH264SequenceParameterSet.npic_width_in_mbs_minus1(this.address(), value);
            return this;
        }

        public Buffer pic_height_in_map_units_minus1(@NativeType(value="uint32_t") int value) {
            StdVideoH264SequenceParameterSet.npic_height_in_map_units_minus1(this.address(), value);
            return this;
        }

        public Buffer frame_crop_left_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH264SequenceParameterSet.nframe_crop_left_offset(this.address(), value);
            return this;
        }

        public Buffer frame_crop_right_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH264SequenceParameterSet.nframe_crop_right_offset(this.address(), value);
            return this;
        }

        public Buffer frame_crop_top_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH264SequenceParameterSet.nframe_crop_top_offset(this.address(), value);
            return this;
        }

        public Buffer frame_crop_bottom_offset(@NativeType(value="uint32_t") int value) {
            StdVideoH264SequenceParameterSet.nframe_crop_bottom_offset(this.address(), value);
            return this;
        }

        public Buffer pOffsetForRefFrame(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
            StdVideoH264SequenceParameterSet.npOffsetForRefFrame(this.address(), value);
            return this;
        }

        public Buffer pScalingLists(@NativeType(value="StdVideoH264ScalingLists const *") StdVideoH264ScalingLists value) {
            StdVideoH264SequenceParameterSet.npScalingLists(this.address(), value);
            return this;
        }

        public Buffer pSequenceParameterSetVui(@NativeType(value="StdVideoH264SequenceParameterSetVui const *") StdVideoH264SequenceParameterSetVui value) {
            StdVideoH264SequenceParameterSet.npSequenceParameterSetVui(this.address(), value);
            return this;
        }
    }
}

