/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoAV1LoopRestoration
extends Struct<StdVideoAV1LoopRestoration>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMERESTORATIONTYPE;
    public static final int LOOPRESTORATIONSIZE;

    protected StdVideoAV1LoopRestoration(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoAV1LoopRestoration create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1LoopRestoration(address, container);
    }

    public StdVideoAV1LoopRestoration(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoAV1LoopRestoration.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="StdVideoAV1FrameRestorationType[STD_VIDEO_AV1_MAX_NUM_PLANES]")
    public IntBuffer FrameRestorationType() {
        return StdVideoAV1LoopRestoration.nFrameRestorationType(this.address());
    }

    @NativeType(value="StdVideoAV1FrameRestorationType")
    public int FrameRestorationType(int index) {
        return StdVideoAV1LoopRestoration.nFrameRestorationType(this.address(), index);
    }

    @NativeType(value="uint16_t[STD_VIDEO_AV1_MAX_NUM_PLANES]")
    public ShortBuffer LoopRestorationSize() {
        return StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address());
    }

    @NativeType(value="uint16_t")
    public short LoopRestorationSize(int index) {
        return StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address(), index);
    }

    public StdVideoAV1LoopRestoration FrameRestorationType(@NativeType(value="StdVideoAV1FrameRestorationType[STD_VIDEO_AV1_MAX_NUM_PLANES]") IntBuffer value) {
        StdVideoAV1LoopRestoration.nFrameRestorationType(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopRestoration FrameRestorationType(int index, @NativeType(value="StdVideoAV1FrameRestorationType") int value) {
        StdVideoAV1LoopRestoration.nFrameRestorationType(this.address(), index, value);
        return this;
    }

    public StdVideoAV1LoopRestoration LoopRestorationSize(@NativeType(value="uint16_t[STD_VIDEO_AV1_MAX_NUM_PLANES]") ShortBuffer value) {
        StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopRestoration LoopRestorationSize(int index, @NativeType(value="uint16_t") short value) {
        StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address(), index, value);
        return this;
    }

    public StdVideoAV1LoopRestoration set(IntBuffer FrameRestorationType, ShortBuffer LoopRestorationSize) {
        this.FrameRestorationType(FrameRestorationType);
        this.LoopRestorationSize(LoopRestorationSize);
        return this;
    }

    public StdVideoAV1LoopRestoration set(StdVideoAV1LoopRestoration src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoAV1LoopRestoration malloc() {
        return new StdVideoAV1LoopRestoration(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoAV1LoopRestoration calloc() {
        return new StdVideoAV1LoopRestoration(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoAV1LoopRestoration create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoAV1LoopRestoration(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoAV1LoopRestoration create(long address) {
        return new StdVideoAV1LoopRestoration(address, null);
    }

    @Nullable
    public static StdVideoAV1LoopRestoration createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1LoopRestoration(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoAV1LoopRestoration.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1LoopRestoration.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1LoopRestoration malloc(MemoryStack stack) {
        return new StdVideoAV1LoopRestoration(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1LoopRestoration calloc(MemoryStack stack) {
        return new StdVideoAV1LoopRestoration(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static IntBuffer nFrameRestorationType(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)FRAMERESTORATIONTYPE, 3);
    }

    public static int nFrameRestorationType(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)FRAMERESTORATIONTYPE + Checks.check(index, 3) * 4L);
    }

    public static ShortBuffer nLoopRestorationSize(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)LOOPRESTORATIONSIZE, 3);
    }

    public static short nLoopRestorationSize(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)LOOPRESTORATIONSIZE + Checks.check(index, 3) * 2L);
    }

    public static void nFrameRestorationType(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)FRAMERESTORATIONTYPE, value.remaining() * 4);
    }

    public static void nFrameRestorationType(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMERESTORATIONTYPE + Checks.check(index, 3) * 4L, value);
    }

    public static void nLoopRestorationSize(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)LOOPRESTORATIONSIZE, value.remaining() * 2);
    }

    public static void nLoopRestorationSize(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)LOOPRESTORATIONSIZE + Checks.check(index, 3) * 2L, value);
    }

    static {
        Struct.Layout layout = StdVideoAV1LoopRestoration.__struct(StdVideoAV1LoopRestoration.__array(4, 3), StdVideoAV1LoopRestoration.__array(2, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMERESTORATIONTYPE = layout.offsetof(0);
        LOOPRESTORATIONSIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1LoopRestoration, Buffer>
    implements NativeResource {
        private static final StdVideoAV1LoopRestoration ELEMENT_FACTORY = StdVideoAV1LoopRestoration.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoAV1LoopRestoration getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="StdVideoAV1FrameRestorationType[STD_VIDEO_AV1_MAX_NUM_PLANES]")
        public IntBuffer FrameRestorationType() {
            return StdVideoAV1LoopRestoration.nFrameRestorationType(this.address());
        }

        @NativeType(value="StdVideoAV1FrameRestorationType")
        public int FrameRestorationType(int index) {
            return StdVideoAV1LoopRestoration.nFrameRestorationType(this.address(), index);
        }

        @NativeType(value="uint16_t[STD_VIDEO_AV1_MAX_NUM_PLANES]")
        public ShortBuffer LoopRestorationSize() {
            return StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address());
        }

        @NativeType(value="uint16_t")
        public short LoopRestorationSize(int index) {
            return StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address(), index);
        }

        public Buffer FrameRestorationType(@NativeType(value="StdVideoAV1FrameRestorationType[STD_VIDEO_AV1_MAX_NUM_PLANES]") IntBuffer value) {
            StdVideoAV1LoopRestoration.nFrameRestorationType(this.address(), value);
            return this;
        }

        public Buffer FrameRestorationType(int index, @NativeType(value="StdVideoAV1FrameRestorationType") int value) {
            StdVideoAV1LoopRestoration.nFrameRestorationType(this.address(), index, value);
            return this;
        }

        public Buffer LoopRestorationSize(@NativeType(value="uint16_t[STD_VIDEO_AV1_MAX_NUM_PLANES]") ShortBuffer value) {
            StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address(), value);
            return this;
        }

        public Buffer LoopRestorationSize(int index, @NativeType(value="uint16_t") short value) {
            StdVideoAV1LoopRestoration.nLoopRestorationSize(this.address(), index, value);
            return this;
        }
    }
}

