/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1ColorConfigFlags;

public class StdVideoAV1ColorConfig
extends Struct<StdVideoAV1ColorConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int BITDEPTH;
    public static final int SUBSAMPLING_X;
    public static final int SUBSAMPLING_Y;
    public static final int RESERVED1;
    public static final int COLOR_PRIMARIES;
    public static final int TRANSFER_CHARACTERISTICS;
    public static final int MATRIX_COEFFICIENTS;
    public static final int CHROMA_SAMPLE_POSITION;

    protected StdVideoAV1ColorConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoAV1ColorConfig create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1ColorConfig(address, container);
    }

    public StdVideoAV1ColorConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoAV1ColorConfig.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoAV1ColorConfigFlags flags() {
        return StdVideoAV1ColorConfig.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte BitDepth() {
        return StdVideoAV1ColorConfig.nBitDepth(this.address());
    }

    @NativeType(value="uint8_t")
    public byte subsampling_x() {
        return StdVideoAV1ColorConfig.nsubsampling_x(this.address());
    }

    @NativeType(value="uint8_t")
    public byte subsampling_y() {
        return StdVideoAV1ColorConfig.nsubsampling_y(this.address());
    }

    @NativeType(value="StdVideoAV1ColorPrimaries")
    public int color_primaries() {
        return StdVideoAV1ColorConfig.ncolor_primaries(this.address());
    }

    @NativeType(value="StdVideoAV1TransferCharacteristics")
    public int transfer_characteristics() {
        return StdVideoAV1ColorConfig.ntransfer_characteristics(this.address());
    }

    @NativeType(value="StdVideoAV1MatrixCoefficients")
    public int matrix_coefficients() {
        return StdVideoAV1ColorConfig.nmatrix_coefficients(this.address());
    }

    @NativeType(value="StdVideoAV1ChromaSamplePosition")
    public int chroma_sample_position() {
        return StdVideoAV1ColorConfig.nchroma_sample_position(this.address());
    }

    public StdVideoAV1ColorConfig flags(StdVideoAV1ColorConfigFlags value) {
        StdVideoAV1ColorConfig.nflags(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig flags(Consumer<StdVideoAV1ColorConfigFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoAV1ColorConfig BitDepth(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1ColorConfig.nBitDepth(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig subsampling_x(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1ColorConfig.nsubsampling_x(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig subsampling_y(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1ColorConfig.nsubsampling_y(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig color_primaries(@NativeType(value="StdVideoAV1ColorPrimaries") int value) {
        StdVideoAV1ColorConfig.ncolor_primaries(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig transfer_characteristics(@NativeType(value="StdVideoAV1TransferCharacteristics") int value) {
        StdVideoAV1ColorConfig.ntransfer_characteristics(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig matrix_coefficients(@NativeType(value="StdVideoAV1MatrixCoefficients") int value) {
        StdVideoAV1ColorConfig.nmatrix_coefficients(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig chroma_sample_position(@NativeType(value="StdVideoAV1ChromaSamplePosition") int value) {
        StdVideoAV1ColorConfig.nchroma_sample_position(this.address(), value);
        return this;
    }

    public StdVideoAV1ColorConfig set(StdVideoAV1ColorConfigFlags flags, byte BitDepth, byte subsampling_x, byte subsampling_y, int color_primaries, int transfer_characteristics, int matrix_coefficients, int chroma_sample_position) {
        this.flags(flags);
        this.BitDepth(BitDepth);
        this.subsampling_x(subsampling_x);
        this.subsampling_y(subsampling_y);
        this.color_primaries(color_primaries);
        this.transfer_characteristics(transfer_characteristics);
        this.matrix_coefficients(matrix_coefficients);
        this.chroma_sample_position(chroma_sample_position);
        return this;
    }

    public StdVideoAV1ColorConfig set(StdVideoAV1ColorConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoAV1ColorConfig malloc() {
        return new StdVideoAV1ColorConfig(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoAV1ColorConfig calloc() {
        return new StdVideoAV1ColorConfig(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoAV1ColorConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoAV1ColorConfig(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoAV1ColorConfig create(long address) {
        return new StdVideoAV1ColorConfig(address, null);
    }

    @Nullable
    public static StdVideoAV1ColorConfig createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1ColorConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoAV1ColorConfig.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1ColorConfig.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1ColorConfig malloc(MemoryStack stack) {
        return new StdVideoAV1ColorConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1ColorConfig calloc(MemoryStack stack) {
        return new StdVideoAV1ColorConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoAV1ColorConfigFlags nflags(long struct) {
        return StdVideoAV1ColorConfigFlags.create(struct + (long)FLAGS);
    }

    public static byte nBitDepth(long struct) {
        return UNSAFE.getByte(null, struct + (long)BITDEPTH);
    }

    public static byte nsubsampling_x(long struct) {
        return UNSAFE.getByte(null, struct + (long)SUBSAMPLING_X);
    }

    public static byte nsubsampling_y(long struct) {
        return UNSAFE.getByte(null, struct + (long)SUBSAMPLING_Y);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static int ncolor_primaries(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLOR_PRIMARIES);
    }

    public static int ntransfer_characteristics(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSFER_CHARACTERISTICS);
    }

    public static int nmatrix_coefficients(long struct) {
        return UNSAFE.getInt(null, struct + (long)MATRIX_COEFFICIENTS);
    }

    public static int nchroma_sample_position(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHROMA_SAMPLE_POSITION);
    }

    public static void nflags(long struct, StdVideoAV1ColorConfigFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoAV1ColorConfigFlags.SIZEOF);
    }

    public static void nBitDepth(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)BITDEPTH, value);
    }

    public static void nsubsampling_x(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SUBSAMPLING_X, value);
    }

    public static void nsubsampling_y(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SUBSAMPLING_Y, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void ncolor_primaries(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLOR_PRIMARIES, value);
    }

    public static void ntransfer_characteristics(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSFER_CHARACTERISTICS, value);
    }

    public static void nmatrix_coefficients(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MATRIX_COEFFICIENTS, value);
    }

    public static void nchroma_sample_position(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHROMA_SAMPLE_POSITION, value);
    }

    static {
        Struct.Layout layout = StdVideoAV1ColorConfig.__struct(StdVideoAV1ColorConfig.__member(StdVideoAV1ColorConfigFlags.SIZEOF, StdVideoAV1ColorConfigFlags.ALIGNOF), StdVideoAV1ColorConfig.__member(1), StdVideoAV1ColorConfig.__member(1), StdVideoAV1ColorConfig.__member(1), StdVideoAV1ColorConfig.__member(1), StdVideoAV1ColorConfig.__member(4), StdVideoAV1ColorConfig.__member(4), StdVideoAV1ColorConfig.__member(4), StdVideoAV1ColorConfig.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        BITDEPTH = layout.offsetof(1);
        SUBSAMPLING_X = layout.offsetof(2);
        SUBSAMPLING_Y = layout.offsetof(3);
        RESERVED1 = layout.offsetof(4);
        COLOR_PRIMARIES = layout.offsetof(5);
        TRANSFER_CHARACTERISTICS = layout.offsetof(6);
        MATRIX_COEFFICIENTS = layout.offsetof(7);
        CHROMA_SAMPLE_POSITION = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1ColorConfig, Buffer>
    implements NativeResource {
        private static final StdVideoAV1ColorConfig ELEMENT_FACTORY = StdVideoAV1ColorConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoAV1ColorConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoAV1ColorConfigFlags flags() {
            return StdVideoAV1ColorConfig.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte BitDepth() {
            return StdVideoAV1ColorConfig.nBitDepth(this.address());
        }

        @NativeType(value="uint8_t")
        public byte subsampling_x() {
            return StdVideoAV1ColorConfig.nsubsampling_x(this.address());
        }

        @NativeType(value="uint8_t")
        public byte subsampling_y() {
            return StdVideoAV1ColorConfig.nsubsampling_y(this.address());
        }

        @NativeType(value="StdVideoAV1ColorPrimaries")
        public int color_primaries() {
            return StdVideoAV1ColorConfig.ncolor_primaries(this.address());
        }

        @NativeType(value="StdVideoAV1TransferCharacteristics")
        public int transfer_characteristics() {
            return StdVideoAV1ColorConfig.ntransfer_characteristics(this.address());
        }

        @NativeType(value="StdVideoAV1MatrixCoefficients")
        public int matrix_coefficients() {
            return StdVideoAV1ColorConfig.nmatrix_coefficients(this.address());
        }

        @NativeType(value="StdVideoAV1ChromaSamplePosition")
        public int chroma_sample_position() {
            return StdVideoAV1ColorConfig.nchroma_sample_position(this.address());
        }

        public Buffer flags(StdVideoAV1ColorConfigFlags value) {
            StdVideoAV1ColorConfig.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoAV1ColorConfigFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer BitDepth(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1ColorConfig.nBitDepth(this.address(), value);
            return this;
        }

        public Buffer subsampling_x(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1ColorConfig.nsubsampling_x(this.address(), value);
            return this;
        }

        public Buffer subsampling_y(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1ColorConfig.nsubsampling_y(this.address(), value);
            return this;
        }

        public Buffer color_primaries(@NativeType(value="StdVideoAV1ColorPrimaries") int value) {
            StdVideoAV1ColorConfig.ncolor_primaries(this.address(), value);
            return this;
        }

        public Buffer transfer_characteristics(@NativeType(value="StdVideoAV1TransferCharacteristics") int value) {
            StdVideoAV1ColorConfig.ntransfer_characteristics(this.address(), value);
            return this;
        }

        public Buffer matrix_coefficients(@NativeType(value="StdVideoAV1MatrixCoefficients") int value) {
            StdVideoAV1ColorConfig.nmatrix_coefficients(this.address(), value);
            return this;
        }

        public Buffer chroma_sample_position(@NativeType(value="StdVideoAV1ChromaSamplePosition") int value) {
            StdVideoAV1ColorConfig.nchroma_sample_position(this.address(), value);
            return this;
        }
    }
}

