/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewport
extends Struct<VkViewport>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MINDEPTH;
    public static final int MAXDEPTH;

    protected VkViewport(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkViewport create(long address, @Nullable ByteBuffer container) {
        return new VkViewport(address, container);
    }

    public VkViewport(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkViewport.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkViewport.nx(this.address());
    }

    public float y() {
        return VkViewport.ny(this.address());
    }

    public float width() {
        return VkViewport.nwidth(this.address());
    }

    public float height() {
        return VkViewport.nheight(this.address());
    }

    public float minDepth() {
        return VkViewport.nminDepth(this.address());
    }

    public float maxDepth() {
        return VkViewport.nmaxDepth(this.address());
    }

    public VkViewport x(float value) {
        VkViewport.nx(this.address(), value);
        return this;
    }

    public VkViewport y(float value) {
        VkViewport.ny(this.address(), value);
        return this;
    }

    public VkViewport width(float value) {
        VkViewport.nwidth(this.address(), value);
        return this;
    }

    public VkViewport height(float value) {
        VkViewport.nheight(this.address(), value);
        return this;
    }

    public VkViewport minDepth(float value) {
        VkViewport.nminDepth(this.address(), value);
        return this;
    }

    public VkViewport maxDepth(float value) {
        VkViewport.nmaxDepth(this.address(), value);
        return this;
    }

    public VkViewport set(float x, float y, float width, float height, float minDepth, float maxDepth) {
        this.x(x);
        this.y(y);
        this.width(width);
        this.height(height);
        this.minDepth(minDepth);
        this.maxDepth(maxDepth);
        return this;
    }

    public VkViewport set(VkViewport src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkViewport malloc() {
        return new VkViewport(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkViewport calloc() {
        return new VkViewport(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkViewport create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkViewport(MemoryUtil.memAddress(container), container);
    }

    public static VkViewport create(long address) {
        return new VkViewport(address, null);
    }

    @Nullable
    public static VkViewport createSafe(long address) {
        return address == 0L ? null : new VkViewport(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkViewport.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkViewport.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkViewport mallocStack() {
        return VkViewport.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewport callocStack() {
        return VkViewport.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewport mallocStack(MemoryStack stack) {
        return VkViewport.malloc(stack);
    }

    @Deprecated
    public static VkViewport callocStack(MemoryStack stack) {
        return VkViewport.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkViewport.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkViewport.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewport.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewport.calloc(capacity, stack);
    }

    public static VkViewport malloc(MemoryStack stack) {
        return new VkViewport(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkViewport calloc(MemoryStack stack) {
        return new VkViewport(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float nminDepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINDEPTH);
    }

    public static float nmaxDepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXDEPTH);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void nminDepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINDEPTH, value);
    }

    public static void nmaxDepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXDEPTH, value);
    }

    static {
        Struct.Layout layout = VkViewport.__struct(VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        MINDEPTH = layout.offsetof(4);
        MAXDEPTH = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkViewport, Buffer>
    implements NativeResource {
        private static final VkViewport ELEMENT_FACTORY = VkViewport.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkViewport getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return VkViewport.nx(this.address());
        }

        public float y() {
            return VkViewport.ny(this.address());
        }

        public float width() {
            return VkViewport.nwidth(this.address());
        }

        public float height() {
            return VkViewport.nheight(this.address());
        }

        public float minDepth() {
            return VkViewport.nminDepth(this.address());
        }

        public float maxDepth() {
            return VkViewport.nmaxDepth(this.address());
        }

        public Buffer x(float value) {
            VkViewport.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkViewport.ny(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            VkViewport.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            VkViewport.nheight(this.address(), value);
            return this;
        }

        public Buffer minDepth(float value) {
            VkViewport.nminDepth(this.address(), value);
            return this;
        }

        public Buffer maxDepth(float value) {
            VkViewport.nmaxDepth(this.address(), value);
            return this;
        }
    }
}

