/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCompressionPropertiesEXT;
import org.lwjgl.vulkan.VkSurfaceFormatKHR;

public class VkSurfaceFormat2KHR
extends Struct<VkSurfaceFormat2KHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SURFACEFORMAT;

    protected VkSurfaceFormat2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSurfaceFormat2KHR create(long address, @Nullable ByteBuffer container) {
        return new VkSurfaceFormat2KHR(address, container);
    }

    public VkSurfaceFormat2KHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSurfaceFormat2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSurfaceFormat2KHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkSurfaceFormat2KHR.npNext(this.address());
    }

    public VkSurfaceFormatKHR surfaceFormat() {
        return VkSurfaceFormat2KHR.nsurfaceFormat(this.address());
    }

    public VkSurfaceFormat2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkSurfaceFormat2KHR.nsType(this.address(), value);
        return this;
    }

    public VkSurfaceFormat2KHR sType$Default() {
        return this.sType(1000119002);
    }

    public VkSurfaceFormat2KHR pNext(@NativeType(value="void *") long value) {
        VkSurfaceFormat2KHR.npNext(this.address(), value);
        return this;
    }

    public VkSurfaceFormat2KHR pNext(VkImageCompressionPropertiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSurfaceFormat2KHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSurfaceFormat2KHR set(VkSurfaceFormat2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSurfaceFormat2KHR malloc() {
        return new VkSurfaceFormat2KHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSurfaceFormat2KHR calloc() {
        return new VkSurfaceFormat2KHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSurfaceFormat2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSurfaceFormat2KHR(MemoryUtil.memAddress(container), container);
    }

    public static VkSurfaceFormat2KHR create(long address) {
        return new VkSurfaceFormat2KHR(address, null);
    }

    @Nullable
    public static VkSurfaceFormat2KHR createSafe(long address) {
        return address == 0L ? null : new VkSurfaceFormat2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSurfaceFormat2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSurfaceFormat2KHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSurfaceFormat2KHR mallocStack() {
        return VkSurfaceFormat2KHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceFormat2KHR callocStack() {
        return VkSurfaceFormat2KHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceFormat2KHR mallocStack(MemoryStack stack) {
        return VkSurfaceFormat2KHR.malloc(stack);
    }

    @Deprecated
    public static VkSurfaceFormat2KHR callocStack(MemoryStack stack) {
        return VkSurfaceFormat2KHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSurfaceFormat2KHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSurfaceFormat2KHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormat2KHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormat2KHR.calloc(capacity, stack);
    }

    public static VkSurfaceFormat2KHR malloc(MemoryStack stack) {
        return new VkSurfaceFormat2KHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSurfaceFormat2KHR calloc(MemoryStack stack) {
        return new VkSurfaceFormat2KHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkSurfaceFormatKHR nsurfaceFormat(long struct) {
        return VkSurfaceFormatKHR.create(struct + (long)SURFACEFORMAT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkSurfaceFormat2KHR.__struct(VkSurfaceFormat2KHR.__member(4), VkSurfaceFormat2KHR.__member(POINTER_SIZE), VkSurfaceFormat2KHR.__member(VkSurfaceFormatKHR.SIZEOF, VkSurfaceFormatKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SURFACEFORMAT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceFormat2KHR, Buffer>
    implements NativeResource {
        private static final VkSurfaceFormat2KHR ELEMENT_FACTORY = VkSurfaceFormat2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSurfaceFormat2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSurfaceFormat2KHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkSurfaceFormat2KHR.npNext(this.address());
        }

        public VkSurfaceFormatKHR surfaceFormat() {
            return VkSurfaceFormat2KHR.nsurfaceFormat(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSurfaceFormat2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000119002);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSurfaceFormat2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkImageCompressionPropertiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

