/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkSubpassBeginInfo;

public class VkSubpassBeginInfoKHR
extends VkSubpassBeginInfo {
    protected VkSubpassBeginInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubpassBeginInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkSubpassBeginInfoKHR(address, container);
    }

    public VkSubpassBeginInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkSubpassBeginInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassBeginInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassBeginInfoKHR sType$Default() {
        return this.sType(1000109005);
    }

    @Override
    public VkSubpassBeginInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassBeginInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassBeginInfoKHR contents(@NativeType(value="VkSubpassContents") int value) {
        VkSubpassBeginInfoKHR.ncontents(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassBeginInfoKHR set(int sType, long pNext, int contents) {
        this.sType(sType);
        this.pNext(pNext);
        this.contents(contents);
        return this;
    }

    public VkSubpassBeginInfoKHR set(VkSubpassBeginInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassBeginInfoKHR malloc() {
        return new VkSubpassBeginInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubpassBeginInfoKHR calloc() {
        return new VkSubpassBeginInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubpassBeginInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubpassBeginInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkSubpassBeginInfoKHR create(long address) {
        return new VkSubpassBeginInfoKHR(address, null);
    }

    @Nullable
    public static VkSubpassBeginInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkSubpassBeginInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubpassBeginInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassBeginInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSubpassBeginInfoKHR mallocStack() {
        return VkSubpassBeginInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassBeginInfoKHR callocStack() {
        return VkSubpassBeginInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassBeginInfoKHR mallocStack(MemoryStack stack) {
        return VkSubpassBeginInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkSubpassBeginInfoKHR callocStack(MemoryStack stack) {
        return VkSubpassBeginInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubpassBeginInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubpassBeginInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassBeginInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassBeginInfoKHR.calloc(capacity, stack);
    }

    public static VkSubpassBeginInfoKHR malloc(MemoryStack stack) {
        return new VkSubpassBeginInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubpassBeginInfoKHR calloc(MemoryStack stack) {
        return new VkSubpassBeginInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkSubpassBeginInfo.Buffer {
        private static final VkSubpassBeginInfoKHR ELEMENT_FACTORY = VkSubpassBeginInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubpassBeginInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassBeginInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000109005);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassBeginInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer contents(@NativeType(value="VkSubpassContents") int value) {
            VkSubpassBeginInfoKHR.ncontents(this.address(), value);
            return this;
        }
    }
}

