/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderingAreaInfoKHR
extends Struct<VkRenderingAreaInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWMASK;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTFORMATS;
    public static final int DEPTHATTACHMENTFORMAT;
    public static final int STENCILATTACHMENTFORMAT;

    protected VkRenderingAreaInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderingAreaInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkRenderingAreaInfoKHR(address, container);
    }

    public VkRenderingAreaInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderingAreaInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderingAreaInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderingAreaInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkRenderingAreaInfoKHR.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkRenderingAreaInfoKHR.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFormat const *")
    public IntBuffer pColorAttachmentFormats() {
        return VkRenderingAreaInfoKHR.npColorAttachmentFormats(this.address());
    }

    @NativeType(value="VkFormat")
    public int depthAttachmentFormat() {
        return VkRenderingAreaInfoKHR.ndepthAttachmentFormat(this.address());
    }

    @NativeType(value="VkFormat")
    public int stencilAttachmentFormat() {
        return VkRenderingAreaInfoKHR.nstencilAttachmentFormat(this.address());
    }

    public VkRenderingAreaInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingAreaInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR sType$Default() {
        return this.sType(1000470003);
    }

    public VkRenderingAreaInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderingAreaInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR viewMask(@NativeType(value="uint32_t") int value) {
        VkRenderingAreaInfoKHR.nviewMask(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkRenderingAreaInfoKHR.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkRenderingAreaInfoKHR.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkRenderingAreaInfoKHR.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkRenderingAreaInfoKHR.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfoKHR set(int sType, long pNext, int viewMask, int colorAttachmentCount, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkRenderingAreaInfoKHR set(VkRenderingAreaInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderingAreaInfoKHR malloc() {
        return new VkRenderingAreaInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderingAreaInfoKHR calloc() {
        return new VkRenderingAreaInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderingAreaInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderingAreaInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderingAreaInfoKHR create(long address) {
        return new VkRenderingAreaInfoKHR(address, null);
    }

    @Nullable
    public static VkRenderingAreaInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkRenderingAreaInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderingAreaInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingAreaInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderingAreaInfoKHR malloc(MemoryStack stack) {
        return new VkRenderingAreaInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderingAreaInfoKHR calloc(MemoryStack stack) {
        return new VkRenderingAreaInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nviewMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWMASK);
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npColorAttachmentFormats(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTFORMATS), VkRenderingAreaInfoKHR.ncolorAttachmentCount(struct));
    }

    public static int ndepthAttachmentFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHATTACHMENTFORMAT);
    }

    public static int nstencilAttachmentFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)STENCILATTACHMENTFORMAT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nviewMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWMASK, value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachmentFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTFORMATS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkRenderingAreaInfoKHR.ncolorAttachmentCount(struct, value.remaining());
        }
    }

    public static void ndepthAttachmentFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHATTACHMENTFORMAT, value);
    }

    public static void nstencilAttachmentFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STENCILATTACHMENTFORMAT, value);
    }

    static {
        Struct.Layout layout = VkRenderingAreaInfoKHR.__struct(VkRenderingAreaInfoKHR.__member(4), VkRenderingAreaInfoKHR.__member(POINTER_SIZE), VkRenderingAreaInfoKHR.__member(4), VkRenderingAreaInfoKHR.__member(4), VkRenderingAreaInfoKHR.__member(POINTER_SIZE), VkRenderingAreaInfoKHR.__member(4), VkRenderingAreaInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWMASK = layout.offsetof(2);
        COLORATTACHMENTCOUNT = layout.offsetof(3);
        PCOLORATTACHMENTFORMATS = layout.offsetof(4);
        DEPTHATTACHMENTFORMAT = layout.offsetof(5);
        STENCILATTACHMENTFORMAT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkRenderingAreaInfoKHR, Buffer>
    implements NativeResource {
        private static final VkRenderingAreaInfoKHR ELEMENT_FACTORY = VkRenderingAreaInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderingAreaInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderingAreaInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderingAreaInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkRenderingAreaInfoKHR.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkRenderingAreaInfoKHR.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFormat const *")
        public IntBuffer pColorAttachmentFormats() {
            return VkRenderingAreaInfoKHR.npColorAttachmentFormats(this.address());
        }

        @NativeType(value="VkFormat")
        public int depthAttachmentFormat() {
            return VkRenderingAreaInfoKHR.ndepthAttachmentFormat(this.address());
        }

        @NativeType(value="VkFormat")
        public int stencilAttachmentFormat() {
            return VkRenderingAreaInfoKHR.nstencilAttachmentFormat(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingAreaInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000470003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingAreaInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkRenderingAreaInfoKHR.nviewMask(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkRenderingAreaInfoKHR.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkRenderingAreaInfoKHR.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkRenderingAreaInfoKHR.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkRenderingAreaInfoKHR.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

