/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRenderPassStripeInfoARM;

public class VkRenderPassStripeBeginInfoARM
extends Struct<VkRenderPassStripeBeginInfoARM>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STRIPEINFOCOUNT;
    public static final int PSTRIPEINFOS;

    protected VkRenderPassStripeBeginInfoARM(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderPassStripeBeginInfoARM create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassStripeBeginInfoARM(address, container);
    }

    public VkRenderPassStripeBeginInfoARM(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderPassStripeBeginInfoARM.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassStripeBeginInfoARM.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassStripeBeginInfoARM.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int stripeInfoCount() {
        return VkRenderPassStripeBeginInfoARM.nstripeInfoCount(this.address());
    }

    @NativeType(value="VkRenderPassStripeInfoARM const *")
    public VkRenderPassStripeInfoARM.Buffer pStripeInfos() {
        return VkRenderPassStripeBeginInfoARM.npStripeInfos(this.address());
    }

    public VkRenderPassStripeBeginInfoARM sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassStripeBeginInfoARM.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassStripeBeginInfoARM sType$Default() {
        return this.sType(1000424002);
    }

    public VkRenderPassStripeBeginInfoARM pNext(@NativeType(value="void const *") long value) {
        VkRenderPassStripeBeginInfoARM.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassStripeBeginInfoARM pStripeInfos(@NativeType(value="VkRenderPassStripeInfoARM const *") VkRenderPassStripeInfoARM.Buffer value) {
        VkRenderPassStripeBeginInfoARM.npStripeInfos(this.address(), value);
        return this;
    }

    public VkRenderPassStripeBeginInfoARM set(int sType, long pNext, VkRenderPassStripeInfoARM.Buffer pStripeInfos) {
        this.sType(sType);
        this.pNext(pNext);
        this.pStripeInfos(pStripeInfos);
        return this;
    }

    public VkRenderPassStripeBeginInfoARM set(VkRenderPassStripeBeginInfoARM src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassStripeBeginInfoARM malloc() {
        return new VkRenderPassStripeBeginInfoARM(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderPassStripeBeginInfoARM calloc() {
        return new VkRenderPassStripeBeginInfoARM(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderPassStripeBeginInfoARM create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderPassStripeBeginInfoARM(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderPassStripeBeginInfoARM create(long address) {
        return new VkRenderPassStripeBeginInfoARM(address, null);
    }

    @Nullable
    public static VkRenderPassStripeBeginInfoARM createSafe(long address) {
        return address == 0L ? null : new VkRenderPassStripeBeginInfoARM(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderPassStripeBeginInfoARM.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassStripeBeginInfoARM.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderPassStripeBeginInfoARM malloc(MemoryStack stack) {
        return new VkRenderPassStripeBeginInfoARM(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassStripeBeginInfoARM calloc(MemoryStack stack) {
        return new VkRenderPassStripeBeginInfoARM(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstripeInfoCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRIPEINFOCOUNT);
    }

    public static VkRenderPassStripeInfoARM.Buffer npStripeInfos(long struct) {
        return VkRenderPassStripeInfoARM.create(MemoryUtil.memGetAddress(struct + (long)PSTRIPEINFOS), VkRenderPassStripeBeginInfoARM.nstripeInfoCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstripeInfoCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRIPEINFOCOUNT, value);
    }

    public static void npStripeInfos(long struct, VkRenderPassStripeInfoARM.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTRIPEINFOS, value.address());
        VkRenderPassStripeBeginInfoARM.nstripeInfoCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSTRIPEINFOS));
    }

    static {
        Struct.Layout layout = VkRenderPassStripeBeginInfoARM.__struct(VkRenderPassStripeBeginInfoARM.__member(4), VkRenderPassStripeBeginInfoARM.__member(POINTER_SIZE), VkRenderPassStripeBeginInfoARM.__member(4), VkRenderPassStripeBeginInfoARM.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STRIPEINFOCOUNT = layout.offsetof(2);
        PSTRIPEINFOS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassStripeBeginInfoARM, Buffer>
    implements NativeResource {
        private static final VkRenderPassStripeBeginInfoARM ELEMENT_FACTORY = VkRenderPassStripeBeginInfoARM.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderPassStripeBeginInfoARM getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassStripeBeginInfoARM.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassStripeBeginInfoARM.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int stripeInfoCount() {
            return VkRenderPassStripeBeginInfoARM.nstripeInfoCount(this.address());
        }

        @NativeType(value="VkRenderPassStripeInfoARM const *")
        public VkRenderPassStripeInfoARM.Buffer pStripeInfos() {
            return VkRenderPassStripeBeginInfoARM.npStripeInfos(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassStripeBeginInfoARM.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000424002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassStripeBeginInfoARM.npNext(this.address(), value);
            return this;
        }

        public Buffer pStripeInfos(@NativeType(value="VkRenderPassStripeInfoARM const *") VkRenderPassStripeInfoARM.Buffer value) {
            VkRenderPassStripeBeginInfoARM.npStripeInfos(this.address(), value);
            return this;
        }
    }
}

