/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPushConstantRange;

public class VkPipelineLayoutCreateInfo
extends Struct<VkPipelineLayoutCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SETLAYOUTCOUNT;
    public static final int PSETLAYOUTS;
    public static final int PUSHCONSTANTRANGECOUNT;
    public static final int PPUSHCONSTANTRANGES;

    protected VkPipelineLayoutCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineLayoutCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineLayoutCreateInfo(address, container);
    }

    public VkPipelineLayoutCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineLayoutCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineLayoutCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineLayoutCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineLayoutCreateFlags")
    public int flags() {
        return VkPipelineLayoutCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int setLayoutCount() {
        return VkPipelineLayoutCreateInfo.nsetLayoutCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorSetLayout const *")
    public LongBuffer pSetLayouts() {
        return VkPipelineLayoutCreateInfo.npSetLayouts(this.address());
    }

    @NativeType(value="uint32_t")
    public int pushConstantRangeCount() {
        return VkPipelineLayoutCreateInfo.npushConstantRangeCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPushConstantRange const *")
    public VkPushConstantRange.Buffer pPushConstantRanges() {
        return VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address());
    }

    public VkPipelineLayoutCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineLayoutCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo sType$Default() {
        return this.sType(30);
    }

    public VkPipelineLayoutCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineLayoutCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo flags(@NativeType(value="VkPipelineLayoutCreateFlags") int value) {
        VkPipelineLayoutCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo setLayoutCount(@NativeType(value="uint32_t") int value) {
        VkPipelineLayoutCreateInfo.nsetLayoutCount(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo pSetLayouts(@Nullable @NativeType(value="VkDescriptorSetLayout const *") LongBuffer value) {
        VkPipelineLayoutCreateInfo.npSetLayouts(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo pPushConstantRanges(@Nullable @NativeType(value="VkPushConstantRange const *") VkPushConstantRange.Buffer value) {
        VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address(), value);
        return this;
    }

    public VkPipelineLayoutCreateInfo set(int sType, long pNext, int flags, int setLayoutCount, @Nullable LongBuffer pSetLayouts, @Nullable VkPushConstantRange.Buffer pPushConstantRanges) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.setLayoutCount(setLayoutCount);
        this.pSetLayouts(pSetLayouts);
        this.pPushConstantRanges(pPushConstantRanges);
        return this;
    }

    public VkPipelineLayoutCreateInfo set(VkPipelineLayoutCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineLayoutCreateInfo malloc() {
        return new VkPipelineLayoutCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineLayoutCreateInfo calloc() {
        return new VkPipelineLayoutCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineLayoutCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineLayoutCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineLayoutCreateInfo create(long address) {
        return new VkPipelineLayoutCreateInfo(address, null);
    }

    @Nullable
    public static VkPipelineLayoutCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineLayoutCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineLayoutCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineLayoutCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineLayoutCreateInfo mallocStack() {
        return VkPipelineLayoutCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineLayoutCreateInfo callocStack() {
        return VkPipelineLayoutCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineLayoutCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineLayoutCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineLayoutCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineLayoutCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineLayoutCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineLayoutCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineLayoutCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineLayoutCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineLayoutCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nsetLayoutCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SETLAYOUTCOUNT);
    }

    @Nullable
    public static LongBuffer npSetLayouts(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS), VkPipelineLayoutCreateInfo.nsetLayoutCount(struct));
    }

    public static int npushConstantRangeCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PUSHCONSTANTRANGECOUNT);
    }

    @Nullable
    public static VkPushConstantRange.Buffer npPushConstantRanges(long struct) {
        return VkPushConstantRange.createSafe(MemoryUtil.memGetAddress(struct + (long)PPUSHCONSTANTRANGES), VkPipelineLayoutCreateInfo.npushConstantRangeCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsetLayoutCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SETLAYOUTCOUNT, value);
    }

    public static void npSetLayouts(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSETLAYOUTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPipelineLayoutCreateInfo.nsetLayoutCount(struct, value.remaining());
        }
    }

    public static void npushConstantRangeCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PUSHCONSTANTRANGECOUNT, value);
    }

    public static void npPushConstantRanges(long struct, @Nullable VkPushConstantRange.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPUSHCONSTANTRANGES, MemoryUtil.memAddressSafe(value));
        VkPipelineLayoutCreateInfo.npushConstantRangeCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineLayoutCreateInfo.npushConstantRangeCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPUSHCONSTANTRANGES));
        }
    }

    static {
        Struct.Layout layout = VkPipelineLayoutCreateInfo.__struct(VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(POINTER_SIZE), VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(POINTER_SIZE), VkPipelineLayoutCreateInfo.__member(4), VkPipelineLayoutCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SETLAYOUTCOUNT = layout.offsetof(3);
        PSETLAYOUTS = layout.offsetof(4);
        PUSHCONSTANTRANGECOUNT = layout.offsetof(5);
        PPUSHCONSTANTRANGES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineLayoutCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineLayoutCreateInfo ELEMENT_FACTORY = VkPipelineLayoutCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineLayoutCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineLayoutCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineLayoutCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineLayoutCreateFlags")
        public int flags() {
            return VkPipelineLayoutCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int setLayoutCount() {
            return VkPipelineLayoutCreateInfo.nsetLayoutCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorSetLayout const *")
        public LongBuffer pSetLayouts() {
            return VkPipelineLayoutCreateInfo.npSetLayouts(this.address());
        }

        @NativeType(value="uint32_t")
        public int pushConstantRangeCount() {
            return VkPipelineLayoutCreateInfo.npushConstantRangeCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPushConstantRange const *")
        public VkPushConstantRange.Buffer pPushConstantRanges() {
            return VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineLayoutCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(30);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineLayoutCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineLayoutCreateFlags") int value) {
            VkPipelineLayoutCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer setLayoutCount(@NativeType(value="uint32_t") int value) {
            VkPipelineLayoutCreateInfo.nsetLayoutCount(this.address(), value);
            return this;
        }

        public Buffer pSetLayouts(@Nullable @NativeType(value="VkDescriptorSetLayout const *") LongBuffer value) {
            VkPipelineLayoutCreateInfo.npSetLayouts(this.address(), value);
            return this;
        }

        public Buffer pPushConstantRanges(@Nullable @NativeType(value="VkPushConstantRange const *") VkPushConstantRange.Buffer value) {
            VkPipelineLayoutCreateInfo.npPushConstantRanges(this.address(), value);
            return this;
        }
    }
}

