/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineColorWriteCreateInfoEXT
extends Struct<VkPipelineColorWriteCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENTCOUNT;
    public static final int PCOLORWRITEENABLES;

    protected VkPipelineColorWriteCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineColorWriteCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineColorWriteCreateInfoEXT(address, container);
    }

    public VkPipelineColorWriteCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineColorWriteCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineColorWriteCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineColorWriteCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkPipelineColorWriteCreateInfoEXT.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkBool32 const *")
    public IntBuffer pColorWriteEnables() {
        return VkPipelineColorWriteCreateInfoEXT.npColorWriteEnables(this.address());
    }

    public VkPipelineColorWriteCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineColorWriteCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkPipelineColorWriteCreateInfoEXT sType$Default() {
        return this.sType(1000381001);
    }

    public VkPipelineColorWriteCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkPipelineColorWriteCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkPipelineColorWriteCreateInfoEXT pColorWriteEnables(@Nullable @NativeType(value="VkBool32 const *") IntBuffer value) {
        VkPipelineColorWriteCreateInfoEXT.npColorWriteEnables(this.address(), value);
        return this;
    }

    public VkPipelineColorWriteCreateInfoEXT set(int sType, long pNext, @Nullable IntBuffer pColorWriteEnables) {
        this.sType(sType);
        this.pNext(pNext);
        this.pColorWriteEnables(pColorWriteEnables);
        return this;
    }

    public VkPipelineColorWriteCreateInfoEXT set(VkPipelineColorWriteCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineColorWriteCreateInfoEXT malloc() {
        return new VkPipelineColorWriteCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineColorWriteCreateInfoEXT calloc() {
        return new VkPipelineColorWriteCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineColorWriteCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineColorWriteCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineColorWriteCreateInfoEXT create(long address) {
        return new VkPipelineColorWriteCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkPipelineColorWriteCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkPipelineColorWriteCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineColorWriteCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineColorWriteCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineColorWriteCreateInfoEXT malloc(MemoryStack stack) {
        return new VkPipelineColorWriteCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineColorWriteCreateInfoEXT calloc(MemoryStack stack) {
        return new VkPipelineColorWriteCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npColorWriteEnables(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORWRITEENABLES), VkPipelineColorWriteCreateInfoEXT.nattachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npColorWriteEnables(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORWRITEENABLES, MemoryUtil.memAddressSafe(value));
        VkPipelineColorWriteCreateInfoEXT.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineColorWriteCreateInfoEXT.nattachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORWRITEENABLES));
        }
    }

    static {
        Struct.Layout layout = VkPipelineColorWriteCreateInfoEXT.__struct(VkPipelineColorWriteCreateInfoEXT.__member(4), VkPipelineColorWriteCreateInfoEXT.__member(POINTER_SIZE), VkPipelineColorWriteCreateInfoEXT.__member(4), VkPipelineColorWriteCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENTCOUNT = layout.offsetof(2);
        PCOLORWRITEENABLES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineColorWriteCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkPipelineColorWriteCreateInfoEXT ELEMENT_FACTORY = VkPipelineColorWriteCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineColorWriteCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineColorWriteCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineColorWriteCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkPipelineColorWriteCreateInfoEXT.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkBool32 const *")
        public IntBuffer pColorWriteEnables() {
            return VkPipelineColorWriteCreateInfoEXT.npColorWriteEnables(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineColorWriteCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000381001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineColorWriteCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pColorWriteEnables(@Nullable @NativeType(value="VkBool32 const *") IntBuffer value) {
            VkPipelineColorWriteCreateInfoEXT.npColorWriteEnables(this.address(), value);
            return this;
        }
    }
}

