/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPerformanceValueDataINTEL
extends Struct<VkPerformanceValueDataINTEL>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE32;
    public static final int VALUE64;
    public static final int VALUEFLOAT;
    public static final int VALUEBOOL;
    public static final int VALUESTRING;

    protected VkPerformanceValueDataINTEL(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPerformanceValueDataINTEL create(long address, @Nullable ByteBuffer container) {
        return new VkPerformanceValueDataINTEL(address, container);
    }

    public VkPerformanceValueDataINTEL(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPerformanceValueDataINTEL.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int value32() {
        return VkPerformanceValueDataINTEL.nvalue32(this.address());
    }

    @NativeType(value="uint64_t")
    public long value64() {
        return VkPerformanceValueDataINTEL.nvalue64(this.address());
    }

    public float valueFloat() {
        return VkPerformanceValueDataINTEL.nvalueFloat(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean valueBool() {
        return VkPerformanceValueDataINTEL.nvalueBool(this.address()) != 0;
    }

    @NativeType(value="char const *")
    public ByteBuffer valueString() {
        return VkPerformanceValueDataINTEL.nvalueString(this.address());
    }

    @NativeType(value="char const *")
    public String valueStringString() {
        return VkPerformanceValueDataINTEL.nvalueStringString(this.address());
    }

    public VkPerformanceValueDataINTEL value32(@NativeType(value="uint32_t") int value) {
        VkPerformanceValueDataINTEL.nvalue32(this.address(), value);
        return this;
    }

    public VkPerformanceValueDataINTEL value64(@NativeType(value="uint64_t") long value) {
        VkPerformanceValueDataINTEL.nvalue64(this.address(), value);
        return this;
    }

    public VkPerformanceValueDataINTEL valueFloat(float value) {
        VkPerformanceValueDataINTEL.nvalueFloat(this.address(), value);
        return this;
    }

    public VkPerformanceValueDataINTEL valueBool(@NativeType(value="VkBool32") boolean value) {
        VkPerformanceValueDataINTEL.nvalueBool(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPerformanceValueDataINTEL valueString(@NativeType(value="char const *") ByteBuffer value) {
        VkPerformanceValueDataINTEL.nvalueString(this.address(), value);
        return this;
    }

    public VkPerformanceValueDataINTEL set(VkPerformanceValueDataINTEL src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPerformanceValueDataINTEL malloc() {
        return new VkPerformanceValueDataINTEL(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPerformanceValueDataINTEL calloc() {
        return new VkPerformanceValueDataINTEL(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPerformanceValueDataINTEL create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPerformanceValueDataINTEL(MemoryUtil.memAddress(container), container);
    }

    public static VkPerformanceValueDataINTEL create(long address) {
        return new VkPerformanceValueDataINTEL(address, null);
    }

    @Nullable
    public static VkPerformanceValueDataINTEL createSafe(long address) {
        return address == 0L ? null : new VkPerformanceValueDataINTEL(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPerformanceValueDataINTEL.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPerformanceValueDataINTEL.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPerformanceValueDataINTEL mallocStack() {
        return VkPerformanceValueDataINTEL.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPerformanceValueDataINTEL callocStack() {
        return VkPerformanceValueDataINTEL.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPerformanceValueDataINTEL mallocStack(MemoryStack stack) {
        return VkPerformanceValueDataINTEL.malloc(stack);
    }

    @Deprecated
    public static VkPerformanceValueDataINTEL callocStack(MemoryStack stack) {
        return VkPerformanceValueDataINTEL.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPerformanceValueDataINTEL.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPerformanceValueDataINTEL.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPerformanceValueDataINTEL.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPerformanceValueDataINTEL.calloc(capacity, stack);
    }

    public static VkPerformanceValueDataINTEL malloc(MemoryStack stack) {
        return new VkPerformanceValueDataINTEL(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPerformanceValueDataINTEL calloc(MemoryStack stack) {
        return new VkPerformanceValueDataINTEL(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvalue32(long struct) {
        return UNSAFE.getInt(null, struct + (long)VALUE32);
    }

    public static long nvalue64(long struct) {
        return UNSAFE.getLong(null, struct + (long)VALUE64);
    }

    public static float nvalueFloat(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VALUEFLOAT);
    }

    public static int nvalueBool(long struct) {
        return UNSAFE.getInt(null, struct + (long)VALUEBOOL);
    }

    public static ByteBuffer nvalueString(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)VALUESTRING));
    }

    public static String nvalueStringString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)VALUESTRING));
    }

    public static void nvalue32(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VALUE32, value);
    }

    public static void nvalue64(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VALUE64, value);
    }

    public static void nvalueFloat(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VALUEFLOAT, value);
    }

    public static void nvalueBool(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VALUEBOOL, value);
    }

    public static void nvalueString(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)VALUESTRING, MemoryUtil.memAddress(value));
    }

    static {
        Struct.Layout layout = VkPerformanceValueDataINTEL.__union(VkPerformanceValueDataINTEL.__member(4), VkPerformanceValueDataINTEL.__member(8), VkPerformanceValueDataINTEL.__member(4), VkPerformanceValueDataINTEL.__member(4), VkPerformanceValueDataINTEL.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE32 = layout.offsetof(0);
        VALUE64 = layout.offsetof(1);
        VALUEFLOAT = layout.offsetof(2);
        VALUEBOOL = layout.offsetof(3);
        VALUESTRING = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPerformanceValueDataINTEL, Buffer>
    implements NativeResource {
        private static final VkPerformanceValueDataINTEL ELEMENT_FACTORY = VkPerformanceValueDataINTEL.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPerformanceValueDataINTEL getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int value32() {
            return VkPerformanceValueDataINTEL.nvalue32(this.address());
        }

        @NativeType(value="uint64_t")
        public long value64() {
            return VkPerformanceValueDataINTEL.nvalue64(this.address());
        }

        public float valueFloat() {
            return VkPerformanceValueDataINTEL.nvalueFloat(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean valueBool() {
            return VkPerformanceValueDataINTEL.nvalueBool(this.address()) != 0;
        }

        @NativeType(value="char const *")
        public ByteBuffer valueString() {
            return VkPerformanceValueDataINTEL.nvalueString(this.address());
        }

        @NativeType(value="char const *")
        public String valueStringString() {
            return VkPerformanceValueDataINTEL.nvalueStringString(this.address());
        }

        public Buffer value32(@NativeType(value="uint32_t") int value) {
            VkPerformanceValueDataINTEL.nvalue32(this.address(), value);
            return this;
        }

        public Buffer value64(@NativeType(value="uint64_t") long value) {
            VkPerformanceValueDataINTEL.nvalue64(this.address(), value);
            return this;
        }

        public Buffer valueFloat(float value) {
            VkPerformanceValueDataINTEL.nvalueFloat(this.address(), value);
            return this;
        }

        public Buffer valueBool(@NativeType(value="VkBool32") boolean value) {
            VkPerformanceValueDataINTEL.nvalueBool(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer valueString(@NativeType(value="char const *") ByteBuffer value) {
            VkPerformanceValueDataINTEL.nvalueString(this.address(), value);
            return this;
        }
    }
}

