/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMicromapVersionInfoEXT
extends Struct<VkMicromapVersionInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PVERSIONDATA;

    protected VkMicromapVersionInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMicromapVersionInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMicromapVersionInfoEXT(address, container);
    }

    public VkMicromapVersionInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMicromapVersionInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMicromapVersionInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMicromapVersionInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer pVersionData(int capacity) {
        return VkMicromapVersionInfoEXT.npVersionData(this.address(), capacity);
    }

    public VkMicromapVersionInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMicromapVersionInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMicromapVersionInfoEXT sType$Default() {
        return this.sType(1000396001);
    }

    public VkMicromapVersionInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMicromapVersionInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMicromapVersionInfoEXT pVersionData(@NativeType(value="uint8_t const *") ByteBuffer value) {
        VkMicromapVersionInfoEXT.npVersionData(this.address(), value);
        return this;
    }

    public VkMicromapVersionInfoEXT set(int sType, long pNext, ByteBuffer pVersionData) {
        this.sType(sType);
        this.pNext(pNext);
        this.pVersionData(pVersionData);
        return this;
    }

    public VkMicromapVersionInfoEXT set(VkMicromapVersionInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMicromapVersionInfoEXT malloc() {
        return new VkMicromapVersionInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMicromapVersionInfoEXT calloc() {
        return new VkMicromapVersionInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMicromapVersionInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMicromapVersionInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMicromapVersionInfoEXT create(long address) {
        return new VkMicromapVersionInfoEXT(address, null);
    }

    @Nullable
    public static VkMicromapVersionInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMicromapVersionInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMicromapVersionInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMicromapVersionInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMicromapVersionInfoEXT malloc(MemoryStack stack) {
        return new VkMicromapVersionInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMicromapVersionInfoEXT calloc(MemoryStack stack) {
        return new VkMicromapVersionInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer npVersionData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PVERSIONDATA), capacity);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npVersionData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVERSIONDATA, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVERSIONDATA));
    }

    static {
        Struct.Layout layout = VkMicromapVersionInfoEXT.__struct(VkMicromapVersionInfoEXT.__member(4), VkMicromapVersionInfoEXT.__member(POINTER_SIZE), VkMicromapVersionInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PVERSIONDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMicromapVersionInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMicromapVersionInfoEXT ELEMENT_FACTORY = VkMicromapVersionInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMicromapVersionInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMicromapVersionInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMicromapVersionInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer pVersionData(int capacity) {
            return VkMicromapVersionInfoEXT.npVersionData(this.address(), capacity);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMicromapVersionInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000396001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMicromapVersionInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pVersionData(@NativeType(value="uint8_t const *") ByteBuffer value) {
            VkMicromapVersionInfoEXT.npVersionData(this.address(), value);
            return this;
        }
    }
}

