/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMicromapBuildSizesInfoEXT
extends Struct<VkMicromapBuildSizesInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MICROMAPSIZE;
    public static final int BUILDSCRATCHSIZE;
    public static final int DISCARDABLE;

    protected VkMicromapBuildSizesInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMicromapBuildSizesInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMicromapBuildSizesInfoEXT(address, container);
    }

    public VkMicromapBuildSizesInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMicromapBuildSizesInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMicromapBuildSizesInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMicromapBuildSizesInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long micromapSize() {
        return VkMicromapBuildSizesInfoEXT.nmicromapSize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long buildScratchSize() {
        return VkMicromapBuildSizesInfoEXT.nbuildScratchSize(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean discardable() {
        return VkMicromapBuildSizesInfoEXT.ndiscardable(this.address()) != 0;
    }

    public VkMicromapBuildSizesInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMicromapBuildSizesInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMicromapBuildSizesInfoEXT sType$Default() {
        return this.sType(1000396008);
    }

    public VkMicromapBuildSizesInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMicromapBuildSizesInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMicromapBuildSizesInfoEXT micromapSize(@NativeType(value="VkDeviceSize") long value) {
        VkMicromapBuildSizesInfoEXT.nmicromapSize(this.address(), value);
        return this;
    }

    public VkMicromapBuildSizesInfoEXT buildScratchSize(@NativeType(value="VkDeviceSize") long value) {
        VkMicromapBuildSizesInfoEXT.nbuildScratchSize(this.address(), value);
        return this;
    }

    public VkMicromapBuildSizesInfoEXT discardable(@NativeType(value="VkBool32") boolean value) {
        VkMicromapBuildSizesInfoEXT.ndiscardable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkMicromapBuildSizesInfoEXT set(int sType, long pNext, long micromapSize, long buildScratchSize, boolean discardable) {
        this.sType(sType);
        this.pNext(pNext);
        this.micromapSize(micromapSize);
        this.buildScratchSize(buildScratchSize);
        this.discardable(discardable);
        return this;
    }

    public VkMicromapBuildSizesInfoEXT set(VkMicromapBuildSizesInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMicromapBuildSizesInfoEXT malloc() {
        return new VkMicromapBuildSizesInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMicromapBuildSizesInfoEXT calloc() {
        return new VkMicromapBuildSizesInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMicromapBuildSizesInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMicromapBuildSizesInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMicromapBuildSizesInfoEXT create(long address) {
        return new VkMicromapBuildSizesInfoEXT(address, null);
    }

    @Nullable
    public static VkMicromapBuildSizesInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMicromapBuildSizesInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMicromapBuildSizesInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMicromapBuildSizesInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMicromapBuildSizesInfoEXT malloc(MemoryStack stack) {
        return new VkMicromapBuildSizesInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMicromapBuildSizesInfoEXT calloc(MemoryStack stack) {
        return new VkMicromapBuildSizesInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmicromapSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)MICROMAPSIZE);
    }

    public static long nbuildScratchSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUILDSCRATCHSIZE);
    }

    public static int ndiscardable(long struct) {
        return UNSAFE.getInt(null, struct + (long)DISCARDABLE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmicromapSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MICROMAPSIZE, value);
    }

    public static void nbuildScratchSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUILDSCRATCHSIZE, value);
    }

    public static void ndiscardable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DISCARDABLE, value);
    }

    static {
        Struct.Layout layout = VkMicromapBuildSizesInfoEXT.__struct(VkMicromapBuildSizesInfoEXT.__member(4), VkMicromapBuildSizesInfoEXT.__member(POINTER_SIZE), VkMicromapBuildSizesInfoEXT.__member(8), VkMicromapBuildSizesInfoEXT.__member(8), VkMicromapBuildSizesInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MICROMAPSIZE = layout.offsetof(2);
        BUILDSCRATCHSIZE = layout.offsetof(3);
        DISCARDABLE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkMicromapBuildSizesInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMicromapBuildSizesInfoEXT ELEMENT_FACTORY = VkMicromapBuildSizesInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMicromapBuildSizesInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMicromapBuildSizesInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMicromapBuildSizesInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long micromapSize() {
            return VkMicromapBuildSizesInfoEXT.nmicromapSize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long buildScratchSize() {
            return VkMicromapBuildSizesInfoEXT.nbuildScratchSize(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean discardable() {
            return VkMicromapBuildSizesInfoEXT.ndiscardable(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMicromapBuildSizesInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000396008);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMicromapBuildSizesInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer micromapSize(@NativeType(value="VkDeviceSize") long value) {
            VkMicromapBuildSizesInfoEXT.nmicromapSize(this.address(), value);
            return this;
        }

        public Buffer buildScratchSize(@NativeType(value="VkDeviceSize") long value) {
            VkMicromapBuildSizesInfoEXT.nbuildScratchSize(this.address(), value);
            return this;
        }

        public Buffer discardable(@NativeType(value="VkBool32") boolean value) {
            VkMicromapBuildSizesInfoEXT.ndiscardable(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

