/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryGetRemoteAddressInfoNV
extends Struct<VkMemoryGetRemoteAddressInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int HANDLETYPE;

    protected VkMemoryGetRemoteAddressInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryGetRemoteAddressInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryGetRemoteAddressInfoNV(address, container);
    }

    public VkMemoryGetRemoteAddressInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryGetRemoteAddressInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryGetRemoteAddressInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryGetRemoteAddressInfoNV.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryGetRemoteAddressInfoNV.nmemory(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkMemoryGetRemoteAddressInfoNV.nhandleType(this.address());
    }

    public VkMemoryGetRemoteAddressInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryGetRemoteAddressInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkMemoryGetRemoteAddressInfoNV sType$Default() {
        return this.sType(1000371000);
    }

    public VkMemoryGetRemoteAddressInfoNV pNext(@NativeType(value="void const *") long value) {
        VkMemoryGetRemoteAddressInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkMemoryGetRemoteAddressInfoNV memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryGetRemoteAddressInfoNV.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryGetRemoteAddressInfoNV handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkMemoryGetRemoteAddressInfoNV.nhandleType(this.address(), value);
        return this;
    }

    public VkMemoryGetRemoteAddressInfoNV set(int sType, long pNext, long memory, int handleType) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.handleType(handleType);
        return this;
    }

    public VkMemoryGetRemoteAddressInfoNV set(VkMemoryGetRemoteAddressInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryGetRemoteAddressInfoNV malloc() {
        return new VkMemoryGetRemoteAddressInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryGetRemoteAddressInfoNV calloc() {
        return new VkMemoryGetRemoteAddressInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryGetRemoteAddressInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryGetRemoteAddressInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryGetRemoteAddressInfoNV create(long address) {
        return new VkMemoryGetRemoteAddressInfoNV(address, null);
    }

    @Nullable
    public static VkMemoryGetRemoteAddressInfoNV createSafe(long address) {
        return address == 0L ? null : new VkMemoryGetRemoteAddressInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryGetRemoteAddressInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryGetRemoteAddressInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryGetRemoteAddressInfoNV malloc(MemoryStack stack) {
        return new VkMemoryGetRemoteAddressInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryGetRemoteAddressInfoNV calloc(MemoryStack stack) {
        return new VkMemoryGetRemoteAddressInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    static {
        Struct.Layout layout = VkMemoryGetRemoteAddressInfoNV.__struct(VkMemoryGetRemoteAddressInfoNV.__member(4), VkMemoryGetRemoteAddressInfoNV.__member(POINTER_SIZE), VkMemoryGetRemoteAddressInfoNV.__member(8), VkMemoryGetRemoteAddressInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        HANDLETYPE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryGetRemoteAddressInfoNV, Buffer>
    implements NativeResource {
        private static final VkMemoryGetRemoteAddressInfoNV ELEMENT_FACTORY = VkMemoryGetRemoteAddressInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryGetRemoteAddressInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryGetRemoteAddressInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryGetRemoteAddressInfoNV.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryGetRemoteAddressInfoNV.nmemory(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkMemoryGetRemoteAddressInfoNV.nhandleType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryGetRemoteAddressInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000371000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryGetRemoteAddressInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryGetRemoteAddressInfoNV.nmemory(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkMemoryGetRemoteAddressInfoNV.nhandleType(this.address(), value);
            return this;
        }
    }
}

