/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkLayerSettingEXT;

public class VkLayerSettingsCreateInfoEXT
extends Struct<VkLayerSettingsCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SETTINGCOUNT;
    public static final int PSETTINGS;

    protected VkLayerSettingsCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkLayerSettingsCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkLayerSettingsCreateInfoEXT(address, container);
    }

    public VkLayerSettingsCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkLayerSettingsCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkLayerSettingsCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkLayerSettingsCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int settingCount() {
        return VkLayerSettingsCreateInfoEXT.nsettingCount(this.address());
    }

    @Nullable
    @NativeType(value="VkLayerSettingEXT const *")
    public VkLayerSettingEXT.Buffer pSettings() {
        return VkLayerSettingsCreateInfoEXT.npSettings(this.address());
    }

    public VkLayerSettingsCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkLayerSettingsCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT sType$Default() {
        return this.sType(1000496000);
    }

    public VkLayerSettingsCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkLayerSettingsCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT pSettings(@Nullable @NativeType(value="VkLayerSettingEXT const *") VkLayerSettingEXT.Buffer value) {
        VkLayerSettingsCreateInfoEXT.npSettings(this.address(), value);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT set(int sType, long pNext, @Nullable VkLayerSettingEXT.Buffer pSettings) {
        this.sType(sType);
        this.pNext(pNext);
        this.pSettings(pSettings);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT set(VkLayerSettingsCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkLayerSettingsCreateInfoEXT malloc() {
        return new VkLayerSettingsCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkLayerSettingsCreateInfoEXT calloc() {
        return new VkLayerSettingsCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkLayerSettingsCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkLayerSettingsCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkLayerSettingsCreateInfoEXT create(long address) {
        return new VkLayerSettingsCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkLayerSettingsCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkLayerSettingsCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkLayerSettingsCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkLayerSettingsCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkLayerSettingsCreateInfoEXT malloc(MemoryStack stack) {
        return new VkLayerSettingsCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkLayerSettingsCreateInfoEXT calloc(MemoryStack stack) {
        return new VkLayerSettingsCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsettingCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SETTINGCOUNT);
    }

    @Nullable
    public static VkLayerSettingEXT.Buffer npSettings(long struct) {
        return VkLayerSettingEXT.createSafe(MemoryUtil.memGetAddress(struct + (long)PSETTINGS), VkLayerSettingsCreateInfoEXT.nsettingCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsettingCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SETTINGCOUNT, value);
    }

    public static void npSettings(long struct, @Nullable VkLayerSettingEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSETTINGS, MemoryUtil.memAddressSafe(value));
        VkLayerSettingsCreateInfoEXT.nsettingCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int settingCount = VkLayerSettingsCreateInfoEXT.nsettingCount(struct);
        if (settingCount != 0) {
            long pSettings = MemoryUtil.memGetAddress(struct + (long)PSETTINGS);
            Checks.check(pSettings);
            VkLayerSettingsCreateInfoEXT.validate(pSettings, settingCount, VkLayerSettingEXT.SIZEOF, VkLayerSettingEXT::validate);
        }
    }

    static {
        Struct.Layout layout = VkLayerSettingsCreateInfoEXT.__struct(VkLayerSettingsCreateInfoEXT.__member(4), VkLayerSettingsCreateInfoEXT.__member(POINTER_SIZE), VkLayerSettingsCreateInfoEXT.__member(4), VkLayerSettingsCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SETTINGCOUNT = layout.offsetof(2);
        PSETTINGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkLayerSettingsCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkLayerSettingsCreateInfoEXT ELEMENT_FACTORY = VkLayerSettingsCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkLayerSettingsCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkLayerSettingsCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkLayerSettingsCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int settingCount() {
            return VkLayerSettingsCreateInfoEXT.nsettingCount(this.address());
        }

        @Nullable
        @NativeType(value="VkLayerSettingEXT const *")
        public VkLayerSettingEXT.Buffer pSettings() {
            return VkLayerSettingsCreateInfoEXT.npSettings(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkLayerSettingsCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000496000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkLayerSettingsCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pSettings(@Nullable @NativeType(value="VkLayerSettingEXT const *") VkLayerSettingEXT.Buffer value) {
            VkLayerSettingsCreateInfoEXT.npSettings(this.address(), value);
            return this;
        }
    }
}

