/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkFramebufferAttachmentsCreateInfo;
import org.lwjgl.vulkan.VkFramebufferAttachmentsCreateInfoKHR;

public class VkFramebufferCreateInfo
extends Struct<VkFramebufferCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RENDERPASS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int LAYERS;

    protected VkFramebufferCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkFramebufferCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkFramebufferCreateInfo(address, container);
    }

    public VkFramebufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkFramebufferCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFramebufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFramebufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkFramebufferCreateFlags")
    public int flags() {
        return VkFramebufferCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkFramebufferCreateInfo.nrenderPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkFramebufferCreateInfo.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageView const *")
    public LongBuffer pAttachments() {
        return VkFramebufferCreateInfo.npAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkFramebufferCreateInfo.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkFramebufferCreateInfo.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int layers() {
        return VkFramebufferCreateInfo.nlayers(this.address());
    }

    public VkFramebufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkFramebufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo sType$Default() {
        return this.sType(37);
    }

    public VkFramebufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkFramebufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo pNext(VkFramebufferAttachmentsCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFramebufferCreateInfo pNext(VkFramebufferAttachmentsCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFramebufferCreateInfo flags(@NativeType(value="VkFramebufferCreateFlags") int value) {
        VkFramebufferCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkFramebufferCreateInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo attachmentCount(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nattachmentCount(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
        VkFramebufferCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo width(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nwidth(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo height(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nheight(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo layers(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nlayers(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo set(int sType, long pNext, int flags, long renderPass, int attachmentCount, @Nullable LongBuffer pAttachments, int width, int height, int layers) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.renderPass(renderPass);
        this.attachmentCount(attachmentCount);
        this.pAttachments(pAttachments);
        this.width(width);
        this.height(height);
        this.layers(layers);
        return this;
    }

    public VkFramebufferCreateInfo set(VkFramebufferCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkFramebufferCreateInfo malloc() {
        return new VkFramebufferCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkFramebufferCreateInfo calloc() {
        return new VkFramebufferCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkFramebufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkFramebufferCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkFramebufferCreateInfo create(long address) {
        return new VkFramebufferCreateInfo(address, null);
    }

    @Nullable
    public static VkFramebufferCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkFramebufferCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkFramebufferCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFramebufferCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkFramebufferCreateInfo mallocStack() {
        return VkFramebufferCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFramebufferCreateInfo callocStack() {
        return VkFramebufferCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFramebufferCreateInfo mallocStack(MemoryStack stack) {
        return VkFramebufferCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkFramebufferCreateInfo callocStack(MemoryStack stack) {
        return VkFramebufferCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkFramebufferCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkFramebufferCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFramebufferCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFramebufferCreateInfo.calloc(capacity, stack);
    }

    public static VkFramebufferCreateInfo malloc(MemoryStack stack) {
        return new VkFramebufferCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkFramebufferCreateInfo calloc(MemoryStack stack) {
        return new VkFramebufferCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nrenderPass(long struct) {
        return UNSAFE.getLong(null, struct + (long)RENDERPASS);
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static LongBuffer npAttachments(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS), VkFramebufferCreateInfo.nattachmentCount(struct));
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nlayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nrenderPass(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RENDERPASS, value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PATTACHMENTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkFramebufferCreateInfo.nattachmentCount(struct, value.remaining());
        }
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nlayers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERS, value);
    }

    static {
        Struct.Layout layout = VkFramebufferCreateInfo.__struct(VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(POINTER_SIZE), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(8), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(POINTER_SIZE), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(4), VkFramebufferCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RENDERPASS = layout.offsetof(3);
        ATTACHMENTCOUNT = layout.offsetof(4);
        PATTACHMENTS = layout.offsetof(5);
        WIDTH = layout.offsetof(6);
        HEIGHT = layout.offsetof(7);
        LAYERS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkFramebufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkFramebufferCreateInfo ELEMENT_FACTORY = VkFramebufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkFramebufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFramebufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFramebufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkFramebufferCreateFlags")
        public int flags() {
            return VkFramebufferCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkFramebufferCreateInfo.nrenderPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkFramebufferCreateInfo.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageView const *")
        public LongBuffer pAttachments() {
            return VkFramebufferCreateInfo.npAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkFramebufferCreateInfo.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkFramebufferCreateInfo.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int layers() {
            return VkFramebufferCreateInfo.nlayers(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFramebufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(37);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFramebufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkFramebufferAttachmentsCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkFramebufferAttachmentsCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkFramebufferCreateFlags") int value) {
            VkFramebufferCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkFramebufferCreateInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer attachmentCount(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nattachmentCount(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
            VkFramebufferCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer layers(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nlayers(this.address(), value);
            return this;
        }
    }
}

