/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFormatProperties3
extends Struct<VkFormatProperties3>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int LINEARTILINGFEATURES;
    public static final int OPTIMALTILINGFEATURES;
    public static final int BUFFERFEATURES;

    protected VkFormatProperties3(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkFormatProperties3 create(long address, @Nullable ByteBuffer container) {
        return new VkFormatProperties3(address, container);
    }

    public VkFormatProperties3(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkFormatProperties3.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFormatProperties3.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkFormatProperties3.npNext(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags2")
    public long linearTilingFeatures() {
        return VkFormatProperties3.nlinearTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags2")
    public long optimalTilingFeatures() {
        return VkFormatProperties3.noptimalTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags2")
    public long bufferFeatures() {
        return VkFormatProperties3.nbufferFeatures(this.address());
    }

    public VkFormatProperties3 sType(@NativeType(value="VkStructureType") int value) {
        VkFormatProperties3.nsType(this.address(), value);
        return this;
    }

    public VkFormatProperties3 sType$Default() {
        return this.sType(1000360000);
    }

    public VkFormatProperties3 pNext(@NativeType(value="void *") long value) {
        VkFormatProperties3.npNext(this.address(), value);
        return this;
    }

    public VkFormatProperties3 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkFormatProperties3 set(VkFormatProperties3 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkFormatProperties3 malloc() {
        return new VkFormatProperties3(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkFormatProperties3 calloc() {
        return new VkFormatProperties3(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkFormatProperties3 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkFormatProperties3(MemoryUtil.memAddress(container), container);
    }

    public static VkFormatProperties3 create(long address) {
        return new VkFormatProperties3(address, null);
    }

    @Nullable
    public static VkFormatProperties3 createSafe(long address) {
        return address == 0L ? null : new VkFormatProperties3(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkFormatProperties3.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFormatProperties3.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkFormatProperties3 malloc(MemoryStack stack) {
        return new VkFormatProperties3(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkFormatProperties3 calloc(MemoryStack stack) {
        return new VkFormatProperties3(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nlinearTilingFeatures(long struct) {
        return UNSAFE.getLong(null, struct + (long)LINEARTILINGFEATURES);
    }

    public static long noptimalTilingFeatures(long struct) {
        return UNSAFE.getLong(null, struct + (long)OPTIMALTILINGFEATURES);
    }

    public static long nbufferFeatures(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFERFEATURES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkFormatProperties3.__struct(VkFormatProperties3.__member(4), VkFormatProperties3.__member(POINTER_SIZE), VkFormatProperties3.__member(8), VkFormatProperties3.__member(8), VkFormatProperties3.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        LINEARTILINGFEATURES = layout.offsetof(2);
        OPTIMALTILINGFEATURES = layout.offsetof(3);
        BUFFERFEATURES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkFormatProperties3, Buffer>
    implements NativeResource {
        private static final VkFormatProperties3 ELEMENT_FACTORY = VkFormatProperties3.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkFormatProperties3 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFormatProperties3.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkFormatProperties3.npNext(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags2")
        public long linearTilingFeatures() {
            return VkFormatProperties3.nlinearTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags2")
        public long optimalTilingFeatures() {
            return VkFormatProperties3.noptimalTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags2")
        public long bufferFeatures() {
            return VkFormatProperties3.nbufferFeatures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFormatProperties3.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000360000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkFormatProperties3.npNext(this.address(), value);
            return this;
        }
    }
}

