/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportMemoryAllocateInfoNV
extends Struct<VkExportMemoryAllocateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    protected VkExportMemoryAllocateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExportMemoryAllocateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkExportMemoryAllocateInfoNV(address, container);
    }

    public VkExportMemoryAllocateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExportMemoryAllocateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMemoryAllocateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMemoryAllocateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int handleTypes() {
        return VkExportMemoryAllocateInfoNV.nhandleTypes(this.address());
    }

    public VkExportMemoryAllocateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryAllocateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoNV sType$Default() {
        return this.sType(1000056001);
    }

    public VkExportMemoryAllocateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryAllocateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoNV handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
        VkExportMemoryAllocateInfoNV.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoNV set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfoNV set(VkExportMemoryAllocateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfoNV malloc() {
        return new VkExportMemoryAllocateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExportMemoryAllocateInfoNV calloc() {
        return new VkExportMemoryAllocateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExportMemoryAllocateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExportMemoryAllocateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkExportMemoryAllocateInfoNV create(long address) {
        return new VkExportMemoryAllocateInfoNV(address, null);
    }

    @Nullable
    public static VkExportMemoryAllocateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkExportMemoryAllocateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExportMemoryAllocateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportMemoryAllocateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoNV mallocStack() {
        return VkExportMemoryAllocateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoNV callocStack() {
        return VkExportMemoryAllocateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoNV mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoNV callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.calloc(capacity, stack);
    }

    public static VkExportMemoryAllocateInfoNV malloc(MemoryStack stack) {
        return new VkExportMemoryAllocateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExportMemoryAllocateInfoNV calloc(MemoryStack stack) {
        return new VkExportMemoryAllocateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportMemoryAllocateInfoNV.__struct(VkExportMemoryAllocateInfoNV.__member(4), VkExportMemoryAllocateInfoNV.__member(POINTER_SIZE), VkExportMemoryAllocateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryAllocateInfoNV, Buffer>
    implements NativeResource {
        private static final VkExportMemoryAllocateInfoNV ELEMENT_FACTORY = VkExportMemoryAllocateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExportMemoryAllocateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMemoryAllocateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMemoryAllocateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int handleTypes() {
            return VkExportMemoryAllocateInfoNV.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryAllocateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000056001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryAllocateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
            VkExportMemoryAllocateInfoNV.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

