/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceQueueGlobalPriorityCreateInfoEXT;
import org.lwjgl.vulkan.VkDeviceQueueGlobalPriorityCreateInfoKHR;
import org.lwjgl.vulkan.VkDeviceQueueShaderCoreControlCreateInfoARM;

public class VkDeviceQueueCreateInfo
extends Struct<VkDeviceQueueCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUEFAMILYINDEX;
    public static final int QUEUECOUNT;
    public static final int PQUEUEPRIORITIES;

    protected VkDeviceQueueCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceQueueCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceQueueCreateInfo(address, container);
    }

    public VkDeviceQueueCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceQueueCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceQueueCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceQueueCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDeviceQueueCreateFlags")
    public int flags() {
        return VkDeviceQueueCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueCount() {
        return VkDeviceQueueCreateInfo.nqueueCount(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer pQueuePriorities() {
        return VkDeviceQueueCreateInfo.npQueuePriorities(this.address());
    }

    public VkDeviceQueueCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceQueueCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo sType$Default() {
        return this.sType(2);
    }

    public VkDeviceQueueCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceQueueCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo pNext(VkDeviceQueueGlobalPriorityCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDeviceQueueCreateInfo pNext(VkDeviceQueueGlobalPriorityCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDeviceQueueCreateInfo pNext(VkDeviceQueueShaderCoreControlCreateInfoARM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDeviceQueueCreateInfo flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
        VkDeviceQueueCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo pQueuePriorities(@NativeType(value="float const *") FloatBuffer value) {
        VkDeviceQueueCreateInfo.npQueuePriorities(this.address(), value);
        return this;
    }

    public VkDeviceQueueCreateInfo set(int sType, long pNext, int flags, int queueFamilyIndex, FloatBuffer pQueuePriorities) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queueFamilyIndex(queueFamilyIndex);
        this.pQueuePriorities(pQueuePriorities);
        return this;
    }

    public VkDeviceQueueCreateInfo set(VkDeviceQueueCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceQueueCreateInfo malloc() {
        return new VkDeviceQueueCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceQueueCreateInfo calloc() {
        return new VkDeviceQueueCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceQueueCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceQueueCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceQueueCreateInfo create(long address) {
        return new VkDeviceQueueCreateInfo(address, null);
    }

    @Nullable
    public static VkDeviceQueueCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceQueueCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceQueueCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceQueueCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceQueueCreateInfo mallocStack() {
        return VkDeviceQueueCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceQueueCreateInfo callocStack() {
        return VkDeviceQueueCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceQueueCreateInfo mallocStack(MemoryStack stack) {
        return VkDeviceQueueCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkDeviceQueueCreateInfo callocStack(MemoryStack stack) {
        return VkDeviceQueueCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceQueueCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceQueueCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueCreateInfo.calloc(capacity, stack);
    }

    public static VkDeviceQueueCreateInfo malloc(MemoryStack stack) {
        return new VkDeviceQueueCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceQueueCreateInfo calloc(MemoryStack stack) {
        return new VkDeviceQueueCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nqueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEX);
    }

    public static int nqueueCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUECOUNT);
    }

    public static FloatBuffer npQueuePriorities(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)PQUEUEPRIORITIES), VkDeviceQueueCreateInfo.nqueueCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEX, value);
    }

    public static void nqueueCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUECOUNT, value);
    }

    public static void npQueuePriorities(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEPRIORITIES, MemoryUtil.memAddress(value));
        VkDeviceQueueCreateInfo.nqueueCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PQUEUEPRIORITIES));
    }

    static {
        Struct.Layout layout = VkDeviceQueueCreateInfo.__struct(VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(POINTER_SIZE), VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(4), VkDeviceQueueCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUEFAMILYINDEX = layout.offsetof(3);
        QUEUECOUNT = layout.offsetof(4);
        PQUEUEPRIORITIES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceQueueCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceQueueCreateInfo ELEMENT_FACTORY = VkDeviceQueueCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceQueueCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceQueueCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceQueueCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDeviceQueueCreateFlags")
        public int flags() {
            return VkDeviceQueueCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueCount() {
            return VkDeviceQueueCreateInfo.nqueueCount(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer pQueuePriorities() {
            return VkDeviceQueueCreateInfo.npQueuePriorities(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceQueueCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(2);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceQueueCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceQueueGlobalPriorityCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceQueueGlobalPriorityCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceQueueShaderCoreControlCreateInfoARM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
            VkDeviceQueueCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceQueueCreateInfo.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer pQueuePriorities(@NativeType(value="float const *") FloatBuffer value) {
            VkDeviceQueueCreateInfo.npQueuePriorities(this.address(), value);
            return this;
        }
    }
}

