/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceMemoryOverallocationCreateInfoAMD
extends Struct<VkDeviceMemoryOverallocationCreateInfoAMD>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OVERALLOCATIONBEHAVIOR;

    protected VkDeviceMemoryOverallocationCreateInfoAMD(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceMemoryOverallocationCreateInfoAMD create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceMemoryOverallocationCreateInfoAMD(address, container);
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceMemoryOverallocationCreateInfoAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceMemoryOverallocationCreateInfoAMD.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceMemoryOverallocationCreateInfoAMD.npNext(this.address());
    }

    @NativeType(value="VkMemoryOverallocationBehaviorAMD")
    public int overallocationBehavior() {
        return VkDeviceMemoryOverallocationCreateInfoAMD.noverallocationBehavior(this.address());
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceMemoryOverallocationCreateInfoAMD.nsType(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD sType$Default() {
        return this.sType(1000189000);
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD pNext(@NativeType(value="void const *") long value) {
        VkDeviceMemoryOverallocationCreateInfoAMD.npNext(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD overallocationBehavior(@NativeType(value="VkMemoryOverallocationBehaviorAMD") int value) {
        VkDeviceMemoryOverallocationCreateInfoAMD.noverallocationBehavior(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD set(int sType, long pNext, int overallocationBehavior) {
        this.sType(sType);
        this.pNext(pNext);
        this.overallocationBehavior(overallocationBehavior);
        return this;
    }

    public VkDeviceMemoryOverallocationCreateInfoAMD set(VkDeviceMemoryOverallocationCreateInfoAMD src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceMemoryOverallocationCreateInfoAMD malloc() {
        return new VkDeviceMemoryOverallocationCreateInfoAMD(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceMemoryOverallocationCreateInfoAMD calloc() {
        return new VkDeviceMemoryOverallocationCreateInfoAMD(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceMemoryOverallocationCreateInfoAMD create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceMemoryOverallocationCreateInfoAMD(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceMemoryOverallocationCreateInfoAMD create(long address) {
        return new VkDeviceMemoryOverallocationCreateInfoAMD(address, null);
    }

    @Nullable
    public static VkDeviceMemoryOverallocationCreateInfoAMD createSafe(long address) {
        return address == 0L ? null : new VkDeviceMemoryOverallocationCreateInfoAMD(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceMemoryOverallocationCreateInfoAMD.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceMemoryOverallocationCreateInfoAMD.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceMemoryOverallocationCreateInfoAMD mallocStack() {
        return VkDeviceMemoryOverallocationCreateInfoAMD.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceMemoryOverallocationCreateInfoAMD callocStack() {
        return VkDeviceMemoryOverallocationCreateInfoAMD.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceMemoryOverallocationCreateInfoAMD mallocStack(MemoryStack stack) {
        return VkDeviceMemoryOverallocationCreateInfoAMD.malloc(stack);
    }

    @Deprecated
    public static VkDeviceMemoryOverallocationCreateInfoAMD callocStack(MemoryStack stack) {
        return VkDeviceMemoryOverallocationCreateInfoAMD.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceMemoryOverallocationCreateInfoAMD.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceMemoryOverallocationCreateInfoAMD.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceMemoryOverallocationCreateInfoAMD.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceMemoryOverallocationCreateInfoAMD.calloc(capacity, stack);
    }

    public static VkDeviceMemoryOverallocationCreateInfoAMD malloc(MemoryStack stack) {
        return new VkDeviceMemoryOverallocationCreateInfoAMD(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceMemoryOverallocationCreateInfoAMD calloc(MemoryStack stack) {
        return new VkDeviceMemoryOverallocationCreateInfoAMD(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int noverallocationBehavior(long struct) {
        return UNSAFE.getInt(null, struct + (long)OVERALLOCATIONBEHAVIOR);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void noverallocationBehavior(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OVERALLOCATIONBEHAVIOR, value);
    }

    static {
        Struct.Layout layout = VkDeviceMemoryOverallocationCreateInfoAMD.__struct(VkDeviceMemoryOverallocationCreateInfoAMD.__member(4), VkDeviceMemoryOverallocationCreateInfoAMD.__member(POINTER_SIZE), VkDeviceMemoryOverallocationCreateInfoAMD.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OVERALLOCATIONBEHAVIOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceMemoryOverallocationCreateInfoAMD, Buffer>
    implements NativeResource {
        private static final VkDeviceMemoryOverallocationCreateInfoAMD ELEMENT_FACTORY = VkDeviceMemoryOverallocationCreateInfoAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceMemoryOverallocationCreateInfoAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceMemoryOverallocationCreateInfoAMD.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceMemoryOverallocationCreateInfoAMD.npNext(this.address());
        }

        @NativeType(value="VkMemoryOverallocationBehaviorAMD")
        public int overallocationBehavior() {
            return VkDeviceMemoryOverallocationCreateInfoAMD.noverallocationBehavior(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceMemoryOverallocationCreateInfoAMD.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000189000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceMemoryOverallocationCreateInfoAMD.npNext(this.address(), value);
            return this;
        }

        public Buffer overallocationBehavior(@NativeType(value="VkMemoryOverallocationBehaviorAMD") int value) {
            VkDeviceMemoryOverallocationCreateInfoAMD.noverallocationBehavior(this.address(), value);
            return this;
        }
    }
}

