/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleDevice;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VkDevice
extends DispatchableHandleDevice {
    private final VkPhysicalDevice physicalDevice;

    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci) {
        this(handle, physicalDevice, ci, 0);
    }

    public VkDevice(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci, int apiVersion) {
        super(handle, VkDevice.getDeviceCapabilities(handle, physicalDevice, ci, apiVersion));
        this.physicalDevice = physicalDevice;
    }

    public VkPhysicalDevice getPhysicalDevice() {
        return this.physicalDevice;
    }

    private static VKCapabilitiesDevice getDeviceCapabilities(long handle, VkPhysicalDevice physicalDevice, VkDeviceCreateInfo ci, int apiVersion) {
        long GetDeviceProcAddr;
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (apiVersion == 0) {
                VkPhysicalDeviceProperties props = VkPhysicalDeviceProperties.calloc(stack);
                VK10.vkGetPhysicalDeviceProperties(physicalDevice, props);
                apiVersion = Math.min(props.apiVersion(), physicalDevice.getInstance().getCapabilities().apiVersion) & 0xFFFFF000;
            }
            GetDeviceProcAddr = VK10.vkGetInstanceProcAddr(physicalDevice.getInstance(), "vkGetDeviceProcAddr");
        }
        return new VKCapabilitiesDevice(functionName -> {
            long address = JNI.callPPP(handle, MemoryUtil.memAddress(functionName), GetDeviceProcAddr);
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLogMissing("VK device", functionName);
            }
            return address;
        }, physicalDevice.getCapabilities(), apiVersion, VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()));
    }

    @Override
    public VKCapabilitiesInstance getCapabilitiesInstance() {
        return this.getPhysicalDevice().getCapabilities();
    }
}

