/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorImageInfo
extends Struct<VkDescriptorImageInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLER;
    public static final int IMAGEVIEW;
    public static final int IMAGELAYOUT;

    protected VkDescriptorImageInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDescriptorImageInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorImageInfo(address, container);
    }

    public VkDescriptorImageInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorImageInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkSampler")
    public long sampler() {
        return VkDescriptorImageInfo.nsampler(this.address());
    }

    @NativeType(value="VkImageView")
    public long imageView() {
        return VkDescriptorImageInfo.nimageView(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int imageLayout() {
        return VkDescriptorImageInfo.nimageLayout(this.address());
    }

    public VkDescriptorImageInfo sampler(@NativeType(value="VkSampler") long value) {
        VkDescriptorImageInfo.nsampler(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo imageView(@NativeType(value="VkImageView") long value) {
        VkDescriptorImageInfo.nimageView(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo imageLayout(@NativeType(value="VkImageLayout") int value) {
        VkDescriptorImageInfo.nimageLayout(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo set(long sampler, long imageView, int imageLayout) {
        this.sampler(sampler);
        this.imageView(imageView);
        this.imageLayout(imageLayout);
        return this;
    }

    public VkDescriptorImageInfo set(VkDescriptorImageInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorImageInfo malloc() {
        return new VkDescriptorImageInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDescriptorImageInfo calloc() {
        return new VkDescriptorImageInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDescriptorImageInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDescriptorImageInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorImageInfo create(long address) {
        return new VkDescriptorImageInfo(address, null);
    }

    @Nullable
    public static VkDescriptorImageInfo createSafe(long address) {
        return address == 0L ? null : new VkDescriptorImageInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDescriptorImageInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorImageInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorImageInfo mallocStack() {
        return VkDescriptorImageInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorImageInfo callocStack() {
        return VkDescriptorImageInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorImageInfo mallocStack(MemoryStack stack) {
        return VkDescriptorImageInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorImageInfo callocStack(MemoryStack stack) {
        return VkDescriptorImageInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorImageInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorImageInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorImageInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorImageInfo.calloc(capacity, stack);
    }

    public static VkDescriptorImageInfo malloc(MemoryStack stack) {
        return new VkDescriptorImageInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorImageInfo calloc(MemoryStack stack) {
        return new VkDescriptorImageInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsampler(long struct) {
        return UNSAFE.getLong(null, struct + (long)SAMPLER);
    }

    public static long nimageView(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEVIEW);
    }

    public static int nimageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGELAYOUT);
    }

    public static void nsampler(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SAMPLER, value);
    }

    public static void nimageView(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGEVIEW, value);
    }

    public static void nimageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGELAYOUT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorImageInfo.__struct(VkDescriptorImageInfo.__member(8), VkDescriptorImageInfo.__member(8), VkDescriptorImageInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLER = layout.offsetof(0);
        IMAGEVIEW = layout.offsetof(1);
        IMAGELAYOUT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorImageInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorImageInfo ELEMENT_FACTORY = VkDescriptorImageInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDescriptorImageInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkSampler")
        public long sampler() {
            return VkDescriptorImageInfo.nsampler(this.address());
        }

        @NativeType(value="VkImageView")
        public long imageView() {
            return VkDescriptorImageInfo.nimageView(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int imageLayout() {
            return VkDescriptorImageInfo.nimageLayout(this.address());
        }

        public Buffer sampler(@NativeType(value="VkSampler") long value) {
            VkDescriptorImageInfo.nsampler(this.address(), value);
            return this;
        }

        public Buffer imageView(@NativeType(value="VkImageView") long value) {
            VkDescriptorImageInfo.nimageView(this.address(), value);
            return this;
        }

        public Buffer imageLayout(@NativeType(value="VkImageLayout") int value) {
            VkDescriptorImageInfo.nimageLayout(this.address(), value);
            return this;
        }
    }
}

