/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCudaModuleCreateInfoNV
extends Struct<VkCudaModuleCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DATASIZE;
    public static final int PDATA;

    protected VkCudaModuleCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCudaModuleCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkCudaModuleCreateInfoNV(address, container);
    }

    public VkCudaModuleCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCudaModuleCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCudaModuleCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCudaModuleCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="size_t")
    public long dataSize() {
        return VkCudaModuleCreateInfoNV.ndataSize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pData() {
        return VkCudaModuleCreateInfoNV.npData(this.address());
    }

    public VkCudaModuleCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkCudaModuleCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkCudaModuleCreateInfoNV sType$Default() {
        return this.sType(1000307000);
    }

    public VkCudaModuleCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkCudaModuleCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkCudaModuleCreateInfoNV pData(@NativeType(value="void const *") ByteBuffer value) {
        VkCudaModuleCreateInfoNV.npData(this.address(), value);
        return this;
    }

    public VkCudaModuleCreateInfoNV set(int sType, long pNext, ByteBuffer pData) {
        this.sType(sType);
        this.pNext(pNext);
        this.pData(pData);
        return this;
    }

    public VkCudaModuleCreateInfoNV set(VkCudaModuleCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCudaModuleCreateInfoNV malloc() {
        return new VkCudaModuleCreateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCudaModuleCreateInfoNV calloc() {
        return new VkCudaModuleCreateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCudaModuleCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCudaModuleCreateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkCudaModuleCreateInfoNV create(long address) {
        return new VkCudaModuleCreateInfoNV(address, null);
    }

    @Nullable
    public static VkCudaModuleCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkCudaModuleCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCudaModuleCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCudaModuleCreateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCudaModuleCreateInfoNV malloc(MemoryStack stack) {
        return new VkCudaModuleCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCudaModuleCreateInfoNV calloc(MemoryStack stack) {
        return new VkCudaModuleCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATASIZE);
    }

    public static ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PDATA), (int)VkCudaModuleCreateInfoNV.ndataSize(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATASIZE, value);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddress(value));
        VkCudaModuleCreateInfoNV.ndataSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
    }

    static {
        Struct.Layout layout = VkCudaModuleCreateInfoNV.__struct(VkCudaModuleCreateInfoNV.__member(4), VkCudaModuleCreateInfoNV.__member(POINTER_SIZE), VkCudaModuleCreateInfoNV.__member(POINTER_SIZE), VkCudaModuleCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DATASIZE = layout.offsetof(2);
        PDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCudaModuleCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkCudaModuleCreateInfoNV ELEMENT_FACTORY = VkCudaModuleCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCudaModuleCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCudaModuleCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCudaModuleCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="size_t")
        public long dataSize() {
            return VkCudaModuleCreateInfoNV.ndataSize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pData() {
            return VkCudaModuleCreateInfoNV.npData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCudaModuleCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000307000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCudaModuleCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pData(@NativeType(value="void const *") ByteBuffer value) {
            VkCudaModuleCreateInfoNV.npData(this.address(), value);
            return this;
        }
    }
}

