/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressConstKHR;

public class VkCopyMemoryToAccelerationStructureInfoKHR
extends Struct<VkCopyMemoryToAccelerationStructureInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRC;
    public static final int DST;
    public static final int MODE;

    protected VkCopyMemoryToAccelerationStructureInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyMemoryToAccelerationStructureInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryToAccelerationStructureInfoKHR(address, container);
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCopyMemoryToAccelerationStructureInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyMemoryToAccelerationStructureInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyMemoryToAccelerationStructureInfoKHR.npNext(this.address());
    }

    public VkDeviceOrHostAddressConstKHR src() {
        return VkCopyMemoryToAccelerationStructureInfoKHR.nsrc(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long dst() {
        return VkCopyMemoryToAccelerationStructureInfoKHR.ndst(this.address());
    }

    @NativeType(value="VkCopyAccelerationStructureModeKHR")
    public int mode() {
        return VkCopyMemoryToAccelerationStructureInfoKHR.nmode(this.address());
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkCopyMemoryToAccelerationStructureInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR sType$Default() {
        return this.sType(1000150012);
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkCopyMemoryToAccelerationStructureInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR src(VkDeviceOrHostAddressConstKHR value) {
        VkCopyMemoryToAccelerationStructureInfoKHR.nsrc(this.address(), value);
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR src(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
        consumer.accept(this.src());
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR dst(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkCopyMemoryToAccelerationStructureInfoKHR.ndst(this.address(), value);
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR mode(@NativeType(value="VkCopyAccelerationStructureModeKHR") int value) {
        VkCopyMemoryToAccelerationStructureInfoKHR.nmode(this.address(), value);
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR set(int sType, long pNext, VkDeviceOrHostAddressConstKHR src, long dst, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.src(src);
        this.dst(dst);
        this.mode(mode);
        return this;
    }

    public VkCopyMemoryToAccelerationStructureInfoKHR set(VkCopyMemoryToAccelerationStructureInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyMemoryToAccelerationStructureInfoKHR malloc() {
        return new VkCopyMemoryToAccelerationStructureInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyMemoryToAccelerationStructureInfoKHR calloc() {
        return new VkCopyMemoryToAccelerationStructureInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyMemoryToAccelerationStructureInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyMemoryToAccelerationStructureInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyMemoryToAccelerationStructureInfoKHR create(long address) {
        return new VkCopyMemoryToAccelerationStructureInfoKHR(address, null);
    }

    @Nullable
    public static VkCopyMemoryToAccelerationStructureInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryToAccelerationStructureInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyMemoryToAccelerationStructureInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryToAccelerationStructureInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryToAccelerationStructureInfoKHR malloc(MemoryStack stack) {
        return new VkCopyMemoryToAccelerationStructureInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryToAccelerationStructureInfoKHR calloc(MemoryStack stack) {
        return new VkCopyMemoryToAccelerationStructureInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkDeviceOrHostAddressConstKHR nsrc(long struct) {
        return VkDeviceOrHostAddressConstKHR.create(struct + (long)SRC);
    }

    public static long ndst(long struct) {
        return UNSAFE.getLong(null, struct + (long)DST);
    }

    public static int nmode(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrc(long struct, VkDeviceOrHostAddressConstKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRC, VkDeviceOrHostAddressConstKHR.SIZEOF);
    }

    public static void ndst(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DST, value);
    }

    public static void nmode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MODE, value);
    }

    static {
        Struct.Layout layout = VkCopyMemoryToAccelerationStructureInfoKHR.__struct(VkCopyMemoryToAccelerationStructureInfoKHR.__member(4), VkCopyMemoryToAccelerationStructureInfoKHR.__member(POINTER_SIZE), VkCopyMemoryToAccelerationStructureInfoKHR.__member(VkDeviceOrHostAddressConstKHR.SIZEOF, VkDeviceOrHostAddressConstKHR.ALIGNOF), VkCopyMemoryToAccelerationStructureInfoKHR.__member(8), VkCopyMemoryToAccelerationStructureInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRC = layout.offsetof(2);
        DST = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMemoryToAccelerationStructureInfoKHR, Buffer>
    implements NativeResource {
        private static final VkCopyMemoryToAccelerationStructureInfoKHR ELEMENT_FACTORY = VkCopyMemoryToAccelerationStructureInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCopyMemoryToAccelerationStructureInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyMemoryToAccelerationStructureInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyMemoryToAccelerationStructureInfoKHR.npNext(this.address());
        }

        public VkDeviceOrHostAddressConstKHR src() {
            return VkCopyMemoryToAccelerationStructureInfoKHR.nsrc(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long dst() {
            return VkCopyMemoryToAccelerationStructureInfoKHR.ndst(this.address());
        }

        @NativeType(value="VkCopyAccelerationStructureModeKHR")
        public int mode() {
            return VkCopyMemoryToAccelerationStructureInfoKHR.nmode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyMemoryToAccelerationStructureInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150012);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyMemoryToAccelerationStructureInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer src(VkDeviceOrHostAddressConstKHR value) {
            VkCopyMemoryToAccelerationStructureInfoKHR.nsrc(this.address(), value);
            return this;
        }

        public Buffer src(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
            consumer.accept(this.src());
            return this;
        }

        public Buffer dst(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkCopyMemoryToAccelerationStructureInfoKHR.ndst(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkCopyAccelerationStructureModeKHR") int value) {
            VkCopyMemoryToAccelerationStructureInfoKHR.nmode(this.address(), value);
            return this;
        }
    }
}

