/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCopyMemoryIndirectCommandNV
extends Struct<VkCopyMemoryIndirectCommandNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCADDRESS;
    public static final int DSTADDRESS;
    public static final int SIZE;

    protected VkCopyMemoryIndirectCommandNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyMemoryIndirectCommandNV create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryIndirectCommandNV(address, container);
    }

    public VkCopyMemoryIndirectCommandNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCopyMemoryIndirectCommandNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long srcAddress() {
        return VkCopyMemoryIndirectCommandNV.nsrcAddress(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long dstAddress() {
        return VkCopyMemoryIndirectCommandNV.ndstAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkCopyMemoryIndirectCommandNV.nsize(this.address());
    }

    public VkCopyMemoryIndirectCommandNV srcAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkCopyMemoryIndirectCommandNV.nsrcAddress(this.address(), value);
        return this;
    }

    public VkCopyMemoryIndirectCommandNV dstAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkCopyMemoryIndirectCommandNV.ndstAddress(this.address(), value);
        return this;
    }

    public VkCopyMemoryIndirectCommandNV size(@NativeType(value="VkDeviceSize") long value) {
        VkCopyMemoryIndirectCommandNV.nsize(this.address(), value);
        return this;
    }

    public VkCopyMemoryIndirectCommandNV set(long srcAddress, long dstAddress, long size) {
        this.srcAddress(srcAddress);
        this.dstAddress(dstAddress);
        this.size(size);
        return this;
    }

    public VkCopyMemoryIndirectCommandNV set(VkCopyMemoryIndirectCommandNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyMemoryIndirectCommandNV malloc() {
        return new VkCopyMemoryIndirectCommandNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyMemoryIndirectCommandNV calloc() {
        return new VkCopyMemoryIndirectCommandNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyMemoryIndirectCommandNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyMemoryIndirectCommandNV(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyMemoryIndirectCommandNV create(long address) {
        return new VkCopyMemoryIndirectCommandNV(address, null);
    }

    @Nullable
    public static VkCopyMemoryIndirectCommandNV createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryIndirectCommandNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyMemoryIndirectCommandNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryIndirectCommandNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryIndirectCommandNV malloc(MemoryStack stack) {
        return new VkCopyMemoryIndirectCommandNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryIndirectCommandNV calloc(MemoryStack stack) {
        return new VkCopyMemoryIndirectCommandNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCADDRESS);
    }

    public static long ndstAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTADDRESS);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void nsrcAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCADDRESS, value);
    }

    public static void ndstAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTADDRESS, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkCopyMemoryIndirectCommandNV.__struct(VkCopyMemoryIndirectCommandNV.__member(8), VkCopyMemoryIndirectCommandNV.__member(8), VkCopyMemoryIndirectCommandNV.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCADDRESS = layout.offsetof(0);
        DSTADDRESS = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMemoryIndirectCommandNV, Buffer>
    implements NativeResource {
        private static final VkCopyMemoryIndirectCommandNV ELEMENT_FACTORY = VkCopyMemoryIndirectCommandNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCopyMemoryIndirectCommandNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long srcAddress() {
            return VkCopyMemoryIndirectCommandNV.nsrcAddress(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long dstAddress() {
            return VkCopyMemoryIndirectCommandNV.ndstAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkCopyMemoryIndirectCommandNV.nsize(this.address());
        }

        public Buffer srcAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkCopyMemoryIndirectCommandNV.nsrcAddress(this.address(), value);
            return this;
        }

        public Buffer dstAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkCopyMemoryIndirectCommandNV.ndstAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkCopyMemoryIndirectCommandNV.nsize(this.address(), value);
            return this;
        }
    }
}

