/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkColorBlendEquationEXT
extends Struct<VkColorBlendEquationEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCCOLORBLENDFACTOR;
    public static final int DSTCOLORBLENDFACTOR;
    public static final int COLORBLENDOP;
    public static final int SRCALPHABLENDFACTOR;
    public static final int DSTALPHABLENDFACTOR;
    public static final int ALPHABLENDOP;

    protected VkColorBlendEquationEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkColorBlendEquationEXT create(long address, @Nullable ByteBuffer container) {
        return new VkColorBlendEquationEXT(address, container);
    }

    public VkColorBlendEquationEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkColorBlendEquationEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBlendFactor")
    public int srcColorBlendFactor() {
        return VkColorBlendEquationEXT.nsrcColorBlendFactor(this.address());
    }

    @NativeType(value="VkBlendFactor")
    public int dstColorBlendFactor() {
        return VkColorBlendEquationEXT.ndstColorBlendFactor(this.address());
    }

    @NativeType(value="VkBlendOp")
    public int colorBlendOp() {
        return VkColorBlendEquationEXT.ncolorBlendOp(this.address());
    }

    @NativeType(value="VkBlendFactor")
    public int srcAlphaBlendFactor() {
        return VkColorBlendEquationEXT.nsrcAlphaBlendFactor(this.address());
    }

    @NativeType(value="VkBlendFactor")
    public int dstAlphaBlendFactor() {
        return VkColorBlendEquationEXT.ndstAlphaBlendFactor(this.address());
    }

    @NativeType(value="VkBlendOp")
    public int alphaBlendOp() {
        return VkColorBlendEquationEXT.nalphaBlendOp(this.address());
    }

    public VkColorBlendEquationEXT srcColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkColorBlendEquationEXT.nsrcColorBlendFactor(this.address(), value);
        return this;
    }

    public VkColorBlendEquationEXT dstColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkColorBlendEquationEXT.ndstColorBlendFactor(this.address(), value);
        return this;
    }

    public VkColorBlendEquationEXT colorBlendOp(@NativeType(value="VkBlendOp") int value) {
        VkColorBlendEquationEXT.ncolorBlendOp(this.address(), value);
        return this;
    }

    public VkColorBlendEquationEXT srcAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkColorBlendEquationEXT.nsrcAlphaBlendFactor(this.address(), value);
        return this;
    }

    public VkColorBlendEquationEXT dstAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
        VkColorBlendEquationEXT.ndstAlphaBlendFactor(this.address(), value);
        return this;
    }

    public VkColorBlendEquationEXT alphaBlendOp(@NativeType(value="VkBlendOp") int value) {
        VkColorBlendEquationEXT.nalphaBlendOp(this.address(), value);
        return this;
    }

    public VkColorBlendEquationEXT set(int srcColorBlendFactor, int dstColorBlendFactor, int colorBlendOp, int srcAlphaBlendFactor, int dstAlphaBlendFactor, int alphaBlendOp) {
        this.srcColorBlendFactor(srcColorBlendFactor);
        this.dstColorBlendFactor(dstColorBlendFactor);
        this.colorBlendOp(colorBlendOp);
        this.srcAlphaBlendFactor(srcAlphaBlendFactor);
        this.dstAlphaBlendFactor(dstAlphaBlendFactor);
        this.alphaBlendOp(alphaBlendOp);
        return this;
    }

    public VkColorBlendEquationEXT set(VkColorBlendEquationEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkColorBlendEquationEXT malloc() {
        return new VkColorBlendEquationEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkColorBlendEquationEXT calloc() {
        return new VkColorBlendEquationEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkColorBlendEquationEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkColorBlendEquationEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkColorBlendEquationEXT create(long address) {
        return new VkColorBlendEquationEXT(address, null);
    }

    @Nullable
    public static VkColorBlendEquationEXT createSafe(long address) {
        return address == 0L ? null : new VkColorBlendEquationEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkColorBlendEquationEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkColorBlendEquationEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkColorBlendEquationEXT malloc(MemoryStack stack) {
        return new VkColorBlendEquationEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkColorBlendEquationEXT calloc(MemoryStack stack) {
        return new VkColorBlendEquationEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsrcColorBlendFactor(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCCOLORBLENDFACTOR);
    }

    public static int ndstColorBlendFactor(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTCOLORBLENDFACTOR);
    }

    public static int ncolorBlendOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORBLENDOP);
    }

    public static int nsrcAlphaBlendFactor(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCALPHABLENDFACTOR);
    }

    public static int ndstAlphaBlendFactor(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTALPHABLENDFACTOR);
    }

    public static int nalphaBlendOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALPHABLENDOP);
    }

    public static void nsrcColorBlendFactor(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCCOLORBLENDFACTOR, value);
    }

    public static void ndstColorBlendFactor(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTCOLORBLENDFACTOR, value);
    }

    public static void ncolorBlendOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORBLENDOP, value);
    }

    public static void nsrcAlphaBlendFactor(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCALPHABLENDFACTOR, value);
    }

    public static void ndstAlphaBlendFactor(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTALPHABLENDFACTOR, value);
    }

    public static void nalphaBlendOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALPHABLENDOP, value);
    }

    static {
        Struct.Layout layout = VkColorBlendEquationEXT.__struct(VkColorBlendEquationEXT.__member(4), VkColorBlendEquationEXT.__member(4), VkColorBlendEquationEXT.__member(4), VkColorBlendEquationEXT.__member(4), VkColorBlendEquationEXT.__member(4), VkColorBlendEquationEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCCOLORBLENDFACTOR = layout.offsetof(0);
        DSTCOLORBLENDFACTOR = layout.offsetof(1);
        COLORBLENDOP = layout.offsetof(2);
        SRCALPHABLENDFACTOR = layout.offsetof(3);
        DSTALPHABLENDFACTOR = layout.offsetof(4);
        ALPHABLENDOP = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkColorBlendEquationEXT, Buffer>
    implements NativeResource {
        private static final VkColorBlendEquationEXT ELEMENT_FACTORY = VkColorBlendEquationEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkColorBlendEquationEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBlendFactor")
        public int srcColorBlendFactor() {
            return VkColorBlendEquationEXT.nsrcColorBlendFactor(this.address());
        }

        @NativeType(value="VkBlendFactor")
        public int dstColorBlendFactor() {
            return VkColorBlendEquationEXT.ndstColorBlendFactor(this.address());
        }

        @NativeType(value="VkBlendOp")
        public int colorBlendOp() {
            return VkColorBlendEquationEXT.ncolorBlendOp(this.address());
        }

        @NativeType(value="VkBlendFactor")
        public int srcAlphaBlendFactor() {
            return VkColorBlendEquationEXT.nsrcAlphaBlendFactor(this.address());
        }

        @NativeType(value="VkBlendFactor")
        public int dstAlphaBlendFactor() {
            return VkColorBlendEquationEXT.ndstAlphaBlendFactor(this.address());
        }

        @NativeType(value="VkBlendOp")
        public int alphaBlendOp() {
            return VkColorBlendEquationEXT.nalphaBlendOp(this.address());
        }

        public Buffer srcColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkColorBlendEquationEXT.nsrcColorBlendFactor(this.address(), value);
            return this;
        }

        public Buffer dstColorBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkColorBlendEquationEXT.ndstColorBlendFactor(this.address(), value);
            return this;
        }

        public Buffer colorBlendOp(@NativeType(value="VkBlendOp") int value) {
            VkColorBlendEquationEXT.ncolorBlendOp(this.address(), value);
            return this;
        }

        public Buffer srcAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkColorBlendEquationEXT.nsrcAlphaBlendFactor(this.address(), value);
            return this;
        }

        public Buffer dstAlphaBlendFactor(@NativeType(value="VkBlendFactor") int value) {
            VkColorBlendEquationEXT.ndstAlphaBlendFactor(this.address(), value);
            return this;
        }

        public Buffer alphaBlendOp(@NativeType(value="VkBlendOp") int value) {
            VkColorBlendEquationEXT.nalphaBlendOp(this.address(), value);
            return this;
        }
    }
}

