/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferCopy2;

public class VkBufferCopy2KHR
extends VkBufferCopy2 {
    protected VkBufferCopy2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferCopy2KHR create(long address, @Nullable ByteBuffer container) {
        return new VkBufferCopy2KHR(address, container);
    }

    public VkBufferCopy2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferCopy2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferCopy2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferCopy2KHR sType$Default() {
        return this.sType(1000337006);
    }

    @Override
    public VkBufferCopy2KHR pNext(@NativeType(value="void const *") long value) {
        VkBufferCopy2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferCopy2KHR srcOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2KHR.nsrcOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBufferCopy2KHR dstOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2KHR.ndstOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBufferCopy2KHR size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2KHR.nsize(this.address(), value);
        return this;
    }

    @Override
    public VkBufferCopy2KHR set(int sType, long pNext, long srcOffset, long dstOffset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcOffset(srcOffset);
        this.dstOffset(dstOffset);
        this.size(size);
        return this;
    }

    public VkBufferCopy2KHR set(VkBufferCopy2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferCopy2KHR malloc() {
        return new VkBufferCopy2KHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBufferCopy2KHR calloc() {
        return new VkBufferCopy2KHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBufferCopy2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBufferCopy2KHR(MemoryUtil.memAddress(container), container);
    }

    public static VkBufferCopy2KHR create(long address) {
        return new VkBufferCopy2KHR(address, null);
    }

    @Nullable
    public static VkBufferCopy2KHR createSafe(long address) {
        return address == 0L ? null : new VkBufferCopy2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBufferCopy2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCopy2KHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferCopy2KHR malloc(MemoryStack stack) {
        return new VkBufferCopy2KHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferCopy2KHR calloc(MemoryStack stack) {
        return new VkBufferCopy2KHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferCopy2.Buffer {
        private static final VkBufferCopy2KHR ELEMENT_FACTORY = VkBufferCopy2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferCopy2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferCopy2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000337006);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferCopy2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2KHR.nsrcOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2KHR.ndstOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2KHR.nsize(this.address(), value);
            return this;
        }
    }
}

