/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;

public class VkBindDescriptorSetsInfoKHR
extends Struct<VkBindDescriptorSetsInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGEFLAGS;
    public static final int LAYOUT;
    public static final int FIRSTSET;
    public static final int DESCRIPTORSETCOUNT;
    public static final int PDESCRIPTORSETS;
    public static final int DYNAMICOFFSETCOUNT;
    public static final int PDYNAMICOFFSETS;

    protected VkBindDescriptorSetsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindDescriptorSetsInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkBindDescriptorSetsInfoKHR(address, container);
    }

    public VkBindDescriptorSetsInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindDescriptorSetsInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindDescriptorSetsInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindDescriptorSetsInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkBindDescriptorSetsInfoKHR.nstageFlags(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkBindDescriptorSetsInfoKHR.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstSet() {
        return VkBindDescriptorSetsInfoKHR.nfirstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorSetCount() {
        return VkBindDescriptorSetsInfoKHR.ndescriptorSetCount(this.address());
    }

    @NativeType(value="VkDescriptorSet const *")
    public LongBuffer pDescriptorSets() {
        return VkBindDescriptorSetsInfoKHR.npDescriptorSets(this.address());
    }

    @NativeType(value="uint32_t")
    public int dynamicOffsetCount() {
        return VkBindDescriptorSetsInfoKHR.ndynamicOffsetCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pDynamicOffsets() {
        return VkBindDescriptorSetsInfoKHR.npDynamicOffsets(this.address());
    }

    public VkBindDescriptorSetsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindDescriptorSetsInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR sType$Default() {
        return this.sType(1000545003);
    }

    public VkBindDescriptorSetsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindDescriptorSetsInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindDescriptorSetsInfoKHR stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkBindDescriptorSetsInfoKHR.nstageFlags(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR layout(@NativeType(value="VkPipelineLayout") long value) {
        VkBindDescriptorSetsInfoKHR.nlayout(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR firstSet(@NativeType(value="uint32_t") int value) {
        VkBindDescriptorSetsInfoKHR.nfirstSet(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR pDescriptorSets(@NativeType(value="VkDescriptorSet const *") LongBuffer value) {
        VkBindDescriptorSetsInfoKHR.npDescriptorSets(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR dynamicOffsetCount(@NativeType(value="uint32_t") int value) {
        VkBindDescriptorSetsInfoKHR.ndynamicOffsetCount(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR pDynamicOffsets(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBindDescriptorSetsInfoKHR.npDynamicOffsets(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR set(int sType, long pNext, int stageFlags, long layout, int firstSet, LongBuffer pDescriptorSets, int dynamicOffsetCount, @Nullable IntBuffer pDynamicOffsets) {
        this.sType(sType);
        this.pNext(pNext);
        this.stageFlags(stageFlags);
        this.layout(layout);
        this.firstSet(firstSet);
        this.pDescriptorSets(pDescriptorSets);
        this.dynamicOffsetCount(dynamicOffsetCount);
        this.pDynamicOffsets(pDynamicOffsets);
        return this;
    }

    public VkBindDescriptorSetsInfoKHR set(VkBindDescriptorSetsInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindDescriptorSetsInfoKHR malloc() {
        return new VkBindDescriptorSetsInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindDescriptorSetsInfoKHR calloc() {
        return new VkBindDescriptorSetsInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindDescriptorSetsInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindDescriptorSetsInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkBindDescriptorSetsInfoKHR create(long address) {
        return new VkBindDescriptorSetsInfoKHR(address, null);
    }

    @Nullable
    public static VkBindDescriptorSetsInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkBindDescriptorSetsInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindDescriptorSetsInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindDescriptorSetsInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindDescriptorSetsInfoKHR malloc(MemoryStack stack) {
        return new VkBindDescriptorSetsInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindDescriptorSetsInfoKHR calloc(MemoryStack stack) {
        return new VkBindDescriptorSetsInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static int nfirstSet(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTSET);
    }

    public static int ndescriptorSetCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORSETCOUNT);
    }

    public static LongBuffer npDescriptorSets(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORSETS), VkBindDescriptorSetsInfoKHR.ndescriptorSetCount(struct));
    }

    public static int ndynamicOffsetCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DYNAMICOFFSETCOUNT);
    }

    @Nullable
    public static IntBuffer npDynamicOffsets(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDYNAMICOFFSETS), VkBindDescriptorSetsInfoKHR.ndynamicOffsetCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nfirstSet(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTSET, value);
    }

    public static void ndescriptorSetCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORSETCOUNT, value);
    }

    public static void npDescriptorSets(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDESCRIPTORSETS, MemoryUtil.memAddress(value));
        VkBindDescriptorSetsInfoKHR.ndescriptorSetCount(struct, value.remaining());
    }

    public static void ndynamicOffsetCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DYNAMICOFFSETCOUNT, value);
    }

    public static void npDynamicOffsets(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICOFFSETS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkBindDescriptorSetsInfoKHR.ndynamicOffsetCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORSETS));
    }

    static {
        Struct.Layout layout = VkBindDescriptorSetsInfoKHR.__struct(VkBindDescriptorSetsInfoKHR.__member(4), VkBindDescriptorSetsInfoKHR.__member(POINTER_SIZE), VkBindDescriptorSetsInfoKHR.__member(4), VkBindDescriptorSetsInfoKHR.__member(8), VkBindDescriptorSetsInfoKHR.__member(4), VkBindDescriptorSetsInfoKHR.__member(4), VkBindDescriptorSetsInfoKHR.__member(POINTER_SIZE), VkBindDescriptorSetsInfoKHR.__member(4), VkBindDescriptorSetsInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGEFLAGS = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        FIRSTSET = layout.offsetof(4);
        DESCRIPTORSETCOUNT = layout.offsetof(5);
        PDESCRIPTORSETS = layout.offsetof(6);
        DYNAMICOFFSETCOUNT = layout.offsetof(7);
        PDYNAMICOFFSETS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBindDescriptorSetsInfoKHR, Buffer>
    implements NativeResource {
        private static final VkBindDescriptorSetsInfoKHR ELEMENT_FACTORY = VkBindDescriptorSetsInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindDescriptorSetsInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindDescriptorSetsInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindDescriptorSetsInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkBindDescriptorSetsInfoKHR.nstageFlags(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkBindDescriptorSetsInfoKHR.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstSet() {
            return VkBindDescriptorSetsInfoKHR.nfirstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorSetCount() {
            return VkBindDescriptorSetsInfoKHR.ndescriptorSetCount(this.address());
        }

        @NativeType(value="VkDescriptorSet const *")
        public LongBuffer pDescriptorSets() {
            return VkBindDescriptorSetsInfoKHR.npDescriptorSets(this.address());
        }

        @NativeType(value="uint32_t")
        public int dynamicOffsetCount() {
            return VkBindDescriptorSetsInfoKHR.ndynamicOffsetCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pDynamicOffsets() {
            return VkBindDescriptorSetsInfoKHR.npDynamicOffsets(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindDescriptorSetsInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindDescriptorSetsInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkBindDescriptorSetsInfoKHR.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkBindDescriptorSetsInfoKHR.nlayout(this.address(), value);
            return this;
        }

        public Buffer firstSet(@NativeType(value="uint32_t") int value) {
            VkBindDescriptorSetsInfoKHR.nfirstSet(this.address(), value);
            return this;
        }

        public Buffer pDescriptorSets(@NativeType(value="VkDescriptorSet const *") LongBuffer value) {
            VkBindDescriptorSetsInfoKHR.npDescriptorSets(this.address(), value);
            return this;
        }

        public Buffer dynamicOffsetCount(@NativeType(value="uint32_t") int value) {
            VkBindDescriptorSetsInfoKHR.ndynamicOffsetCount(this.address(), value);
            return this;
        }

        public Buffer pDynamicOffsets(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBindDescriptorSetsInfoKHR.npDynamicOffsets(this.address(), value);
            return this;
        }
    }
}

