/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;

public class KHRDeferredHostOperations {
    public static final int VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION = 4;
    public static final String VK_KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME = "VK_KHR_deferred_host_operations";
    public static final int VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR = 1000268000;
    public static final int VK_THREAD_IDLE_KHR = 1000268000;
    public static final int VK_THREAD_DONE_KHR = 1000268001;
    public static final int VK_OPERATION_DEFERRED_KHR = 1000268002;
    public static final int VK_OPERATION_NOT_DEFERRED_KHR = 1000268003;

    protected KHRDeferredHostOperations() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateDeferredOperationKHR(VkDevice device, long pAllocator, long pDeferredOperation) {
        long __functionAddress = device.getCapabilities().vkCreateDeferredOperationKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(device.address(), pAllocator, pDeferredOperation, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDeferredOperationKHR(VkDevice device, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkDeferredOperationKHR *") LongBuffer pDeferredOperation) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDeferredOperation, 1);
        }
        return KHRDeferredHostOperations.nvkCreateDeferredOperationKHR(device, MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pDeferredOperation));
    }

    public static void nvkDestroyDeferredOperationKHR(VkDevice device, long operation, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDeferredOperationKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJPV(device.address(), operation, pAllocator, __functionAddress);
    }

    public static void vkDestroyDeferredOperationKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        KHRDeferredHostOperations.nvkDestroyDeferredOperationKHR(device, operation, MemoryUtil.memAddressSafe(pAllocator));
    }

    @NativeType(value="uint32_t")
    public static int vkGetDeferredOperationMaxConcurrencyKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation) {
        long __functionAddress = device.getCapabilities().vkGetDeferredOperationMaxConcurrencyKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJI(device.address(), operation, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDeferredOperationResultKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation) {
        long __functionAddress = device.getCapabilities().vkGetDeferredOperationResultKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJI(device.address(), operation, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkDeferredOperationJoinKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation) {
        long __functionAddress = device.getCapabilities().vkDeferredOperationJoinKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJI(device.address(), operation, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDeferredOperationKHR(VkDevice device, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkDeferredOperationKHR *") long[] pDeferredOperation) {
        long __functionAddress = device.getCapabilities().vkCreateDeferredOperationKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pDeferredOperation, 1);
        }
        return JNI.callPPPI(device.address(), MemoryUtil.memAddressSafe(pAllocator), pDeferredOperation, __functionAddress);
    }
}

