/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkColorBlendAdvancedEXT;
import org.lwjgl.vulkan.VkColorBlendEquationEXT;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkShaderCreateInfoEXT;
import org.lwjgl.vulkan.VkVertexInputAttributeDescription2EXT;
import org.lwjgl.vulkan.VkVertexInputBindingDescription2EXT;
import org.lwjgl.vulkan.VkViewport;
import org.lwjgl.vulkan.VkViewportSwizzleNV;

public class EXTShaderObject {
    public static final int VK_EXT_SHADER_OBJECT_SPEC_VERSION = 1;
    public static final String VK_EXT_SHADER_OBJECT_EXTENSION_NAME = "VK_EXT_shader_object";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT = 1000482000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT = 1000482001;
    public static final int VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT = 1000482002;
    public static final int VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT = 1000352001;
    public static final int VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT = 1000352002;
    public static final int VK_STRUCTURE_TYPE_SHADER_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT = 1000225001;
    public static final int VK_OBJECT_TYPE_SHADER_EXT = 1000482000;
    public static final int VK_INCOMPATIBLE_SHADER_BINARY_EXT = 1000482000;
    public static final int VK_ERROR_INCOMPATIBLE_SHADER_BINARY_EXT = 1000482000;
    public static final int VK_SHADER_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT = 2;
    public static final int VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT = 4;
    public static final int VK_SHADER_CREATE_NO_TASK_SHADER_BIT_EXT = 8;
    public static final int VK_SHADER_CREATE_DISPATCH_BASE_BIT_EXT = 16;
    public static final int VK_SHADER_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_EXT = 32;
    public static final int VK_SHADER_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT = 64;
    public static final int VK_SHADER_CREATE_LINK_STAGE_BIT_EXT = 1;
    public static final int VK_SHADER_CODE_TYPE_BINARY_EXT = 0;
    public static final int VK_SHADER_CODE_TYPE_SPIRV_EXT = 1;

    protected EXTShaderObject() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateShadersEXT(VkDevice device, int createInfoCount, long pCreateInfos, long pAllocator, long pShaders) {
        long __functionAddress = device.getCapabilities().vkCreateShadersEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Struct.validate(pCreateInfos, createInfoCount, VkShaderCreateInfoEXT.SIZEOF, VkShaderCreateInfoEXT::validate);
        }
        return JNI.callPPPPI(device.address(), createInfoCount, pCreateInfos, pAllocator, pShaders, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateShadersEXT(VkDevice device, @NativeType(value="VkShaderCreateInfoEXT const *") VkShaderCreateInfoEXT.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkShaderEXT *") LongBuffer pShaders) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pShaders, pCreateInfos.remaining());
        }
        return EXTShaderObject.nvkCreateShadersEXT(device, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pShaders));
    }

    public static void nvkDestroyShaderEXT(VkDevice device, long shader, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyShaderEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJPV(device.address(), shader, pAllocator, __functionAddress);
    }

    public static void vkDestroyShaderEXT(VkDevice device, @NativeType(value="VkShaderEXT") long shader, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        EXTShaderObject.nvkDestroyShaderEXT(device, shader, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static int nvkGetShaderBinaryDataEXT(VkDevice device, long shader, long pDataSize, long pData) {
        long __functionAddress = device.getCapabilities().vkGetShaderBinaryDataEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(device.address(), shader, pDataSize, pData, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetShaderBinaryDataEXT(VkDevice device, @NativeType(value="VkShaderEXT") long shader, @NativeType(value="size_t *") PointerBuffer pDataSize, @Nullable @NativeType(value="void *") ByteBuffer pData) {
        if (Checks.CHECKS) {
            Checks.check(pDataSize, 1);
            Checks.checkSafe((Buffer)pData, pDataSize.get(pDataSize.position()));
        }
        return EXTShaderObject.nvkGetShaderBinaryDataEXT(device, shader, MemoryUtil.memAddress(pDataSize), MemoryUtil.memAddressSafe(pData));
    }

    public static void nvkCmdBindShadersEXT(VkCommandBuffer commandBuffer, int stageCount, long pStages, long pShaders) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindShadersEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(commandBuffer.address(), stageCount, pStages, pShaders, __functionAddress);
    }

    public static void vkCmdBindShadersEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkShaderStageFlagBits const *") IntBuffer pStages, @NativeType(value="VkShaderEXT const *") LongBuffer pShaders) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pShaders, pStages.remaining());
        }
        EXTShaderObject.nvkCmdBindShadersEXT(commandBuffer, pStages.remaining(), MemoryUtil.memAddress(pStages), MemoryUtil.memAddress(pShaders));
    }

    public static void vkCmdSetCullModeEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkCullModeFlags") int cullMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCullModeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), cullMode, __functionAddress);
    }

    public static void vkCmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkFrontFace") int frontFace) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetFrontFaceEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), frontFace, __functionAddress);
    }

    public static void vkCmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkPrimitiveTopology") int primitiveTopology) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPrimitiveTopologyEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), primitiveTopology, __functionAddress);
    }

    public static void nvkCmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, int viewportCount, long pViewports) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetViewportWithCountEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), viewportCount, pViewports, __functionAddress);
    }

    public static void vkCmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkViewport const *") VkViewport.Buffer pViewports) {
        EXTShaderObject.nvkCmdSetViewportWithCountEXT(commandBuffer, pViewports.remaining(), pViewports.address());
    }

    public static void nvkCmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, int scissorCount, long pScissors) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetScissorWithCountEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), scissorCount, pScissors, __functionAddress);
    }

    public static void vkCmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkRect2D const *") VkRect2D.Buffer pScissors) {
        EXTShaderObject.nvkCmdSetScissorWithCountEXT(commandBuffer, pScissors.remaining(), pScissors.address());
    }

    public static void nvkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, int firstBinding, int bindingCount, long pBuffers, long pOffsets, long pSizes, long pStrides) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindVertexBuffers2EXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPPPV(commandBuffer.address(), firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides, __functionAddress);
    }

    public static void vkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstBinding, @NativeType(value="VkBuffer const *") LongBuffer pBuffers, @NativeType(value="VkDeviceSize const *") LongBuffer pOffsets, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer pSizes, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer pStrides) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOffsets, pBuffers.remaining());
            Checks.checkSafe((Buffer)pSizes, pBuffers.remaining());
            Checks.checkSafe((Buffer)pStrides, pBuffers.remaining());
        }
        EXTShaderObject.nvkCmdBindVertexBuffers2EXT(commandBuffer, firstBinding, pBuffers.remaining(), MemoryUtil.memAddress(pBuffers), MemoryUtil.memAddress(pOffsets), MemoryUtil.memAddressSafe(pSizes), MemoryUtil.memAddressSafe(pStrides));
    }

    public static void vkCmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthTestEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthTestEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthWriteEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthWriteEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthWriteEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkCompareOp") int depthCompareOp) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthCompareOpEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthCompareOp, __functionAddress);
    }

    public static void vkCmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthBoundsTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthBoundsTestEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthBoundsTestEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean stencilTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetStencilTestEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), stencilTestEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetStencilOpEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkStencilFaceFlags") int faceMask, @NativeType(value="VkStencilOp") int failOp, @NativeType(value="VkStencilOp") int passOp, @NativeType(value="VkStencilOp") int depthFailOp, @NativeType(value="VkCompareOp") int compareOp) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetStencilOpEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), faceMask, failOp, passOp, depthFailOp, compareOp, __functionAddress);
    }

    public static void nvkCmdSetVertexInputEXT(VkCommandBuffer commandBuffer, int vertexBindingDescriptionCount, long pVertexBindingDescriptions, int vertexAttributeDescriptionCount, long pVertexAttributeDescriptions) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetVertexInputEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(commandBuffer.address(), vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions, __functionAddress);
    }

    public static void vkCmdSetVertexInputEXT(VkCommandBuffer commandBuffer, @Nullable @NativeType(value="VkVertexInputBindingDescription2EXT const *") VkVertexInputBindingDescription2EXT.Buffer pVertexBindingDescriptions, @Nullable @NativeType(value="VkVertexInputAttributeDescription2EXT const *") VkVertexInputAttributeDescription2EXT.Buffer pVertexAttributeDescriptions) {
        EXTShaderObject.nvkCmdSetVertexInputEXT(commandBuffer, Checks.remainingSafe(pVertexBindingDescriptions), MemoryUtil.memAddressSafe(pVertexBindingDescriptions), Checks.remainingSafe(pVertexAttributeDescriptions), MemoryUtil.memAddressSafe(pVertexAttributeDescriptions));
    }

    public static void vkCmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int patchControlPoints) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPatchControlPointsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), patchControlPoints, __functionAddress);
    }

    public static void vkCmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean rasterizerDiscardEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetRasterizerDiscardEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), rasterizerDiscardEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthBiasEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthBiasEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthBiasEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetLogicOpEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkLogicOp") int logicOp) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetLogicOpEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), logicOp, __functionAddress);
    }

    public static void vkCmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean primitiveRestartEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPrimitiveRestartEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), primitiveRestartEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkTessellationDomainOrigin") int domainOrigin) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetTessellationDomainOriginEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), domainOrigin, __functionAddress);
    }

    public static void vkCmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthClampEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthClampEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthClampEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkPolygonMode") int polygonMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPolygonModeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), polygonMode, __functionAddress);
    }

    public static void vkCmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkSampleCountFlagBits") int rasterizationSamples) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetRasterizationSamplesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), rasterizationSamples, __functionAddress);
    }

    public static void nvkCmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, int samples, long pSampleMask) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetSampleMaskEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), samples, pSampleMask, __functionAddress);
    }

    public static void vkCmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkSampleCountFlagBits") int samples, @NativeType(value="VkSampleMask const *") IntBuffer pSampleMask) {
        EXTShaderObject.nvkCmdSetSampleMaskEXT(commandBuffer, samples, MemoryUtil.memAddress(pSampleMask));
    }

    public static void vkCmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean alphaToCoverageEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetAlphaToCoverageEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), alphaToCoverageEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean alphaToOneEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetAlphaToOneEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), alphaToOneEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean logicOpEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetLogicOpEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), logicOpEnable ? 1 : 0, __functionAddress);
    }

    public static void nvkCmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, int firstAttachment, int attachmentCount, long pColorBlendEnables) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetColorBlendEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstAttachment, attachmentCount, pColorBlendEnables, __functionAddress);
    }

    public static void vkCmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstAttachment, @NativeType(value="VkBool32 const *") IntBuffer pColorBlendEnables) {
        EXTShaderObject.nvkCmdSetColorBlendEnableEXT(commandBuffer, firstAttachment, pColorBlendEnables.remaining(), MemoryUtil.memAddress(pColorBlendEnables));
    }

    public static void nvkCmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, int firstAttachment, int attachmentCount, long pColorBlendEquations) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetColorBlendEquationEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstAttachment, attachmentCount, pColorBlendEquations, __functionAddress);
    }

    public static void vkCmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstAttachment, @NativeType(value="VkColorBlendEquationEXT const *") VkColorBlendEquationEXT.Buffer pColorBlendEquations) {
        EXTShaderObject.nvkCmdSetColorBlendEquationEXT(commandBuffer, firstAttachment, pColorBlendEquations.remaining(), pColorBlendEquations.address());
    }

    public static void nvkCmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, int firstAttachment, int attachmentCount, long pColorWriteMasks) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetColorWriteMaskEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstAttachment, attachmentCount, pColorWriteMasks, __functionAddress);
    }

    public static void vkCmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstAttachment, @NativeType(value="VkColorComponentFlags const *") IntBuffer pColorWriteMasks) {
        EXTShaderObject.nvkCmdSetColorWriteMaskEXT(commandBuffer, firstAttachment, pColorWriteMasks.remaining(), MemoryUtil.memAddress(pColorWriteMasks));
    }

    public static void vkCmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int rasterizationStream) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetRasterizationStreamEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), rasterizationStream, __functionAddress);
    }

    public static void vkCmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkConservativeRasterizationModeEXT") int conservativeRasterizationMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetConservativeRasterizationModeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), conservativeRasterizationMode, __functionAddress);
    }

    public static void vkCmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetExtraPrimitiveOverestimationSizeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), extraPrimitiveOverestimationSize, __functionAddress);
    }

    public static void vkCmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthClipEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthClipEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), depthClipEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean sampleLocationsEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetSampleLocationsEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), sampleLocationsEnable ? 1 : 0, __functionAddress);
    }

    public static void nvkCmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, int firstAttachment, int attachmentCount, long pColorBlendAdvanced) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetColorBlendAdvancedEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstAttachment, attachmentCount, pColorBlendAdvanced, __functionAddress);
    }

    public static void vkCmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstAttachment, @NativeType(value="VkColorBlendAdvancedEXT const *") VkColorBlendAdvancedEXT.Buffer pColorBlendAdvanced) {
        EXTShaderObject.nvkCmdSetColorBlendAdvancedEXT(commandBuffer, firstAttachment, pColorBlendAdvanced.remaining(), pColorBlendAdvanced.address());
    }

    public static void vkCmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkProvokingVertexModeEXT") int provokingVertexMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetProvokingVertexModeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), provokingVertexMode, __functionAddress);
    }

    public static void vkCmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkLineRasterizationModeEXT") int lineRasterizationMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetLineRasterizationModeEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), lineRasterizationMode, __functionAddress);
    }

    public static void vkCmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean stippledLineEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetLineStippleEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), stippledLineEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean negativeOneToOne) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthClipNegativeOneToOneEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), negativeOneToOne ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetViewportWScalingEnableNV(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean viewportWScalingEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetViewportWScalingEnableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), viewportWScalingEnable ? 1 : 0, __functionAddress);
    }

    public static void nvkCmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, int firstViewport, int viewportCount, long pViewportSwizzles) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetViewportSwizzleNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstViewport, viewportCount, pViewportSwizzles, __functionAddress);
    }

    public static void vkCmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstViewport, @NativeType(value="VkViewportSwizzleNV const *") VkViewportSwizzleNV.Buffer pViewportSwizzles) {
        EXTShaderObject.nvkCmdSetViewportSwizzleNV(commandBuffer, firstViewport, pViewportSwizzles.remaining(), pViewportSwizzles.address());
    }

    public static void vkCmdSetCoverageToColorEnableNV(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean coverageToColorEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageToColorEnableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), coverageToColorEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetCoverageToColorLocationNV(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int coverageToColorLocation) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageToColorLocationNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), coverageToColorLocation, __functionAddress);
    }

    public static void vkCmdSetCoverageModulationModeNV(VkCommandBuffer commandBuffer, @NativeType(value="VkCoverageModulationModeNV") int coverageModulationMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageModulationModeNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), coverageModulationMode, __functionAddress);
    }

    public static void vkCmdSetCoverageModulationTableEnableNV(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean coverageModulationTableEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageModulationTableEnableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), coverageModulationTableEnable ? 1 : 0, __functionAddress);
    }

    public static void nvkCmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, int coverageModulationTableCount, long pCoverageModulationTable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageModulationTableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), coverageModulationTableCount, pCoverageModulationTable, __functionAddress);
    }

    public static void vkCmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, @NativeType(value="float const *") FloatBuffer pCoverageModulationTable) {
        EXTShaderObject.nvkCmdSetCoverageModulationTableNV(commandBuffer, pCoverageModulationTable.remaining(), MemoryUtil.memAddress(pCoverageModulationTable));
    }

    public static void vkCmdSetShadingRateImageEnableNV(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean shadingRateImageEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetShadingRateImageEnableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), shadingRateImageEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetRepresentativeFragmentTestEnableNV(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean representativeFragmentTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetRepresentativeFragmentTestEnableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), representativeFragmentTestEnable ? 1 : 0, __functionAddress);
    }

    public static void vkCmdSetCoverageReductionModeNV(VkCommandBuffer commandBuffer, @NativeType(value="VkCoverageReductionModeNV") int coverageReductionMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageReductionModeNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), coverageReductionMode, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateShadersEXT(VkDevice device, @NativeType(value="VkShaderCreateInfoEXT const *") VkShaderCreateInfoEXT.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkShaderEXT *") long[] pShaders) {
        long __functionAddress = device.getCapabilities().vkCreateShadersEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pShaders, pCreateInfos.remaining());
            Struct.validate(pCreateInfos.address(), pCreateInfos.remaining(), VkShaderCreateInfoEXT.SIZEOF, VkShaderCreateInfoEXT::validate);
        }
        return JNI.callPPPPI(device.address(), pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe(pAllocator), pShaders, __functionAddress);
    }

    public static void vkCmdBindShadersEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkShaderStageFlagBits const *") int[] pStages, @NativeType(value="VkShaderEXT const *") long[] pShaders) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindShadersEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pShaders, pStages.length);
        }
        JNI.callPPPV(commandBuffer.address(), pStages.length, pStages, pShaders, __functionAddress);
    }

    public static void vkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstBinding, @NativeType(value="VkBuffer const *") long[] pBuffers, @NativeType(value="VkDeviceSize const *") long[] pOffsets, @Nullable @NativeType(value="VkDeviceSize const *") long[] pSizes, @Nullable @NativeType(value="VkDeviceSize const *") long[] pStrides) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindVertexBuffers2EXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pOffsets, pBuffers.length);
            Checks.checkSafe(pSizes, pBuffers.length);
            Checks.checkSafe(pStrides, pBuffers.length);
        }
        JNI.callPPPPPV(commandBuffer.address(), firstBinding, pBuffers.length, pBuffers, pOffsets, pSizes, pStrides, __functionAddress);
    }

    public static void vkCmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkSampleCountFlagBits") int samples, @NativeType(value="VkSampleMask const *") int[] pSampleMask) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetSampleMaskEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), samples, pSampleMask, __functionAddress);
    }

    public static void vkCmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstAttachment, @NativeType(value="VkBool32 const *") int[] pColorBlendEnables) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetColorBlendEnableEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstAttachment, pColorBlendEnables.length, pColorBlendEnables, __functionAddress);
    }

    public static void vkCmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstAttachment, @NativeType(value="VkColorComponentFlags const *") int[] pColorWriteMasks) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetColorWriteMaskEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), firstAttachment, pColorWriteMasks.length, pColorWriteMasks, __functionAddress);
    }

    public static void vkCmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, @NativeType(value="float const *") float[] pCoverageModulationTable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCoverageModulationTableNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(commandBuffer.address(), pCoverageModulationTable.length, pCoverageModulationTable, __functionAddress);
    }
}

