/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGL;
import org.lwjgl.opengl.awt.GLData;
import org.lwjgl.opengl.awt.GLUtil;
import org.lwjgl.opengl.awt.PlatformGLCanvas;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.jawt.JAWT;
import org.lwjgl.system.jawt.JAWTDrawingSurface;
import org.lwjgl.system.jawt.JAWTFunctions;
import org.lwjgl.system.windows.GDI32;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.User32;
import org.lwjgl.system.windows.WNDCLASSEX;
import org.lwjgl.system.windows.WindowsLibrary;

public class PlatformWin32GLCanvas
implements PlatformGLCanvas {
    public static final JAWT awt = JAWT.create(MemoryUtil.getAllocator().calloc(1L, JAWT.SIZEOF));
    public long hwnd;
    public long wglDelayBeforeSwapNVAddr = 0L;
    public boolean wglDelayBeforeSwapNVAddr_set = false;
    public JAWTDrawingSurface ds;

    private static void encodePixelFormatAttribs(IntBuffer ib, GLData attribs) {
        ib.put(8193).put(1);
        ib.put(8208).put(1);
        ib.put(8195).put(8231);
        if (attribs.doubleBuffer) {
            ib.put(8209).put(1);
        }
        if (attribs.pixelFormatFloat) {
            ib.put(8211).put(8608);
        } else {
            ib.put(8211).put(8235);
        }
        if (attribs.redSize > 0) {
            ib.put(8213).put(attribs.redSize);
        }
        if (attribs.greenSize > 0) {
            ib.put(8215).put(attribs.greenSize);
        }
        if (attribs.blueSize > 0) {
            ib.put(8217).put(attribs.blueSize);
        }
        if (attribs.alphaSize > 0) {
            ib.put(8219).put(attribs.alphaSize);
        }
        if (attribs.depthSize > 0) {
            ib.put(8226).put(attribs.depthSize);
        }
        if (attribs.stencilSize > 0) {
            ib.put(8227).put(attribs.stencilSize);
        }
        if (attribs.accumRedSize > 0) {
            ib.put(8222).put(attribs.accumRedSize);
        }
        if (attribs.accumGreenSize > 0) {
            ib.put(8223).put(attribs.accumGreenSize);
        }
        if (attribs.accumBlueSize > 0) {
            ib.put(8224).put(attribs.accumBlueSize);
        }
        if (attribs.accumAlphaSize > 0) {
            ib.put(8225).put(attribs.accumAlphaSize);
        }
        if (attribs.accumRedSize > 0 || attribs.accumGreenSize > 0 || attribs.accumBlueSize > 0 || attribs.accumAlphaSize > 0) {
            ib.put(8221).put(attribs.accumRedSize + attribs.accumGreenSize + attribs.accumBlueSize + attribs.accumAlphaSize);
        }
        if (attribs.sRGB) {
            ib.put(8361).put(1);
        }
        if (attribs.samples > 0) {
            ib.put(8257).put(1);
            ib.put(8258).put(attribs.samples);
            if (attribs.colorSamplesNV > 0) {
                ib.put(8377).put(attribs.colorSamplesNV);
            }
        }
        ib.put(0);
    }

    private static long createDummyWindow(MemoryStack stack) {
        String className = "AWTAPPWNDCLASS";
        WNDCLASSEX in = WNDCLASSEX.calloc(stack).cbSize(WNDCLASSEX.SIZEOF).lpfnWndProc(User32::DefWindowProc).hInstance(WindowsLibrary.HINSTANCE).lpszClassName(stack.UTF16(className));
        User32.RegisterClassEx(in);
        return User32.CreateWindowEx(262144, className, "", 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 800, 600, 0L, 0L, WindowsLibrary.HINSTANCE, 0L);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long create(Canvas canvas, GLData attribs, GLData effective) throws AWTException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long create(MemoryStack stack, long windowHandle, long dummyWindowHandle, GLData attribs, GLData effective) throws AWTException {
        long str;
        long wglGetExtensionsStringEXTAddr;
        long str2;
        long bufferAddr = stack.nmalloc(4, 32);
        GLUtil.validateAttributes(attribs);
        int flags = 36;
        if (attribs.doubleBuffer) {
            flags |= 1;
        }
        if (attribs.stereo) {
            flags |= 2;
        }
        PIXELFORMATDESCRIPTOR pfd = PIXELFORMATDESCRIPTOR.callocStack(stack).nSize((short)PIXELFORMATDESCRIPTOR.SIZEOF).nVersion((short)1).dwLayerMask(0).iPixelType((byte)0).dwFlags(flags).cRedBits((byte)attribs.redSize).cGreenBits((byte)attribs.greenSize).cBlueBits((byte)attribs.blueSize).cAlphaBits((byte)attribs.alphaSize).cDepthBits((byte)attribs.depthSize).cStencilBits((byte)attribs.stencilSize).cAccumRedBits((byte)attribs.accumRedSize).cAccumGreenBits((byte)attribs.accumGreenSize).cAccumBlueBits((byte)attribs.accumBlueSize).cAccumAlphaBits((byte)attribs.accumAlphaSize).cAccumBits((byte)(attribs.accumRedSize + attribs.accumGreenSize + attribs.accumBlueSize + attribs.accumAlphaSize));
        long hDCdummy = User32.GetDC(dummyWindowHandle);
        int pixelFormat = GDI32.ChoosePixelFormat(hDCdummy, pfd);
        if (pixelFormat == 0 || !GDI32.SetPixelFormat(hDCdummy, pixelFormat, pfd)) {
            User32.ReleaseDC(dummyWindowHandle, hDCdummy);
            throw new AWTException("Unsupported pixel format");
        }
        long dummyContext = WGL.wglCreateContext(hDCdummy);
        if (dummyContext == 0L) {
            User32.ReleaseDC(dummyWindowHandle, hDCdummy);
            throw new AWTException("Failed to create OpenGL context");
        }
        long currentContext = WGL.wglGetCurrentContext();
        long currentDc = WGL.wglGetCurrentDC();
        boolean success = WGL.wglMakeCurrent(hDCdummy, dummyContext);
        if (!success) {
            User32.ReleaseDC(dummyWindowHandle, hDCdummy);
            WGL.wglDeleteContext(dummyContext);
            throw new AWTException("Failed to make OpenGL context current");
        }
        String wglExtensions = null;
        long wglGetExtensionsStringARBAddr = WGL.wglGetProcAddress("wglGetExtensionsStringARB");
        wglExtensions = wglGetExtensionsStringARBAddr != 0L ? ((str2 = JNI.callPP(hDCdummy, wglGetExtensionsStringARBAddr)) != 0L ? MemoryUtil.memASCII(str2) : "") : ((wglGetExtensionsStringEXTAddr = WGL.wglGetProcAddress("wglGetExtensionsStringEXT")) != 0L ? ((str = JNI.callP(wglGetExtensionsStringEXTAddr)) != 0L ? MemoryUtil.memASCII(str) : "") : "");
        String[] splitted = wglExtensions.split(" ");
        HashSet wglExtensionsList = new HashSet(splitted.length);
        Collections.addAll(wglExtensionsList, splitted);
        success = User32.ReleaseDC(dummyWindowHandle, hDCdummy);
        if (!success) {
            WGL.wglDeleteContext(dummyContext);
            WGL.wglMakeCurrent(currentDc, currentContext);
            throw new AWTException("Could not release dummy DC");
        }
        if (!(GLUtil.atLeast30(attribs.majorVersion, attribs.minorVersion) || attribs.samples != 0 || attribs.sRGB || attribs.pixelFormatFloat || attribs.contextReleaseBehavior != null || attribs.robustness || attribs.api == GLData.API.GLES)) {
            long hDC = User32.GetDC(windowHandle);
            GDI32.SetPixelFormat(hDC, pixelFormat, pfd);
            success = WGL.wglDeleteContext(dummyContext);
            if (!success) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("Could not delete dummy GL context");
            }
            long context = WGL.wglCreateContext(hDC);
            if (attribs.swapInterval != null) {
                boolean has_WGL_EXT_swap_control_tear;
                boolean has_WGL_EXT_swap_control = wglExtensionsList.contains("WGL_EXT_swap_control");
                if (!has_WGL_EXT_swap_control) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    WGL.wglDeleteContext(context);
                    throw new AWTException("Swap interval requested but WGL_EXT_swap_control is unavailable");
                }
                if (attribs.swapInterval < 0 && !(has_WGL_EXT_swap_control_tear = wglExtensionsList.contains("WGL_EXT_swap_control_tear"))) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    WGL.wglDeleteContext(context);
                    throw new AWTException("Negative swap interval requested but WGL_EXT_swap_control_tear is unavailable");
                }
                success = WGL.wglMakeCurrent(hDC, context);
                if (!success) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    WGL.wglDeleteContext(context);
                    throw new AWTException("Could not make GL context current");
                }
                long wglSwapIntervalEXTAddr = WGL.wglGetProcAddress("wglSwapIntervalEXT");
                if (wglSwapIntervalEXTAddr != 0L) {
                    JNI.callI(attribs.swapInterval, wglSwapIntervalEXTAddr);
                }
            }
            if (attribs.swapGroupNV > 0 || attribs.swapBarrierNV > 0) {
                boolean has_WGL_NV_swap_group = wglExtensionsList.contains("WGL_NV_swap_group");
                if (!has_WGL_NV_swap_group) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    WGL.wglDeleteContext(context);
                    throw new AWTException("Swap group or barrier requested but WGL_NV_swap_group is unavailable");
                }
                success = WGL.wglMakeCurrent(hDC, context);
                try {
                    PlatformWin32GLCanvas.wglNvSwapGroupAndBarrier(attribs, bufferAddr, hDC);
                }
                catch (AWTException e) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    WGL.wglDeleteContext(context);
                    throw e;
                }
            }
            if (attribs.shareContext != null && !(success = WGL.wglShareLists(attribs.shareContext.context, context))) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(context);
                throw new AWTException("Failed while configuring context sharing");
            }
            int pixFmtIndex = GDI32.DescribePixelFormat(hDC, pixelFormat, pfd);
            if (pixFmtIndex == 0) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(context);
                throw new AWTException("Failed to describe pixel format");
            }
            success = User32.ReleaseDC(windowHandle, hDC);
            if (!success) {
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(context);
                throw new AWTException("Could not release DC");
            }
            effective.redSize = pfd.cRedBits();
            effective.greenSize = pfd.cGreenBits();
            effective.blueSize = pfd.cBlueBits();
            effective.alphaSize = pfd.cAlphaBits();
            effective.depthSize = pfd.cDepthBits();
            effective.stencilSize = pfd.cStencilBits();
            int pixelFormatFlags = pfd.dwFlags();
            effective.doubleBuffer = (pixelFormatFlags & 1) != 0;
            effective.stereo = (pixelFormatFlags & 2) != 0;
            effective.accumRedSize = pfd.cAccumRedBits();
            effective.accumGreenSize = pfd.cAccumGreenBits();
            effective.accumBlueSize = pfd.cAccumBlueBits();
            effective.accumAlphaSize = pfd.cAccumAlphaBits();
            WGL.wglMakeCurrent(currentDc, currentContext);
            return context;
        }
        if (!wglExtensionsList.contains("WGL_ARB_create_context")) {
            WGL.wglDeleteContext(dummyContext);
            WGL.wglMakeCurrent(currentDc, currentContext);
            throw new AWTException("Extended context attributes requested but WGL_ARB_create_context is unavailable");
        }
        long wglCreateContextAttribsARBAddr = WGL.wglGetProcAddress("wglCreateContextAttribsARB");
        if (wglCreateContextAttribsARBAddr == 0L) {
            WGL.wglDeleteContext(dummyContext);
            WGL.wglMakeCurrent(currentDc, currentContext);
            throw new AWTException("WGL_ARB_create_context available but wglCreateContextAttribsARB is NULL");
        }
        IntBuffer attribList = BufferUtils.createIntBuffer(64);
        long attribListAddr = MemoryUtil.memAddress(attribList);
        long hDC = User32.GetDC(windowHandle);
        if (attribs.samples > 0 || attribs.sRGB || attribs.pixelFormatFloat) {
            boolean has_WGL_ARB_pixel_format_float;
            boolean has_WGL_EXT_framebuffer_sRGB;
            long wglChoosePixelFormatAddr = WGL.wglGetProcAddress("wglChoosePixelFormatARB");
            if (wglChoosePixelFormatAddr == 0L && (wglChoosePixelFormatAddr = WGL.wglGetProcAddress("wglChoosePixelFormatEXT")) == 0L) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("No support for wglChoosePixelFormatARB/EXT. Cannot query supported pixel formats.");
            }
            if (attribs.samples > 0) {
                boolean has_WGL_NV_multisample_coverage;
                boolean has_WGL_ARB_multisample = wglExtensionsList.contains("WGL_ARB_multisample");
                boolean has_WGL_EXT_multisample = wglExtensionsList.contains("WGL_EXT_multisample");
                if (!has_WGL_ARB_multisample && !has_WGL_EXT_multisample) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglDeleteContext(dummyContext);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    throw new AWTException("Multisampling requested but neither WGL_ARB_multisample nor WGL_EXT_multisample available");
                }
                if (attribs.colorSamplesNV > 0 && !(has_WGL_NV_multisample_coverage = wglExtensionsList.contains("WGL_NV_multisample_coverage"))) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglDeleteContext(dummyContext);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    throw new AWTException("Color samples requested but WGL_NV_multisample_coverage is unavailable");
                }
            }
            if (attribs.sRGB && !(has_WGL_EXT_framebuffer_sRGB = wglExtensionsList.contains("WGL_EXT_framebuffer_sRGB"))) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("sRGB color space requested but WGL_EXT_framebuffer_sRGB is unavailable");
            }
            if (attribs.pixelFormatFloat && !(has_WGL_ARB_pixel_format_float = wglExtensionsList.contains("WGL_ARB_pixel_format_float"))) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("Floating-point format requested but WGL_ARB_pixel_format_float is unavailable");
            }
            PlatformWin32GLCanvas.encodePixelFormatAttribs(attribList, attribs);
            success = JNI.callPPPPPI(hDC, attribListAddr, 0L, 1, bufferAddr + 4L, bufferAddr, wglChoosePixelFormatAddr) == 1;
            int numFormats = MemoryUtil.memGetInt(bufferAddr);
            if (!success || numFormats == 0) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("No supported pixel format found.");
            }
            pixelFormat = MemoryUtil.memGetInt(bufferAddr + 4L);
            int pixFmtIndex = GDI32.DescribePixelFormat(hDC, pixelFormat, pfd);
            if (pixFmtIndex == 0) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("Failed to validate supported pixel format.");
            }
            long wglGetPixelFormatAttribivAddr = WGL.wglGetProcAddress("wglGetPixelFormatAttribivARB");
            if (wglGetPixelFormatAttribivAddr == 0L && (wglGetPixelFormatAttribivAddr = WGL.wglGetProcAddress("wglGetPixelFormatAttribivEXT")) == 0L) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("No support for wglGetPixelFormatAttribivARB/EXT. Cannot get effective pixel format attributes.");
            }
            attribList.rewind();
            attribList.put(8209).put(8210).put(8211).put(8213).put(8215).put(8217).put(8219).put(8222).put(8223).put(8224).put(8225).put(8226).put(8227);
            IntBuffer attribValues = BufferUtils.createIntBuffer(attribList.position());
            long attribValuesAddr = MemoryUtil.memAddress(attribValues);
            boolean bl = success = JNI.callPPPI(hDC, pixelFormat, 0, attribList.position(), attribListAddr, attribValuesAddr, wglGetPixelFormatAttribivAddr) == 1;
            if (!success) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("Failed to get pixel format attributes.");
            }
            effective.doubleBuffer = attribValues.get(0) == 1;
            effective.stereo = attribValues.get(1) == 1;
            int pixelType = attribValues.get(2);
            effective.pixelFormatFloat = pixelType == 8608;
            effective.redSize = attribValues.get(3);
            effective.greenSize = attribValues.get(4);
            effective.blueSize = attribValues.get(5);
            effective.alphaSize = attribValues.get(6);
            effective.accumRedSize = attribValues.get(7);
            effective.accumGreenSize = attribValues.get(8);
            effective.accumBlueSize = attribValues.get(9);
            effective.accumAlphaSize = attribValues.get(10);
            effective.depthSize = attribValues.get(11);
            effective.stencilSize = attribValues.get(12);
        }
        attribList.rewind();
        if (attribs.api == GLData.API.GL && GLUtil.atLeast30(attribs.majorVersion, attribs.minorVersion) || attribs.api == GLData.API.GLES && attribs.majorVersion > 0) {
            attribList.put(8337).put(attribs.majorVersion);
            attribList.put(8338).put(attribs.minorVersion);
        }
        int profile = 0;
        if (attribs.api == GLData.API.GL) {
            if (attribs.profile == GLData.Profile.COMPATIBILITY) {
                profile = 2;
            } else if (attribs.profile == GLData.Profile.CORE) {
                profile = 1;
            }
        } else if (attribs.api == GLData.API.GLES) {
            boolean has_WGL_EXT_create_context_es2_profile = wglExtensionsList.contains("WGL_EXT_create_context_es2_profile");
            if (!has_WGL_EXT_create_context_es2_profile) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("OpenGL ES API requested but WGL_EXT_create_context_es2_profile is unavailable");
            }
            profile = 4;
        }
        if (profile > 0) {
            boolean has_WGL_ARB_create_context_profile = wglExtensionsList.contains("WGL_ARB_create_context_profile");
            if (!has_WGL_ARB_create_context_profile) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("OpenGL profile requested but WGL_ARB_create_context_profile is unavailable");
            }
            attribList.put(37158).put(profile);
        }
        int contextFlags = 0;
        if (attribs.debug) {
            contextFlags |= 1;
        }
        if (attribs.forwardCompatible) {
            contextFlags |= 2;
        }
        if (attribs.robustness) {
            boolean has_WGL_ARB_create_context_robustness = wglExtensions.contains("WGL_ARB_create_context_robustness");
            if (!has_WGL_ARB_create_context_robustness) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("Context with robust buffer access requested but WGL_ARB_create_context_robustness is unavailable");
            }
            contextFlags |= 4;
            if (attribs.loseContextOnReset) {
                attribList.put(33366).put(33362);
            }
            if (attribs.contextResetIsolation) {
                boolean has_WGL_ARB_robustness_application_isolation = wglExtensions.contains("WGL_ARB_robustness_application_isolation");
                boolean has_WGL_ARB_robustness_share_group_isolation = wglExtensions.contains("WGL_ARB_robustness_share_group_isolation");
                if (!has_WGL_ARB_robustness_application_isolation && !has_WGL_ARB_robustness_share_group_isolation) {
                    User32.ReleaseDC(windowHandle, hDC);
                    WGL.wglDeleteContext(dummyContext);
                    WGL.wglMakeCurrent(currentDc, currentContext);
                    throw new AWTException("Robustness isolation requested but neither WGL_ARB_robustness_application_isolation nor WGL_ARB_robustness_share_group_isolation available");
                }
                contextFlags |= 8;
            }
        }
        if (contextFlags > 0) {
            attribList.put(8340).put(contextFlags);
        }
        if (attribs.contextReleaseBehavior != null) {
            boolean has_WGL_ARB_context_flush_control = wglExtensionsList.contains("WGL_ARB_context_flush_control");
            if (!has_WGL_ARB_context_flush_control) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglDeleteContext(dummyContext);
                WGL.wglMakeCurrent(currentDc, currentContext);
                throw new AWTException("Context release behavior requested but WGL_ARB_context_flush_control is unavailable");
            }
            if (attribs.contextReleaseBehavior == GLData.ReleaseBehavior.NONE) {
                attribList.put(8343).put(0);
            } else if (attribs.contextReleaseBehavior == GLData.ReleaseBehavior.FLUSH) {
                attribList.put(8343).put(8344);
            }
        }
        attribList.put(0).put(0);
        success = GDI32.SetPixelFormat(hDC, pixelFormat, pfd);
        if (!success) {
            User32.ReleaseDC(windowHandle, hDC);
            WGL.wglDeleteContext(dummyContext);
            WGL.wglMakeCurrent(currentDc, currentContext);
            throw new AWTException("Failed to set pixel format.");
        }
        long newCtx = JNI.callPPPP(hDC, attribs.shareContext != null ? attribs.shareContext.context : 0L, attribListAddr, wglCreateContextAttribsARBAddr);
        WGL.wglDeleteContext(dummyContext);
        if (newCtx == 0L) {
            User32.ReleaseDC(windowHandle, hDC);
            WGL.wglMakeCurrent(currentDc, currentContext);
            throw new AWTException("Failed to create OpenGL context.");
        }
        WGL.wglMakeCurrent(hDC, newCtx);
        if (attribs.swapInterval != null) {
            boolean has_WGL_EXT_swap_control_tear;
            boolean has_WGL_EXT_swap_control = wglExtensionsList.contains("WGL_EXT_swap_control");
            if (!has_WGL_EXT_swap_control) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(newCtx);
                throw new AWTException("Swap interval requested but WGL_EXT_swap_control is unavailable");
            }
            if (attribs.swapInterval < 0 && !(has_WGL_EXT_swap_control_tear = wglExtensionsList.contains("WGL_EXT_swap_control_tear"))) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(newCtx);
                throw new AWTException("Negative swap interval requested but WGL_EXT_swap_control_tear is unavailable");
            }
            long wglSwapIntervalEXTAddr = WGL.wglGetProcAddress("wglSwapIntervalEXT");
            if (wglSwapIntervalEXTAddr != 0L) {
                JNI.callI(attribs.swapInterval, wglSwapIntervalEXTAddr);
            }
        }
        if (attribs.swapGroupNV > 0 || attribs.swapBarrierNV > 0) {
            boolean has_WGL_NV_swap_group = wglExtensionsList.contains("WGL_NV_swap_group");
            if (!has_WGL_NV_swap_group) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(newCtx);
                throw new AWTException("Swap group or barrier requested but WGL_NV_swap_group is unavailable");
            }
            try {
                PlatformWin32GLCanvas.wglNvSwapGroupAndBarrier(attribs, bufferAddr, hDC);
            }
            catch (AWTException e) {
                User32.ReleaseDC(windowHandle, hDC);
                WGL.wglMakeCurrent(currentDc, currentContext);
                WGL.wglDeleteContext(newCtx);
                throw e;
            }
        }
        User32.ReleaseDC(windowHandle, hDC);
        long getInteger = GL.getFunctionProvider().getFunctionAddress("glGetIntegerv");
        long getString = GL.getFunctionProvider().getFunctionAddress("glGetString");
        effective.api = attribs.api;
        if (GLUtil.atLeast30(attribs.majorVersion, attribs.minorVersion)) {
            JNI.callPV(33307, bufferAddr, getInteger);
            effective.majorVersion = MemoryUtil.memGetInt(bufferAddr);
            JNI.callPV(33308, bufferAddr, getInteger);
            effective.minorVersion = MemoryUtil.memGetInt(bufferAddr);
            JNI.callPV(33310, bufferAddr, getInteger);
            int effectiveContextFlags = MemoryUtil.memGetInt(bufferAddr);
            effective.debug = (effectiveContextFlags & 2) != 0;
            effective.forwardCompatible = (effectiveContextFlags & 1) != 0;
            effective.robustness = (effectiveContextFlags & 4) != 0;
        } else if (attribs.api == GLData.API.GL) {
            APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memUTF8(Checks.check(JNI.callP(7938, getString))));
            effective.majorVersion = version.major;
            effective.minorVersion = version.minor;
        } else if (attribs.api == GLData.API.GLES) {
            APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memUTF8(Checks.check(JNI.callP(7938, getString))));
            effective.majorVersion = version.major;
            effective.minorVersion = version.minor;
        }
        if (attribs.api == GLData.API.GL && GLUtil.atLeast32(effective.majorVersion, effective.minorVersion)) {
            boolean comp;
            JNI.callPV(37158, bufferAddr, getInteger);
            int effectiveProfileMask = MemoryUtil.memGetInt(bufferAddr);
            boolean core = (effectiveProfileMask & 1) != 0;
            boolean bl = comp = (effectiveProfileMask & 2) != 0;
            effective.profile = comp ? GLData.Profile.COMPATIBILITY : (core ? GLData.Profile.CORE : null);
        }
        if (attribs.samples >= 1) {
            JNI.callPV(32937, bufferAddr, getInteger);
            effective.samples = MemoryUtil.memGetInt(bufferAddr);
            JNI.callPV(32936, bufferAddr, getInteger);
            effective.sampleBuffers = MemoryUtil.memGetInt(bufferAddr);
            boolean has_WGL_NV_multisample_coverage = wglExtensionsList.contains("WGL_NV_multisample_coverage");
            if (has_WGL_NV_multisample_coverage) {
                JNI.callPV(36384, bufferAddr, getInteger);
                effective.colorSamplesNV = MemoryUtil.memGetInt(bufferAddr);
            }
        }
        WGL.wglMakeCurrent(currentDc, currentContext);
        return newCtx;
    }

    private static void wglNvSwapGroupAndBarrier(GLData attribs, long bufferAddr, long hDC) throws AWTException {
        long wglQueryMaxSwapGroupsNVAddr = WGL.wglGetProcAddress("wglQueryMaxSwapGroupsNV");
        int success = JNI.callPPPI(hDC, bufferAddr, bufferAddr + 4L, wglQueryMaxSwapGroupsNVAddr);
        int maxGroups = MemoryUtil.memGetInt(bufferAddr);
        if (maxGroups < attribs.swapGroupNV) {
            throw new AWTException("Swap group exceeds maximum group index");
        }
        int maxBarriers = MemoryUtil.memGetInt(bufferAddr + 4L);
        if (maxBarriers < attribs.swapBarrierNV) {
            throw new AWTException("Swap barrier exceeds maximum barrier index");
        }
        if (attribs.swapGroupNV > 0) {
            long wglJoinSwapGroupNVAddr = WGL.wglGetProcAddress("wglJoinSwapGroupNV");
            if (wglJoinSwapGroupNVAddr == 0L) {
                throw new AWTException("WGL_NV_swap_group available but wglJoinSwapGroupNV is NULL");
            }
            success = JNI.callPI(hDC, attribs.swapGroupNV, wglJoinSwapGroupNVAddr);
            if (success == 0) {
                throw new AWTException("Failed to join swap group");
            }
            if (attribs.swapBarrierNV > 0) {
                long wglBindSwapBarrierNVAddr = WGL.wglGetProcAddress("wglBindSwapBarrierNV");
                if (wglBindSwapBarrierNVAddr == 0L) {
                    throw new AWTException("WGL_NV_swap_group available but wglBindSwapBarrierNV is NULL");
                }
                success = JNI.callI(attribs.swapGroupNV, attribs.swapBarrierNV, wglBindSwapBarrierNVAddr);
                if (success == 0) {
                    throw new AWTException("Failed to bind swap barrier. Probably no G-Sync card installed.");
                }
            }
        }
    }

    @Override
    public boolean isCurrent(long context) {
        long ret = WGL.wglGetCurrentContext();
        return ret == context;
    }

    @Override
    public boolean makeCurrent(long context) {
        if (context == 0L) {
            return WGL.wglMakeCurrent(0L, 0L);
        }
        long hdc = User32.GetDC(this.hwnd);
        if (hdc == 0L) {
            return false;
        }
        boolean ret = WGL.wglMakeCurrent(hdc, context);
        User32.ReleaseDC(this.hwnd, hdc);
        return ret;
    }

    @Override
    public boolean deleteContext(long context) {
        return WGL.wglDeleteContext(context);
    }

    @Override
    public boolean swapBuffers() {
        long hdc = User32.GetDC(this.hwnd);
        if (hdc == 0L) {
            return false;
        }
        boolean ret = GDI32.SwapBuffers(hdc);
        User32.ReleaseDC(this.hwnd, hdc);
        return ret;
    }

    @Override
    public boolean delayBeforeSwapNV(float seconds) {
        if (!this.wglDelayBeforeSwapNVAddr_set) {
            this.wglDelayBeforeSwapNVAddr = WGL.wglGetProcAddress("wglDelayBeforeSwapNV");
            this.wglDelayBeforeSwapNVAddr_set = true;
        }
        if (this.wglDelayBeforeSwapNVAddr == 0L) {
            throw new UnsupportedOperationException("wglDelayBeforeSwapNV is unavailable");
        }
        long hDC = User32.GetDC(this.hwnd);
        int ret = JNI.callPI(hDC, seconds, this.wglDelayBeforeSwapNVAddr);
        User32.ReleaseDC(this.hwnd, hDC);
        return ret == 1;
    }

    @Override
    public void lock() throws AWTException {
        int lock = JAWTFunctions.JAWT_DrawingSurface_Lock(this.ds, this.ds.Lock());
        if ((lock & 1) != 0) {
            throw new AWTException("JAWT_DrawingSurface_Lock() failed");
        }
    }

    @Override
    public void unlock() throws AWTException {
        JAWTFunctions.JAWT_DrawingSurface_Unlock(this.ds, this.ds.Unlock());
    }

    @Override
    public void dispose() {
        JAWTFunctions.JAWT_FreeDrawingSurface(this.ds, awt.FreeDrawingSurface());
        this.ds = null;
    }

    static {
        awt.version(65540);
        if (!JAWTFunctions.JAWT_GetAWT(awt)) {
            throw new AssertionError((Object)"GetAWT failed");
        }
    }
}

