/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLX13;
import org.lwjgl.opengl.GLXARBCreateContext;
import org.lwjgl.opengl.awt.GLData;
import org.lwjgl.opengl.awt.PlatformGLCanvas;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.jawt.JAWT;
import org.lwjgl.system.jawt.JAWTDrawingSurface;
import org.lwjgl.system.jawt.JAWTFunctions;
import org.lwjgl.system.linux.X11;

public class PlatformLinuxGLCanvas
implements PlatformGLCanvas {
    public static final JAWT awt = JAWT.calloc();
    public long display;
    public long drawable;
    public JAWTDrawingSurface ds;

    private long create(int depth, GLData attribs, GLData effective) throws AWTException {
        long context;
        int screen = X11.XDefaultScreen(this.display);
        IntBuffer attrib_list = BufferUtils.createIntBuffer(32);
        attrib_list.put(32784).put(1);
        attrib_list.put(32785).put(1);
        attrib_list.put(8).put(attribs.redSize);
        attrib_list.put(9).put(attribs.greenSize);
        attrib_list.put(10).put(attribs.blueSize);
        attrib_list.put(12).put(attribs.depthSize);
        attrib_list.put(5).put(attribs.doubleBuffer ? 1 : 0);
        attrib_list.put(0);
        attrib_list.flip();
        PointerBuffer fbConfigs = GLX13.glXChooseFBConfig(this.display, screen, attrib_list);
        if (fbConfigs == null || fbConfigs.capacity() == 0) {
            throw new AWTException("No supported framebuffer configurations found");
        }
        PlatformLinuxGLCanvas.verifyGLXCapabilities(this.display, screen, attribs);
        IntBuffer gl_attrib_list = PlatformLinuxGLCanvas.bufferGLAttribs(attribs);
        long share_context = 0L;
        if (Objects.nonNull(attribs.shareContext)) {
            if (attribs.shareContext.context == 0L) {
                throw new IllegalStateException("Attributes specified shareContext but it is not yet created and thus cannot be shared");
            }
            share_context = attribs.shareContext.context;
        }
        if ((context = GLXARBCreateContext.glXCreateContextAttribsARB(this.display, fbConfigs.get(0), share_context, true, gl_attrib_list)) == 0L) {
            throw new AWTException("Unable to create GLX context");
        }
        PlatformLinuxGLCanvas.populateEffectiveGLXAttribs(this.display, fbConfigs.get(0), effective);
        if (!this.makeCurrent(context)) {
            throw new AWTException("Unable to make context current");
        }
        PlatformLinuxGLCanvas.populateEffectiveGLAttribs(effective);
        this.makeCurrent(0L);
        return context;
    }

    @Override
    public void lock() throws AWTException {
        int lock = JAWTFunctions.JAWT_DrawingSurface_Lock(this.ds, this.ds.Lock());
        if ((lock & 1) != 0) {
            throw new AWTException("JAWT_DrawingSurface_Lock() failed");
        }
    }

    @Override
    public void unlock() throws AWTException {
        JAWTFunctions.JAWT_DrawingSurface_Unlock(this.ds, this.ds.Unlock());
    }

    /*
     * Exception decompiling
     */
    @Override
    public long create(Canvas canvas, GLData attribs, GLData effective) throws AWTException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean deleteContext(long context) {
        return false;
    }

    @Override
    public boolean makeCurrent(long context) {
        if (context == 0L) {
            return GLX13.glXMakeCurrent(this.display, 0L, 0L);
        }
        return GLX13.glXMakeCurrent(this.display, this.drawable, context);
    }

    @Override
    public boolean isCurrent(long context) {
        return GLX13.glXGetCurrentContext() == context;
    }

    @Override
    public boolean swapBuffers() {
        GLX13.glXSwapBuffers(this.display, this.drawable);
        return true;
    }

    @Override
    public boolean delayBeforeSwapNV(float seconds) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void dispose() {
        if (this.ds != null) {
            JAWTFunctions.JAWT_FreeDrawingSurface(this.ds, awt.FreeDrawingSurface());
            this.ds = null;
        }
    }

    private static void verifyGLXCapabilities(long display, int screen, GLData data) throws AWTException {
        List<String> extensions = Arrays.asList(GLX13.glXQueryExtensionsString(display, screen).split(" "));
        if (!extensions.contains("GLX_ARB_create_context")) {
            throw new AWTException("GLX_ARB_create_context is unavailable");
        }
        if (data.api == GLData.API.GLES && !extensions.contains("GLX_EXT_create_context_es_profile")) {
            throw new AWTException("OpenGL ES API requested but GLX_EXT_create_context_es_profile is unavailable");
        }
        if (data.profile != null && !extensions.contains("GLX_ARB_create_context_profile")) {
            throw new AWTException("OpenGL profile requested but GLX_ARB_create_context_profile is unavailable");
        }
        if (data.robustness && !extensions.contains("GLX_ARB_create_context_robustness")) {
            throw new AWTException("OpenGL robustness requested but GLX_ARB_create_context_robustness is unavailable");
        }
        if (data.contextResetIsolation && !extensions.contains("GLX_ARB_robustness_application_isolation")) {
            throw new AWTException("OpenGL robustness requested but GLX_ARB_robustness_application_isolation is unavailable");
        }
    }

    private static IntBuffer bufferGLAttribs(GLData data) throws AWTException {
        IntBuffer gl_attrib_list = BufferUtils.createIntBuffer(32);
        gl_attrib_list.put(32785).put(32788);
        if (data.majorVersion > 0) {
            gl_attrib_list.put(8337).put(data.majorVersion).put(8338).put(data.minorVersion);
        }
        int profile_attrib = -1;
        if (data.api == GLData.API.GLES) {
            if (data.profile != null) {
                throw new AWTException("Cannot request both OpenGL ES and profile: " + (Object)((Object)data.profile));
            }
            profile_attrib = 4;
        } else if (data.api == GLData.API.GL || data.api == null) {
            if (data.profile == GLData.Profile.CORE) {
                profile_attrib = 1;
            } else if (data.profile == GLData.Profile.COMPATIBILITY) {
                profile_attrib = 2;
            } else if (data.profile != null) {
                throw new AWTException("Unknown requested profile: " + (Object)((Object)data.profile));
            }
        } else {
            throw new AWTException("Unknown requested API: " + (Object)((Object)data.api));
        }
        if (profile_attrib != -1) {
            gl_attrib_list.put(37158).put(profile_attrib);
        }
        int context_flags = 0;
        if (data.debug) {
            context_flags |= 1;
        }
        if (data.forwardCompatible) {
            context_flags |= 2;
        }
        if (data.robustness) {
            int notificationStrategy;
            context_flags |= 4;
            if (data.loseContextOnReset) {
                notificationStrategy = 33362;
                if (data.contextResetIsolation) {
                    context_flags |= 8;
                }
            } else {
                notificationStrategy = 33377;
            }
            gl_attrib_list.put(33366).put(notificationStrategy);
        }
        gl_attrib_list.put(8340).put(context_flags);
        gl_attrib_list.put(0).flip();
        return gl_attrib_list;
    }

    private static void populateEffectiveGLXAttribs(long display, long fbId, GLData effective) throws AWTException {
        IntBuffer buffer = BufferUtils.createIntBuffer(1);
        GLX13.glXGetFBConfigAttrib(display, fbId, 8, buffer);
        effective.redSize = buffer.get(0);
        GLX13.glXGetFBConfigAttrib(display, fbId, 9, buffer);
        effective.greenSize = buffer.get(0);
        GLX13.glXGetFBConfigAttrib(display, fbId, 10, buffer);
        effective.blueSize = buffer.get(0);
        GLX13.glXGetFBConfigAttrib(display, fbId, 12, buffer);
        effective.depthSize = buffer.get(0);
        GLX13.glXGetFBConfigAttrib(display, fbId, 5, buffer);
        effective.doubleBuffer = buffer.get(0) == 1;
    }

    private static void populateEffectiveGLAttribs(GLData effective) throws AWTException {
        long glGetIntegerv = GL.getFunctionProvider().getFunctionAddress("glGetIntegerv");
        long glGetString = GL.getFunctionProvider().getFunctionAddress("glGetString");
        APIUtil.APIVersion version = APIUtil.apiParseVersion(PlatformLinuxGLCanvas.getString(7938, glGetString));
        effective.majorVersion = version.major;
        effective.minorVersion = version.minor;
        int profileFlags = PlatformLinuxGLCanvas.getInteger(37158, glGetIntegerv);
        effective.api = (profileFlags & 4) != 0 ? GLData.API.GLES : GLData.API.GL;
        if (version.major >= 3) {
            int effectiveContextFlags;
            if (version.major >= 4 || version.minor >= 2) {
                if ((profileFlags & 1) != 0) {
                    effective.profile = GLData.Profile.CORE;
                } else if ((profileFlags & 2) != 0) {
                    effective.profile = GLData.Profile.COMPATIBILITY;
                } else if ((profileFlags & 4) == 0 && profileFlags != 0) {
                    throw new AWTException("Unknown profile " + profileFlags);
                }
            }
            effective.debug = ((effectiveContextFlags = PlatformLinuxGLCanvas.getInteger(33310, glGetIntegerv)) & 2) != 0;
            effective.forwardCompatible = (effectiveContextFlags & 1) != 0;
            effective.robustness = (effectiveContextFlags & 4) != 0;
            boolean bl = effective.contextResetIsolation = (effectiveContextFlags & 8) != 0;
        }
        if (effective.robustness) {
            int effectiveNotificationStrategy = PlatformLinuxGLCanvas.getInteger(33366, glGetIntegerv);
            effective.loseContextOnReset = (effectiveNotificationStrategy & 0x8252) != 0;
        }
        effective.samples = PlatformLinuxGLCanvas.getInteger(32937, glGetIntegerv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getInteger(int pname, long function) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            JNI.callPV(pname, MemoryUtil.memAddress(params), function);
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    private static String getString(int pname, long function) {
        return MemoryUtil.memUTF8(Checks.check(JNI.callP(pname, function)));
    }

    static {
        awt.version(65540);
        if (!JAWTFunctions.JAWT_GetAWT(awt)) {
            throw new AssertionError((Object)"GetAWT failed");
        }
    }
}

