/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.util.concurrent.Callable;
import org.lwjgl.awthacks.NonClearGraphics;
import org.lwjgl.awthacks.NonClearGraphics2D;
import org.lwjgl.opengl.awt.GLData;
import org.lwjgl.opengl.awt.PlatformGLCanvas;
import org.lwjgl.opengl.awt.PlatformLinuxGLCanvas;
import org.lwjgl.opengl.awt.PlatformMacOSXGLCanvas;
import org.lwjgl.opengl.awt.PlatformWin32GLCanvas;
import org.lwjgl.system.Platform;

public abstract class AWTGLCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    protected PlatformGLCanvas platformCanvas = AWTGLCanvas.createPlatformCanvas();
    protected long context;
    protected final GLData data;
    protected final GLData effective = new GLData();
    protected boolean initCalled;
    private int framebufferWidth;
    private int framebufferHeight;
    private final ComponentListener listener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            AffineTransform t = AWTGLCanvas.this.getGraphicsConfiguration().getDefaultTransform();
            float sx = (float)t.getScaleX();
            float sy = (float)t.getScaleY();
            AWTGLCanvas.this.framebufferWidth = (int)((float)AWTGLCanvas.this.getWidth() * sx);
            AWTGLCanvas.this.framebufferHeight = (int)((float)AWTGLCanvas.this.getHeight() * sy);
        }
    };

    private static PlatformGLCanvas createPlatformCanvas() {
        switch (Platform.get()) {
            case WINDOWS: {
                return new PlatformWin32GLCanvas();
            }
            case LINUX: {
                return new PlatformLinuxGLCanvas();
            }
            case MACOSX: {
                return new PlatformMacOSXGLCanvas();
            }
        }
        throw new UnsupportedOperationException("Platform " + (Object)((Object)Platform.get()) + " not yet supported");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.context = 0L;
        this.initCalled = false;
        this.disposeCanvas();
    }

    @Override
    public synchronized void addComponentListener(ComponentListener l) {
        super.addComponentListener(l);
    }

    public void disposeCanvas() {
        this.platformCanvas.dispose();
    }

    protected AWTGLCanvas(GLData data) {
        this.data = data;
        this.addComponentListener(this.listener);
    }

    protected AWTGLCanvas() {
        this(new GLData());
    }

    protected void beforeRender() {
        if (this.context == 0L) {
            try {
                this.context = this.platformCanvas.create(this, this.data, this.effective);
            }
            catch (AWTException e) {
                throw new RuntimeException("Exception while creating the OpenGL context", e);
            }
        }
        try {
            this.platformCanvas.lock();
        }
        catch (AWTException e) {
            throw new RuntimeException("Failed to lock Canvas", e);
        }
        this.platformCanvas.makeCurrent(this.context);
    }

    protected void afterRender() {
        this.platformCanvas.makeCurrent(0L);
        try {
            this.platformCanvas.unlock();
        }
        catch (AWTException e) {
            throw new RuntimeException("Failed to unlock Canvas", e);
        }
    }

    public <T> T executeInContext(Callable<T> callable) throws Exception {
        this.beforeRender();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.afterRender();
        }
    }

    public void runInContext(Runnable runnable) {
        this.beforeRender();
        try {
            runnable.run();
        }
        finally {
            this.afterRender();
        }
    }

    public void render() {
        this.beforeRender();
        try {
            if (!this.initCalled) {
                this.initGL();
                this.initCalled = true;
            }
            this.paintGL();
        }
        finally {
            this.afterRender();
        }
    }

    public abstract void initGL();

    public abstract void paintGL();

    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public final void swapBuffers() {
        this.platformCanvas.swapBuffers();
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        return graphics instanceof Graphics2D ? new NonClearGraphics2D((Graphics2D)graphics) : new NonClearGraphics(graphics);
    }
}

