/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.awt;

import java.awt.AWTException;
import java.awt.Component;
import org.lwjgl.system.Platform;
import org.lwjgl.system.jawt.JAWT;
import org.lwjgl.system.jawt.JAWTDrawingSurface;
import org.lwjgl.system.jawt.JAWTDrawingSurfaceInfo;
import org.lwjgl.system.jawt.JAWTFunctions;

public class AWT
implements AutoCloseable {
    private final JAWT jawt = JAWT.calloc().version(65543);
    private final JAWTDrawingSurface drawingSurface;
    private final JAWTDrawingSurfaceInfo drawingSurfaceInfo;

    public AWT(Component component) throws AWTException {
        if (!JAWTFunctions.JAWT_GetAWT(this.jawt)) {
            throw new AWTException("Failed to initialize the native JAWT library.");
        }
        this.drawingSurface = JAWTFunctions.JAWT_GetDrawingSurface(component, this.jawt.GetDrawingSurface());
        if (this.drawingSurface == null) {
            throw new AWTException("Failed to get drawing surface.");
        }
        int lock = JAWTFunctions.JAWT_DrawingSurface_Lock(this.drawingSurface, this.drawingSurface.Lock());
        if ((lock & 1) != 0) {
            JAWTFunctions.JAWT_FreeDrawingSurface(this.drawingSurface, this.jawt.FreeDrawingSurface());
            throw new AWTException("Failed to lock the AWT drawing surface.");
        }
        this.drawingSurfaceInfo = JAWTFunctions.JAWT_DrawingSurface_GetDrawingSurfaceInfo(this.drawingSurface, this.drawingSurface.GetDrawingSurfaceInfo());
        if (this.drawingSurfaceInfo == null) {
            JAWTFunctions.JAWT_DrawingSurface_Unlock(this.drawingSurface, this.drawingSurface.Unlock());
            throw new AWTException("Failed to get AWT drawing surface information.");
        }
        long address = this.drawingSurfaceInfo.platformInfo();
        if (address == 0L) {
            throw new AWTException("An unknown error occurred. Failed to retrieve platform-specific information.");
        }
    }

    public static boolean isPlatformSupported() {
        return Platform.get() == Platform.WINDOWS || Platform.get() == Platform.MACOSX || Platform.get() == Platform.LINUX;
    }

    public long getPlatformInfo() {
        return this.drawingSurfaceInfo.platformInfo();
    }

    public JAWTDrawingSurfaceInfo getDrawingSurfaceInfo() {
        return this.drawingSurfaceInfo;
    }

    @Override
    public void close() {
        JAWTFunctions.JAWT_DrawingSurface_FreeDrawingSurfaceInfo(this.drawingSurfaceInfo, this.drawingSurface.FreeDrawingSurfaceInfo());
        JAWTFunctions.JAWT_DrawingSurface_Unlock(this.drawingSurface, this.drawingSurface.Unlock());
        JAWTFunctions.JAWT_FreeDrawingSurface(this.drawingSurface, this.jawt.FreeDrawingSurface());
        this.jawt.free();
    }
}

