/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.Table;

public class SpreadSheet
implements ODDocument {
    private final ODPackage originalFile;
    private final Map<Element, Sheet> sheets;

    private SpreadSheet(Document document, Document document2, ODPackage oDPackage) {
        this.originalFile = oDPackage != null ? oDPackage : new ODPackage();
        this.originalFile.putFile("content.xml", document);
        if (document2 != null) {
            this.originalFile.putFile("styles.xml", document2);
        }
        this.sheets = new HashMap<Element, Sheet>();
    }

    final Document getContent() {
        return this.getPackage().getContent().getDocument();
    }

    @Override
    public final XMLVersion getVersion() {
        return this.getPackage().getVersion();
    }

    private Element getBody() {
        Element element = this.getContent().getRootElement().getChild("body", this.getVersion().getOFFICE());
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            return element;
        }
        return element.getChild("spreadsheet", this.getVersion().getOFFICE());
    }

    private final List<Element> getTables() {
        return this.getBody().getChildren("table", this.getVersion().getTABLE());
    }

    public int getSheetCount() {
        return this.getTables().size();
    }

    public Sheet getSheet(int n) {
        return this.getSheet(this.getTables().get(n));
    }

    public Sheet getSheet(String string) {
        return this.getSheet(string, false);
    }

    public Sheet getSheet(String string, boolean bl) throws NoSuchElementException {
        for (Element element : this.getTables()) {
            if (!string.equals(Table.getName(element))) continue;
            return this.getSheet(element);
        }
        if (bl) {
            throw new NoSuchElementException("no such sheet: " + string);
        }
        return null;
    }

    private final Sheet getSheet(Element element) {
        Sheet sheet = this.sheets.get(element);
        if (sheet == null) {
            sheet = new Sheet(this, element);
            this.sheets.put(element, sheet);
        }
        return sheet;
    }

    void invalidate(Element element) {
        this.sheets.remove(element);
    }

    @Override
    public final ODPackage getPackage() {
        return this.originalFile;
    }
}

