/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.util.IntMapper;

class SSTDeserializer {
    private IntMapper<UnicodeString> strings;

    public SSTDeserializer(IntMapper<UnicodeString> intMapper) {
        this.strings = intMapper;
    }

    public void manufactureStrings(int n, RecordInputStream recordInputStream) {
        for (int i = 0; i < n; ++i) {
            UnicodeString unicodeString;
            if (recordInputStream.available() == 0 && !recordInputStream.hasNextRecord()) {
                System.err.println("Ran out of data before creating all the strings! String at index " + i);
                unicodeString = new UnicodeString("");
            } else {
                unicodeString = new UnicodeString(recordInputStream);
            }
            SSTDeserializer.addToStringTable(this.strings, unicodeString);
        }
    }

    public static void addToStringTable(IntMapper<UnicodeString> intMapper, UnicodeString unicodeString) {
        intMapper.add(unicodeString);
    }
}

