/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import livegps.CirclePanel;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ProjectedCoordinateFormat;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsDialog
extends ToggleDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 6183400754671501117L;
    private boolean statusGPSD;
    private boolean statusNMEA;
    private JLabel statusText;
    private JLabel statusLabel;
    private JLabel nmeaStatusText;
    private JLabel nmeaStatusLabel;
    private JLabel wayLabel;
    private JLabel latText;
    private JLabel latLabel;
    private JLabel longText;
    private JLabel longLabel;
    private JLabel courseLabel;
    private JLabel speedLabel;
    private JLabel wayText;
    private JPanel panel;
    private JPanel opanel;
    private Color backgroundColor;
    private LiveGpsStatus status = new LiveGpsStatus(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting", (Object[])new Object[0]));
    private LiveGpsStatus nmeaStatus = new LiveGpsStatus(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting", (Object[])new Object[0]));
    private LiveGpsData data;
    private CirclePanel circlePanel;
    private static volatile LiveGpsDialog dialog;

    public LiveGpsDialog(MapFrame mapFrame) {
        super(I18n.tr((String)"Live GPS", (Object[])new Object[0]), "livegps", I18n.tr((String)"Show GPS data.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:livegps", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Live GPS", (Object[])new Object[0])}), (int)71, (int)5010), 100);
        dialog = this;
        this.backgroundColor = UIManager.getColor("Panel.background");
        this.opanel = new JPanel();
        this.opanel.setLayout(new BorderLayout());
        this.panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        this.panel.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.3;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.statusText = new JLabel("Status gpsd ");
        this.panel.add((Component)this.statusText, gbc);
        this.nmeaStatusText = new JLabel("Status NMEA ");
        this.panel.add((Component)this.nmeaStatusText, gbc);
        this.wayText = new JLabel("Way Info");
        this.panel.add((Component)this.wayText, gbc);
        this.latText = new JLabel("Latitude");
        this.panel.add((Component)this.latText, gbc);
        this.longText = new JLabel("Longitude");
        this.panel.add((Component)this.longText, gbc);
        this.panel.add((Component)new JLabel(I18n.tr((String)"Speed", (Object[])new Object[0])), gbc);
        this.panel.add((Component)new JLabel(I18n.tr((String)"Course", (Object[])new Object[0])), gbc);
        gbc.weightx = 0.7;
        gbc.gridx = 1;
        gbc.fill = 2;
        this.statusLabel = new JLabel();
        this.panel.add((Component)this.statusLabel, gbc);
        this.nmeaStatusLabel = new JLabel();
        this.panel.add((Component)this.nmeaStatusLabel, gbc);
        this.wayLabel = new JLabel();
        this.panel.add((Component)this.wayLabel, gbc);
        this.latLabel = new JLabel();
        this.panel.add((Component)this.latLabel, gbc);
        this.longLabel = new JLabel();
        this.panel.add((Component)this.longLabel, gbc);
        this.speedLabel = new JLabel();
        this.panel.add((Component)this.speedLabel, gbc);
        this.courseLabel = new JLabel();
        this.panel.add((Component)this.courseLabel, gbc);
        this.opanel.add((Component)this.panel, "North");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LiveGpsDialog.updateCirclePanelVisibility();
            }
        });
        this.circlePanel = new CirclePanel(0.0);
        this.opanel.add((Component)this.circlePanel, "Center");
        this.setStatusVisibility(true);
        if (Config.getPref().getBoolean("livegps.way.offset", false)) {
            this.wayText.setText(I18n.tr((String)"Way Info [m]", (Object[])new Object[0]));
        } else {
            this.wayText.setText(I18n.tr((String)"Way Info", (Object[])new Object[0]));
        }
        this.createLayout(this.opanel, true, null);
    }

    public static void updateCirclePanelVisibility() {
        if (dialog != null) {
            boolean vis = Config.getPref().getBoolean("livegps.distance_visualisation", false);
            LiveGpsDialog.dialog.circlePanel.setVisible(vis);
            LiveGpsDialog.dialog.circlePanel.revalidate();
            LiveGpsDialog.dialog.circlePanel.repaint();
        }
    }

    private void setStatusVisibility(boolean init) {
        boolean statusNMEANew;
        boolean statusGPSDNew;
        boolean bl = statusGPSDNew = !Config.getPref().getBoolean("livegps.gpsd.disabled");
        if (init || this.statusGPSD != statusGPSDNew) {
            this.statusText.setVisible(statusGPSDNew);
            this.statusLabel.setVisible(statusGPSDNew);
            this.statusGPSD = statusGPSDNew;
        }
        boolean bl2 = statusNMEANew = !Config.getPref().get("livegps.serial.port").isEmpty();
        if (init || this.statusNMEA != statusNMEANew) {
            this.nmeaStatusText.setVisible(statusNMEANew);
            this.nmeaStatusLabel.setVisible(statusNMEANew);
            this.statusNMEA = statusNMEANew;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.data = (LiveGpsData)evt.getNewValue();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LiveGpsDialog.this.data.isFix()) {
                        LiveGpsDialog.this.panel.setBackground(LiveGpsDialog.this.backgroundColor);
                        ICoordinateFormat mCord = CoordinateFormatManager.getDefaultFormat();
                        if (ProjectedCoordinateFormat.INSTANCE.equals(mCord)) {
                            LiveGpsDialog.this.latText.setText(I18n.tr((String)"Northing", (Object[])new Object[0]));
                            LiveGpsDialog.this.longText.setText(I18n.tr((String)"Easting", (Object[])new Object[0]));
                        } else {
                            LiveGpsDialog.this.latText.setText(I18n.tr((String)"Latitude", (Object[])new Object[0]));
                            LiveGpsDialog.this.longText.setText(I18n.tr((String)"Longitude", (Object[])new Object[0]));
                        }
                        LiveGpsDialog.this.latLabel.setText(mCord.latToString((ILatLon)LiveGpsDialog.this.data.getLatLon()));
                        LiveGpsDialog.this.longLabel.setText(mCord.lonToString((ILatLon)LiveGpsDialog.this.data.getLatLon()));
                        double mySpeed = LiveGpsDialog.this.data.getSpeed() * 3.6f;
                        LiveGpsDialog.this.speedLabel.setText(I18n.tr((String)"{0} km/h", (Object[])new Object[]{Math.round(mySpeed * 100.0) / 100L}));
                        LiveGpsDialog.this.courseLabel.setText(I18n.tr((String)"{0} deg", (Object[])new Object[]{Float.valueOf(LiveGpsDialog.this.data.getCourse())}));
                        String wayString = LiveGpsDialog.this.data.getWayInfo();
                        if (!wayString.isEmpty()) {
                            LiveGpsDialog.this.wayLabel.setText(I18n.tr((String)"<html><body width={0}>{1}</html>", (Object[])new Object[]{(double)LiveGpsDialog.this.getWidth() * 0.8, wayString}));
                            LiveGpsDialog.this.circlePanel.setOffset(LiveGpsDialog.this.data.getOffset());
                            LiveGpsDialog.this.circlePanel.setBackground(LiveGpsDialog.this.backgroundColor);
                            LiveGpsDialog.this.circlePanel.validate();
                            LiveGpsDialog.this.circlePanel.repaint();
                        } else {
                            LiveGpsDialog.this.wayLabel.setText(I18n.tr((String)"unknown", (Object[])new Object[0]));
                        }
                        if (Config.getPref().getBoolean("livegps.way.offset", false)) {
                            LiveGpsDialog.this.wayText.setText(I18n.tr((String)"Way Info [m]", (Object[])new Object[0]));
                        } else {
                            LiveGpsDialog.this.wayText.setText(I18n.tr((String)"Way Info", (Object[])new Object[0]));
                        }
                    } else {
                        LiveGpsDialog.this.latLabel.setText("");
                        LiveGpsDialog.this.longLabel.setText("");
                        LiveGpsDialog.this.speedLabel.setText("");
                        LiveGpsDialog.this.courseLabel.setText("");
                        LiveGpsDialog.this.panel.setBackground(Color.RED);
                    }
                }
            });
        } else if ("gpsstatus".equals(evt.getPropertyName())) {
            final LiveGpsStatus oldStatus = this.status;
            this.status = (LiveGpsStatus)evt.getNewValue();
            this.setStatusVisibility(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (oldStatus.getStatus() != LiveGpsStatus.GpsStatus.CONNECTION_FAILED || LiveGpsDialog.this.status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTING || LiveGpsDialog.this.nmeaStatus.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                        LiveGpsDialog.this.statusLabel.setText(LiveGpsDialog.this.status.getStatusMessage());
                    }
                    if (LiveGpsDialog.this.status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED && LiveGpsDialog.this.nmeaStatus.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                        LiveGpsDialog.this.panel.setBackground(Color.RED);
                    } else {
                        LiveGpsDialog.this.panel.setBackground(LiveGpsDialog.this.backgroundColor);
                    }
                }
            });
        } else if ("nmeastatus".equals(evt.getPropertyName())) {
            this.nmeaStatus = (LiveGpsStatus)evt.getNewValue();
            this.setStatusVisibility(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveGpsDialog.this.nmeaStatusLabel.setText(LiveGpsDialog.this.nmeaStatus.getStatusMessage());
                }
            });
        }
    }
}

