/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import livegps.LiveGpsDialog;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LiveGPSPreferences
extends DefaultTabPreferenceSetting {
    public static final String C_SERIAL = "livegps.serial.port";
    public static final String DEFAULT_HOST = "localhost";
    public static final String C_HOST = "livegps.gpsd.host";
    public static final int DEFAULT_PORT = 2947;
    public static final String C_PORT = "livegps.gpsd.port";
    public static final String C_DISABLED = "livegps.gpsd.disabled";
    public static final String C_DISTANCE_VISUALISATION = "livegps.distance_visualisation";
    public static final String C_OFFSET_THRESHOLD = "livegps.offset_threshold";
    public static final double DEFAULT_THRESHOLD = 0.3;
    public static final String C_LIVEGPS_COLOR_POSITION = "color.livegps.position";
    public static final String C_LIVEGPS_COLOR_POSITION_ESTIMATE = "color.livegps.position_estimate";
    public static final String C_ALLPOSITIONS = "livegps.positions.all";
    public static final String C_WAYOFFSET = "livegps.way.offset";
    public static final String C_CURSOR_H = "livegps.cursor_height";
    public static final String C_CURSOR_W = "livegps.cursor_width";
    public static final String C_CURSOR_T = "livegps.cursor_thickness";
    public static final int DEFAULT_REFRESH_INTERVAL = 250;
    public static final String C_REFRESH_INTERVAL = "livegps.refresh_interval_msec";
    public static final int DEFAULT_CENTER_INTERVAL = 5000;
    public static final String C_CENTER_INTERVAL = "livegps.center_interval_msec";
    public static final int DEFAULT_CENTER_FACTOR = 80;
    public static final String C_CENTER_FACTOR = "livegps.center_factor";
    private final JTextField gpsdHost = new JTextField(30);
    private final JTextField gpsdPort = new JTextField(30);
    private final JTextField serialDevice = new JTextField(30);
    private final JCheckBox disableGPSD = new JCheckBox(I18n.tr((String)"Disable GPSD", (Object[])new Object[0]));
    private final JCheckBox showOffset = new JCheckBox(I18n.tr((String)"Show Distance to nearest way", (Object[])new Object[0]));
    private final JCheckBox showDistanceVisualisation = new JCheckBox(I18n.tr((String)"Show distance visualisation", (Object[])new Object[0]));
    private final JTextField threshold = new JTextField(5);
    private JLabel thresholdLabel;

    public LiveGPSPreferences() {
        super("dialogs/livegps", I18n.tr((String)"LiveGPS settings", (Object[])new Object[0]), I18n.tr((String)"Here you can change some preferences of LiveGPS plugin", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel(new GridBagLayout());
        this.gpsdHost.setText(Config.getPref().get(C_HOST, DEFAULT_HOST));
        this.gpsdHost.setToolTipText(I18n.tr((String)"Host address of gpsd, default is {0}", (Object[])new Object[]{DEFAULT_HOST}));
        panel.add((Component)new JLabel(I18n.tr((String)"Host address of gpsd", (Object[])new Object[0])), GBC.std());
        panel.add((Component)this.gpsdHost, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.gpsdPort.setText(String.valueOf(Config.getPref().getInt(C_PORT, 2947)));
        this.gpsdPort.setToolTipText(I18n.tr((String)"Port number of gpsd, default is {0}", (Object[])new Object[]{2947}));
        panel.add((Component)new JLabel(I18n.tr((String)"Port number gpsd", (Object[])new Object[0])), GBC.std());
        panel.add((Component)this.gpsdPort, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.disableGPSD.setSelected(Config.getPref().getBoolean(C_DISABLED, false));
        panel.add((Component)this.disableGPSD, GBC.eol().fill(2).insets(0, 0, 0, 5));
        this.serialDevice.setText(Config.getPref().get(C_SERIAL));
        this.serialDevice.setToolTipText(I18n.tr((String)"Serial device for direct NMEA input, does not exist by default.</html>", (Object[])new Object[0]));
        panel.add((Component)new JLabel(I18n.tr((String)"Serial device", (Object[])new Object[0])), GBC.std());
        panel.add((Component)this.serialDevice, GBC.eol().fill(2).insets(5, 0, 0, 5));
        panel.add((Component)new JLabel(I18n.tr((String)"<html>For Linux {0}, {1}, {2} or {3} (<b>x</b> means any number beginning with 0).<br>For Windows {4} to {5} (COM ports bigger than 9 wont work).</html>", (Object[])new Object[]{"/dev/ttyS<b>x</b>", "/dev/ttyACM<b>x</b>", "/dev/ttyUSB<b>x</b>", "/dev/rfcomm<b>x</b>", "COM1", "COM9"})), GBC.eol().fill(2).insets(10, 0, 0, 5));
        this.showOffset.setSelected(Config.getPref().getBoolean(C_WAYOFFSET, false));
        panel.add((Component)this.showOffset, GBC.eol().fill(2).insets(0, 0, 0, 5));
        this.showDistanceVisualisation.setSelected(Config.getPref().getBoolean(C_DISTANCE_VISUALISATION, false));
        panel.add((Component)this.showDistanceVisualisation, GBC.eol().fill(2).insets(0, 0, 0, 5));
        this.threshold.setText(String.valueOf(Config.getPref().getDouble(C_OFFSET_THRESHOLD, 0.3)));
        this.threshold.setToolTipText(I18n.tr((String)"Threshold, default is {0}", (Object[])new Object[]{0.3}));
        this.thresholdLabel = new JLabel(I18n.tr((String)"Threshold", (Object[])new Object[0]));
        panel.add((Component)this.thresholdLabel, GBC.std());
        panel.add((Component)this.threshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.threshold.setVisible(false);
        this.thresholdLabel.setVisible(false);
        this.updateThreshold();
        this.showDistanceVisualisation.addActionListener(e -> this.updateThreshold());
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.createPreferenceTabWithScrollPane(gui, panel);
    }

    private void updateThreshold() {
        boolean isVisible = this.showDistanceVisualisation.isSelected();
        this.threshold.setVisible(isVisible);
        this.thresholdLabel.setVisible(isVisible);
    }

    public boolean ok() {
        Config.getPref().put(C_HOST, this.gpsdHost.getText());
        Config.getPref().put(C_PORT, this.gpsdPort.getText());
        Config.getPref().put(C_SERIAL, this.serialDevice.getText());
        Config.getPref().putBoolean(C_DISABLED, this.disableGPSD.isSelected());
        Config.getPref().putBoolean(C_WAYOFFSET, this.showOffset.isSelected());
        boolean oldVal = Config.getPref().getBoolean(C_DISTANCE_VISUALISATION, false);
        boolean newVal = this.showDistanceVisualisation.isSelected();
        Config.getPref().putBoolean(C_DISTANCE_VISUALISATION, newVal);
        Config.getPref().put(C_OFFSET_THRESHOLD, this.threshold.getText());
        if (oldVal != newVal) {
            LiveGpsDialog.updateCirclePanelVisibility();
        }
        return false;
    }
}

