/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.NumberToTextConverter;

public class HSSFCell
implements Cell {
    private static final String FILE_FORMAT_NAME = "BIFF8";
    public static final int LAST_COLUMN_NUMBER = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
    private static final String LAST_COLUMN_NAME = SpreadsheetVersion.EXCEL97.getLastColumnName();
    private final HSSFWorkbook _book;
    private final HSSFSheet _sheet;
    private int _cellType;
    private HSSFRichTextString _stringValue;
    private CellValueRecordInterface _record;

    @Override
    public HSSFSheet getSheet() {
        return this._sheet;
    }

    @Override
    public HSSFRow getRow() {
        int n = this.getRowIndex();
        return this._sheet.getRow(n);
    }

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, short s, int n2) {
        HSSFCell.checkBounds(s);
        this._cellType = -1;
        this._stringValue = null;
        this._book = hSSFWorkbook;
        this._sheet = hSSFSheet;
        short s2 = hSSFSheet.getSheet().getXFIndexForColAt(s);
        this.setCellType(n2, false, n, s, s2);
    }

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, CellValueRecordInterface cellValueRecordInterface) {
        this._record = cellValueRecordInterface;
        this._cellType = HSSFCell.determineType(cellValueRecordInterface);
        this._stringValue = null;
        this._book = hSSFWorkbook;
        this._sheet = hSSFSheet;
        switch (this._cellType) {
            case 1: {
                this._stringValue = new HSSFRichTextString(hSSFWorkbook.getWorkbook(), (LabelSSTRecord)cellValueRecordInterface);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this._stringValue = new HSSFRichTextString(((FormulaRecordAggregate)cellValueRecordInterface).getStringValue());
            }
        }
        ExtendedFormatRecord extendedFormatRecord = hSSFWorkbook.getWorkbook().getExFormatAt(cellValueRecordInterface.getXFIndex());
        this.setCellStyle(new HSSFCellStyle(cellValueRecordInterface.getXFIndex(), extendedFormatRecord, hSSFWorkbook));
    }

    private static int determineType(CellValueRecordInterface cellValueRecordInterface) {
        if (cellValueRecordInterface instanceof FormulaRecordAggregate) {
            return 2;
        }
        Record record = (Record)((Object)cellValueRecordInterface);
        switch (record.getSid()) {
            case 515: {
                return 0;
            }
            case 513: {
                return 3;
            }
            case 253: {
                return 1;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                return boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        throw new RuntimeException("Bad cell value rec (" + cellValueRecordInterface.getClass().getName() + ")");
    }

    @Override
    public int getRowIndex() {
        return this._record.getRow();
    }

    @Override
    public int getColumnIndex() {
        return this._record.getColumn() & 0xFFFF;
    }

    @Override
    public void setCellType(int n) {
        this.notifyFormulaChanging();
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        int n2 = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        this.setCellType(n, true, n2, s, s2);
    }

    private void setCellType(int n, boolean bl, int n2, short s, short s2) {
        if (n > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (n) {
            case 2: {
                FormulaRecordAggregate formulaRecordAggregate;
                if (n != this._cellType) {
                    formulaRecordAggregate = this._sheet.getSheet().getRowsAggregate().createFormula(n2, s);
                } else {
                    formulaRecordAggregate = (FormulaRecordAggregate)this._record;
                    formulaRecordAggregate.setRow(n2);
                    formulaRecordAggregate.setColumn(s);
                }
                if (bl) {
                    formulaRecordAggregate.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                formulaRecordAggregate.setXFIndex(s2);
                this._record = formulaRecordAggregate;
                break;
            }
            case 0: {
                NumberRecord numberRecord = null;
                numberRecord = n != this._cellType ? new NumberRecord() : (NumberRecord)this._record;
                numberRecord.setColumn(s);
                if (bl) {
                    numberRecord.setValue(this.getNumericCellValue());
                }
                numberRecord.setXFIndex(s2);
                numberRecord.setRow(n2);
                this._record = numberRecord;
                break;
            }
            case 1: {
                LabelSSTRecord labelSSTRecord;
                if (n == this._cellType) {
                    labelSSTRecord = (LabelSSTRecord)this._record;
                } else {
                    labelSSTRecord = new LabelSSTRecord();
                    labelSSTRecord.setColumn(s);
                    labelSSTRecord.setRow(n2);
                    labelSSTRecord.setXFIndex(s2);
                }
                if (bl) {
                    String string = this.convertCellValueToString();
                    int n3 = this._book.getWorkbook().addSSTString(new UnicodeString(string));
                    labelSSTRecord.setSSTIndex(n3);
                    UnicodeString unicodeString = this._book.getWorkbook().getSSTString(n3);
                    this._stringValue = new HSSFRichTextString();
                    this._stringValue.setUnicodeString(unicodeString);
                }
                this._record = labelSSTRecord;
                break;
            }
            case 3: {
                BlankRecord blankRecord = null;
                blankRecord = n != this._cellType ? new BlankRecord() : (BlankRecord)this._record;
                blankRecord.setColumn(s);
                blankRecord.setXFIndex(s2);
                blankRecord.setRow(n2);
                this._record = blankRecord;
                break;
            }
            case 4: {
                BoolErrRecord boolErrRecord = null;
                boolErrRecord = n != this._cellType ? new BoolErrRecord() : (BoolErrRecord)this._record;
                boolErrRecord.setColumn(s);
                if (bl) {
                    boolErrRecord.setValue(this.convertCellValueToBoolean());
                }
                boolErrRecord.setXFIndex(s2);
                boolErrRecord.setRow(n2);
                this._record = boolErrRecord;
                break;
            }
            case 5: {
                BoolErrRecord boolErrRecord = null;
                boolErrRecord = n != this._cellType ? new BoolErrRecord() : (BoolErrRecord)this._record;
                boolErrRecord.setColumn(s);
                if (bl) {
                    boolErrRecord.setValue((byte)15);
                }
                boolErrRecord.setXFIndex(s2);
                boolErrRecord.setRow(n2);
                this._record = boolErrRecord;
            }
        }
        if (n != this._cellType && this._cellType != -1) {
            this._sheet.getSheet().replaceValueRecord(this._record);
        }
        this._cellType = n;
    }

    @Override
    public int getCellType() {
        return this._cellType;
    }

    private void notifyFormulaChanging() {
        if (this._record instanceof FormulaRecordAggregate) {
            ((FormulaRecordAggregate)this._record).notifyFormulaChanging();
        }
    }

    @Override
    public String getCellFormula() {
        if (!(this._record instanceof FormulaRecordAggregate)) {
            throw HSSFCell.typeMismatch(2, this._cellType, true);
        }
        return HSSFFormulaParser.toFormulaString(this._book, ((FormulaRecordAggregate)this._record).getFormulaTokens());
    }

    private static String getCellTypeName(int n) {
        switch (n) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + n + ")#";
    }

    private static RuntimeException typeMismatch(int n, int n2, boolean bl) {
        String string = "Cannot get a " + HSSFCell.getCellTypeName(n) + " value from a " + HSSFCell.getCellTypeName(n2) + " " + (bl ? "formula " : "") + "cell";
        return new IllegalStateException(string);
    }

    private static void checkFormulaCachedValueType(int n, FormulaRecord formulaRecord) {
        int n2 = formulaRecord.getCachedResultType();
        if (n2 != n) {
            throw HSSFCell.typeMismatch(n, n2, true);
        }
    }

    @Override
    public double getNumericCellValue() {
        switch (this._cellType) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return ((NumberRecord)this._record).getValue();
            }
            default: {
                throw HSSFCell.typeMismatch(0, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(0, formulaRecord);
        return formulaRecord.getValue();
    }

    @Override
    public Date getDateCellValue() {
        if (this._cellType == 3) {
            return null;
        }
        double d = this.getNumericCellValue();
        if (this._book.getWorkbook().isUsing1904DateWindowing()) {
            return DateUtil.getJavaDate(d, true);
        }
        return DateUtil.getJavaDate(d, false);
    }

    @Override
    public String getStringCellValue() {
        HSSFRichTextString hSSFRichTextString = this.getRichStringCellValue();
        return hSSFRichTextString.getString();
    }

    @Override
    public HSSFRichTextString getRichStringCellValue() {
        switch (this._cellType) {
            case 3: {
                return new HSSFRichTextString("");
            }
            case 1: {
                return this._stringValue;
            }
            default: {
                throw HSSFCell.typeMismatch(1, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
        HSSFCell.checkFormulaCachedValueType(1, formulaRecordAggregate.getFormulaRecord());
        String string = formulaRecordAggregate.getStringValue();
        return new HSSFRichTextString(string == null ? "" : string);
    }

    private boolean convertCellValueToBoolean() {
        switch (this._cellType) {
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue();
            }
            case 1: {
                int n = ((LabelSSTRecord)this._record).getSSTIndex();
                String string = this._book.getWorkbook().getSSTString(n).getString();
                return Boolean.valueOf(string);
            }
            case 0: {
                return ((NumberRecord)this._record).getValue() != 0.0;
            }
            case 2: {
                FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
                HSSFCell.checkFormulaCachedValueType(4, formulaRecord);
                return formulaRecord.getCachedBooleanValue();
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + this._cellType + ")");
    }

    private String convertCellValueToString() {
        switch (this._cellType) {
            case 3: {
                return "";
            }
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                int n = ((LabelSSTRecord)this._record).getSSTIndex();
                return this._book.getWorkbook().getSSTString(n).getString();
            }
            case 0: {
                return NumberToTextConverter.toText(((NumberRecord)this._record).getValue());
            }
            case 5: {
                return HSSFErrorConstants.getText(((BoolErrRecord)this._record).getErrorValue());
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell type (" + this._cellType + ")");
            }
        }
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
        FormulaRecord formulaRecord = formulaRecordAggregate.getFormulaRecord();
        switch (formulaRecord.getCachedResultType()) {
            case 4: {
                return formulaRecord.getCachedBooleanValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                return formulaRecordAggregate.getStringValue();
            }
            case 0: {
                return NumberToTextConverter.toText(formulaRecord.getValue());
            }
            case 5: {
                return HSSFErrorConstants.getText(formulaRecord.getCachedErrorValue());
            }
        }
        throw new IllegalStateException("Unexpected formula result type (" + this._cellType + ")");
    }

    @Override
    public boolean getBooleanCellValue() {
        switch (this._cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue();
            }
            default: {
                throw HSSFCell.typeMismatch(4, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(4, formulaRecord);
        return formulaRecord.getCachedBooleanValue();
    }

    public void setCellStyle(HSSFCellStyle hSSFCellStyle) {
        hSSFCellStyle.verifyBelongsToWorkbook(this._book);
        this._record.setXFIndex(hSSFCellStyle.getIndex());
    }

    @Override
    public HSSFCellStyle getCellStyle() {
        short s = this._record.getXFIndex();
        ExtendedFormatRecord extendedFormatRecord = this._book.getWorkbook().getExFormatAt(s);
        return new HSSFCellStyle(s, extendedFormatRecord, this._book);
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this._record;
    }

    private static void checkBounds(int n) {
        if (n < 0 || n > LAST_COLUMN_NUMBER) {
            throw new IllegalArgumentException("Invalid column index (" + n + ").  Allowable column range for BIFF8 is (0.." + LAST_COLUMN_NUMBER + ") or ('A'..'" + LAST_COLUMN_NAME + "')");
        }
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(((BoolErrRecord)this._record).getErrorValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                    return simpleDateFormat.format(this.getDateCellValue());
                }
                return String.valueOf(this.getNumericCellValue());
            }
            case 1: {
                return this.getStringCellValue();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    @Override
    public CellRangeAddress getArrayFormulaRange() {
        if (this._cellType != 2) {
            String string = new CellReference(this).formatAsString();
            throw new IllegalStateException("Cell " + string + " is not part of an array formula.");
        }
        return ((FormulaRecordAggregate)this._record).getArrayFormulaRange();
    }

    @Override
    public boolean isPartOfArrayFormulaGroup() {
        if (this._cellType != 2) {
            return false;
        }
        return ((FormulaRecordAggregate)this._record).isPartOfArrayFormula();
    }

    void notifyArrayFormulaChanging(String string) {
        CellRangeAddress cellRangeAddress = this.getArrayFormulaRange();
        if (cellRangeAddress.getNumberOfCells() > 1) {
            throw new IllegalStateException(string);
        }
        this.getRow().getSheet().removeArrayFormula(this);
    }

    void notifyArrayFormulaChanging() {
        CellReference cellReference = new CellReference(this);
        String string = "Cell " + cellReference.formatAsString() + " is part of a multi-cell array formula. You cannot change part of an array.";
        this.notifyArrayFormulaChanging(string);
    }
}

