/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParseException;
import org.openstreetmap.josm.tools.I18n;

public class ModuleListParser {
    protected ModuleInformation createInfo(String name, String url, String manifest) throws ModuleListParseException {
        try {
            return new ModuleInformation(new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8)), name.substring(0, name.length() - 4), url);
        }
        catch (ModuleException e) {
            throw new ModuleListParseException(I18n.tr((String)"Failed to create module information from manifest for module ''{0}''", (Object[])new Object[]{name}), e);
        }
    }

    public List<ModuleInformation> parse(InputStream in) throws ModuleListParseException {
        LinkedList<ModuleInformation> ret = new LinkedList<ModuleInformation>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String name = null;
            String url = null;
            StringBuilder manifest = new StringBuilder();
            Object line = r.readLine();
            while (line != null) {
                if (((String)line).startsWith("\t")) {
                    if (((String)(line = ((String)line).substring(1))).length() > 70) {
                        manifest.append((CharSequence)line, 0, 70).append("\n");
                        line = " " + ((String)line).substring(70);
                    }
                    manifest.append((String)line).append("\n");
                } else {
                    String[] x;
                    ModuleInformation info;
                    if (name != null && (info = this.createInfo(name, url, manifest.toString())) != null) {
                        for (Module module : ModuleHandler.moduleList) {
                            if (!module.getModuleInformation().name.equals(info.getName())) continue;
                            info.localversion = module.getModuleInformation().localversion;
                        }
                        ret.add(info);
                    }
                    if ((x = ((String)line).split(";")).length != 2) {
                        throw new IOException(I18n.tr((String)"Illegal entry in module list.", (Object[])new Object[0]));
                    }
                    name = x[0];
                    url = x[1];
                    manifest = new StringBuilder();
                }
                line = r.readLine();
            }
            if (name != null) {
                ModuleInformation info = this.createInfo(name, url, manifest.toString());
                for (Module module : ModuleHandler.moduleList) {
                    if (!module.getModuleInformation().name.equals(info.getName())) continue;
                    info.localversion = module.getModuleInformation().localversion;
                }
                ret.add(info);
            }
            return ret;
        }
        catch (IOException e) {
            throw new ModuleListParseException(e);
        }
    }
}

