/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JOptionPane;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.geopackage.GeoPackageReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;

public class GeotoolsConverter {
    private final DataStore dataStore;
    private final GeographicReader reader;
    private final Set<OsmPrimitive> featurePrimitives = new HashSet<OsmPrimitive>();

    public GeotoolsConverter(GeographicReader reader, DataStore original) {
        this.dataStore = original;
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(ProgressMonitor progressMonitor) throws IOException, FactoryException, GeoMathTransformException, TransformException, GeoCrsException {
        String[] typeNames = this.dataStore.getTypeNames();
        if (progressMonitor != null) {
            progressMonitor.beginTask(I18n.tr((String)GeotoolsConverter.getLayerMessage(((Object)((Object)this.reader)).getClass()), (Object[])new Object[]{typeNames.length}), typeNames.length);
        }
        try {
            for (String typeName : typeNames) {
                SimpleFeatureSource featureSource = this.dataStore.getFeatureSource(typeName);
                FeatureCollection collection = featureSource.getFeatures();
                try {
                    this.parseFeatures(progressMonitor != null ? progressMonitor.createSubTaskMonitor(1, false) : null, collection);
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() instanceof IOException && runtimeException.getCause().getCause() instanceof ParseException) {
                        Logging.error((Throwable)runtimeException);
                        continue;
                    }
                    throw runtimeException;
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.finishTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFeatures(ProgressMonitor progressMonitor, FeatureCollection<?, ?> collection) throws FactoryException, GeoMathTransformException, TransformException, GeoCrsException {
        if (progressMonitor != null) {
            progressMonitor.beginTask(I18n.tr((String)GeotoolsConverter.getFeatureMessage(((Object)((Object)this.reader)).getClass()), (Object[])new Object[]{collection.size()}), collection.size());
        }
        int n = 0;
        Object parent = progressMonitor != null ? progressMonitor.getWindowParent() : MainApplication.getMainFrame();
        int size = collection.size();
        this.reader.getDataSet().beginUpdate();
        try (FeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                ++n;
                try {
                    Feature feature = iterator.next();
                    this.parseFeature(feature, (Component)parent);
                    if (this.reader.getHandler() instanceof ShpHandler) {
                        ((ShpHandler)this.reader.getHandler()).notifyFeatureParsed(feature, this.reader.getDataSet(), this.featurePrimitives);
                    }
                }
                catch (UserCancelException e) {
                    Logging.error((Throwable)e);
                    if (iterator != null) {
                        iterator.close();
                    }
                    this.reader.nodes.clear();
                    this.reader.getDataSet().endUpdate();
                    if (progressMonitor != null) {
                        progressMonitor.setCustomText(null);
                    }
                    return;
                }
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
                progressMonitor.setCustomText(n + "/" + size);
                if (!progressMonitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            this.reader.nodes.clear();
            this.reader.getDataSet().endUpdate();
            if (progressMonitor != null) {
                progressMonitor.setCustomText(null);
            }
        }
    }

    private static String getLayerMessage(Class<? extends GeographicReader> clazz) {
        if (GeoPackageReader.class.equals(clazz)) {
            return I18n.marktr((String)"Loading GeoPackage ({0} layers)");
        }
        if (GmlReader.class.equals(clazz)) {
            return I18n.marktr((String)"Loading GML ({0} layers)");
        }
        return I18n.marktr((String)"Loading shapefile ({0} layers)");
    }

    private static String getFeatureMessage(Class<? extends GeographicReader> clazz) {
        if (GeoPackageReader.class.equals(clazz)) {
            return I18n.marktr((String)"Loading GeoPackage ({0} features)");
        }
        if (GmlReader.class.equals(clazz)) {
            return I18n.marktr((String)"Loading GML ({0} features)");
        }
        return I18n.marktr((String)"Loading shapefile ({0} features)");
    }

    private void parseFeature(Feature feature, Component parent) throws UserCancelException, GeoMathTransformException, FactoryException, GeoCrsException, MismatchedDimensionException, TransformException {
        this.featurePrimitives.clear();
        GeometryAttribute geometry = feature.getDefaultGeometryProperty();
        if (geometry != null) {
            Object geomObject;
            GeometryDescriptor desc = geometry.getDescriptor();
            if (this.reader.crs == null) {
                if (desc != null && desc.getCoordinateReferenceSystem() != null) {
                    this.reader.crs = desc.getCoordinateReferenceSystem();
                } else if (!GraphicsEnvironment.isHeadless()) {
                    GuiHelper.runInEDTAndWait(() -> {
                        if (0 == JOptionPane.showConfirmDialog(parent, I18n.tr((String)"Unable to detect Coordinate Reference System.\nWould you like to fallback to ESPG:4326 (WGS 84) ?", (Object[])new Object[0]), I18n.tr((String)"Warning: CRS not found", (Object[])new Object[0]), 1)) {
                            this.reader.crs = GeographicReader.wgs84;
                        }
                    });
                } else {
                    this.reader.crs = GeographicReader.wgs84;
                }
                if (this.reader.crs != null) {
                    this.reader.findMathTransform(parent, true);
                } else {
                    throw new GeoCrsException(I18n.tr((String)"Unable to detect CRS !", (Object[])new Object[0]));
                }
            }
            if ((geomObject = geometry.getValue()) instanceof Point) {
                Node primitive = this.reader.createOrGetEmptyNode((Point)geomObject);
                GeotoolsConverter.readNonGeometricAttributes(feature, (OsmPrimitive)primitive);
            } else if (geomObject instanceof LineString) {
                Way primitive = this.reader.createOrGetWay((LineString)geomObject);
                GeotoolsConverter.readNonGeometricAttributes(feature, (OsmPrimitive)primitive);
            } else if (geomObject instanceof Polygon) {
                Way primitive;
                Polygon polygon = (Polygon)geomObject;
                Way outer = this.reader.createOrGetWay((LineString)polygon.getExteriorRing());
                Way[] inner = new Way[polygon.getNumInteriorRing()];
                for (int i = 0; i < inner.length; ++i) {
                    inner[i] = this.reader.createOrGetWay((LineString)polygon.getInteriorRingN(i));
                }
                if (inner.length == 0) {
                    primitive = outer;
                } else {
                    Relation relation = this.reader.createMultipolygon();
                    GeographicReader.addWayToMp(relation, "outer", outer);
                    for (Way iWay : inner) {
                        GeographicReader.addWayToMp(relation, "inner", iWay);
                    }
                    primitive = relation;
                }
                GeotoolsConverter.readNonGeometricAttributes(feature, (OsmPrimitive)primitive);
            } else if (geomObject instanceof GeometryCollection) {
                Set<OsmPrimitive> primitives = this.processGeometryCollection((GeometryCollection)geomObject);
                for (OsmPrimitive prim : primitives) {
                    GeotoolsConverter.readNonGeometricAttributes(feature, prim);
                }
            } else {
                Logging.debug((String)("\ttype: " + geometry.getType()));
                Logging.debug((String)("\tbounds: " + geometry.getBounds()));
                Logging.debug((String)("\tdescriptor: " + desc));
                Logging.debug((String)("\tname: " + geometry.getName()));
                Logging.debug((String)("\tvalue: " + geomObject));
                Logging.debug((String)("\tid: " + geometry.getIdentifier()));
                Logging.debug((String)"-------------------------------------------------------------");
            }
        }
    }

    protected Set<OsmPrimitive> processGeometryCollection(GeometryCollection gc) throws TransformException {
        HashSet<OsmPrimitive> primitives = new HashSet<OsmPrimitive>();
        int nGeometries = gc.getNumGeometries();
        if (nGeometries < 1) {
            Logging.error((String)"empty geometry collection found");
        } else {
            for (int i = 0; i < nGeometries; ++i) {
                Way op = null;
                Geometry g = gc.getGeometryN(i);
                if (g instanceof Polygon) {
                    Relation r = (Relation)op;
                    Polygon p = (Polygon)g;
                    if (r == null && (nGeometries > 1 || p.getNumInteriorRing() > 0 || this.reader.getHandler() != null && this.reader.getHandler().preferMultipolygonToSimpleWay())) {
                        r = this.reader.createMultipolygon();
                    }
                    Way w = this.reader.createOrGetWay((LineString)p.getExteriorRing());
                    if (r != null) {
                        GeographicReader.addWayToMp(r, "outer", w);
                        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                            GeographicReader.addWayToMp(r, "inner", this.reader.createOrGetWay((LineString)p.getInteriorRingN(j)));
                        }
                    }
                    op = r != null ? r : w;
                } else if (g instanceof LineString) {
                    op = this.reader.createOrGetWay((LineString)g);
                } else if (g instanceof Point) {
                    op = this.reader.createOrGetNode((Point)g);
                } else {
                    Logging.error((String)("unsupported geometry : " + g));
                }
                if (op == null) continue;
                primitives.add((OsmPrimitive)op);
            }
        }
        return primitives;
    }

    private static void readNonGeometricAttributes(Feature feature, OsmPrimitive primitive) {
        Collection properties = feature.getProperties();
        LinkedHashMap<String, String> tagMap = new LinkedHashMap<String, String>(properties.size());
        for (Property prop : properties) {
            if (prop instanceof GeometryAttribute) continue;
            Name name = prop.getName();
            Object value = prop.getValue();
            if (name == null || value == null) continue;
            String sName = name.toString();
            String sValue = value.toString();
            if (value instanceof Date) {
                sValue = new SimpleDateFormat("yyyy-MM-dd").format(value);
            }
            if (sName.isEmpty() || sValue.isEmpty()) continue;
            tagMap.put(sName, sValue);
        }
        primitive.putAll(tagMap);
    }
}

