/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public class StringUtil {
    private static final String ENCODING_ISO_8859_1 = "ISO-8859-1";

    private StringUtil() {
    }

    public static String readCompressedUnicode(LittleEndianInput littleEndianInput, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)littleEndianInput.readUByte();
        }
        return new String(cArray);
    }

    public static String readUnicodeString(LittleEndianInput littleEndianInput) {
        int n = littleEndianInput.readUShort();
        byte by = littleEndianInput.readByte();
        if ((by & 1) == 0) {
            return StringUtil.readCompressedUnicode(littleEndianInput, n);
        }
        return StringUtil.readUnicodeLE(littleEndianInput, n);
    }

    public static String readUnicodeString(LittleEndianInput littleEndianInput, int n) {
        byte by = littleEndianInput.readByte();
        if ((by & 1) == 0) {
            return StringUtil.readCompressedUnicode(littleEndianInput, n);
        }
        return StringUtil.readUnicodeLE(littleEndianInput, n);
    }

    public static void writeUnicodeString(LittleEndianOutput littleEndianOutput, String string) {
        int n = string.length();
        littleEndianOutput.writeShort(n);
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    public static void writeUnicodeStringFlagAndData(LittleEndianOutput littleEndianOutput, String string) {
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    public static int getEncodedSize(String string) {
        int n = 3;
        return n += string.length() * (StringUtil.hasMultibyte(string) ? 2 : 1);
    }

    public static void putCompressedUnicode(String string, LittleEndianOutput littleEndianOutput) {
        byte[] byArray;
        try {
            byArray = string.getBytes(ENCODING_ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        littleEndianOutput.write(byArray);
    }

    public static void putUnicodeLE(String string, LittleEndianOutput littleEndianOutput) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        littleEndianOutput.write(byArray);
    }

    public static String readUnicodeLE(LittleEndianInput littleEndianInput, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)littleEndianInput.readUShort();
        }
        return new String(cArray);
    }

    public static String format(String string, Object[] objectArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%') {
                if (n >= objectArray.length) {
                    stringBuffer.append("?missing data?");
                    continue;
                }
                if (objectArray[n] instanceof Number && i + 1 < string.length()) {
                    i += StringUtil.matchOptionalFormatting((Number)objectArray[n++], string.substring(i + 1), stringBuffer);
                    continue;
                }
                stringBuffer.append(objectArray[n++].toString());
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == '%') {
                stringBuffer.append('%');
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static int matchOptionalFormatting(Number number, String string, StringBuffer stringBuffer) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (0 < string.length() && Character.isDigit(string.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt("" + string.charAt(0)));
            if (2 < string.length() && string.charAt(1) == '.' && Character.isDigit(string.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt("" + string.charAt(2)));
                numberFormat.format(number, stringBuffer, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 1;
        }
        if (0 < string.length() && string.charAt(0) == '.' && 1 < string.length() && Character.isDigit(string.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt("" + string.charAt(1)));
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, stringBuffer, new FieldPosition(0));
        return 1;
    }

    public static boolean hasMultibyte(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }
}

