/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geotools;

import com.sun.media.jai.imageioimpl.ImageReadWriteSpi;
import it.geosolutions.imageio.compression.CompressionRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.Logging;

public class GeoToolsPlugin
extends Plugin {
    public GeoToolsPlugin(PluginInformation info) {
        super(info);
        GeoToolsPlugin.initJAI();
        GeoToolsPlugin.initGeoTools();
        GeoToolsPlugin.checkEPSG();
    }

    private static void initJAI() {
        OperationRegistry registry;
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        if (ImageWorker.isJaiExtEnabled()) {
            Logging.debug((String)"geotools: load JAI-Ext operations");
        }
        if ((registry = JAI.getDefaultInstance().getOperationRegistry()) == null) {
            Logging.error((String)"geotools: error in JAI initialization. Cannot access default operation registry");
        } else {
            try {
                new ImageReadWriteSpi().updateRegistry(registry);
            }
            catch (IllegalArgumentException e) {
                Logging.warn((String)("geotools: error in JAI/ImageReadWriteSpi initialization: " + e.getMessage()));
            }
            try (InputStream in = GeoToolsPlugin.class.getResourceAsStream("/META-INF/registryFile.jai");){
                if (in == null) {
                    Logging.error((String)"geotools: error in JAI initialization. Cannot access META-INF/registryFile.jai");
                } else {
                    registry.updateFromStream(in);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Logging.error((String)("geotools: error in JAI/GeoTools initialization: " + e.getMessage()));
            }
        }
        IIORegistry ioRegistry = IIORegistry.getDefaultInstance();
        ClassLoader loader = GeoToolsPlugin.class.getClassLoader();
        Iterator<Class<?>> categories = ioRegistry.getCategories();
        while (categories.hasNext()) {
            for (IIOServiceProvider provider : ServiceLoader.load(categories.next(), loader)) {
                Logging.debug((String)("Registering " + provider.getClass()));
                ioRegistry.registerServiceProvider(provider);
            }
        }
    }

    private static void initGeoTools() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        CompressionRegistry.getDefaultInstance().registerApplicationClasspathSpis();
    }

    private static void checkEPSG() {
        Set<String> codes = CRS.getSupportedCodes("EPSG");
        if (codes.isEmpty() || !codes.contains("4326") && !codes.contains("EPSG:4326")) {
            try {
                CRS.decode("EPSG:4326");
            }
            catch (NoSuchAuthorityCodeException e) {
                Logging.error((String)("geotools: error in EPSG database initialization. NoSuchAuthorityCodeException: " + e.getMessage()));
            }
            catch (FactoryException e) {
                Logging.error((String)("geotools: error in EPSG database initialization. FactoryException: " + e.getMessage()));
            }
        }
    }
}

