/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.util.regex.Pattern;

public class Text {
    static Pattern WHITESPACE = Pattern.compile("\\s+", 8);
    static Pattern LEADING = Pattern.compile("^\\s+");
    static Pattern TRAILING = Pattern.compile("\\s+$");
    static Pattern INNER = Pattern.compile("\\s{2,}");
    String value;

    public Text() {
        this(null);
    }

    public Text(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isWhitespace() {
        return WHITESPACE.matcher(this.value).matches();
    }

    public void trimLeading() {
        this.value = LEADING.matcher(this.value).replaceAll("");
    }

    public void trimTrailing() {
        this.value = TRAILING.matcher(this.value).replaceAll("");
    }

    public void trimInner() {
        this.value = INNER.matcher(this.value).replaceAll(" ");
    }

    public String toString() {
        return this.value;
    }
}

